MACRO (FINDAVCODEC _lib)


FIND_PATH(AVCODEC_INCLUDE_DIR_FF "ffmpeg/avcodec.h" PATHS)

SET (FFMPEG_INCLUDE_DIR "")

IF (AVCODEC_INCLUDE_DIR_FF)
      SET (AVCODEC_INCLUDE_DIR "${AVCODEC_INCLUDE_DIR_FF}/ffmpeg")
ELSE (AVCODEC_INCLUDE_DIR_FF)
      FIND_PATH(AVCODEC_INCLUDE_DIR_LAVC "libavcodec/avcodec.h" PATHS)
      IF (AVCODEC_INCLUDE_DIR_LAVC)
          SET (AVCODEC_INCLUDE_DIR "${AVCODEC_INCLUDE_DIR_LAVC}/libavcodec")
      ELSE (AVCODEC_INCLUDE_DIR_LAVC)
	  FIND_PATH(AVCODEC_INCLUDE_DIR_FF_LAVC "ffmpeg/libavcodec/avcodec.h" PATHS)
	  IF (AVCODEC_INCLUDE_DIR_FF_LAVC)
	    SET (AVCODEC_INCLUDE_DIR "${AVCODEC_INCLUDE_DIR_FF_LAVC}/ffmpeg/libavcodec")
	    SET (FFMPEG_INCLUDE_DIR "${AVCODEC_INCLUDE_DIR_FF_LAVC}/ffmpeg")
	  ENDIF (AVCODEC_INCLUDE_DIR_FF_LAVC)
      ENDIF (AVCODEC_INCLUDE_DIR_LAVC)
ENDIF (AVCODEC_INCLUDE_DIR_FF)

FIND_LIBRARY(AVCODEC_LIBRARY NAMES ${_lib} PATHS ) 

IF (AVCODEC_INCLUDE_DIR AND AVCODEC_LIBRARY)
   SET(INC_FOUND TRUE)
ELSE (AVCODEC_INCLUDE_DIR AND AVCODEC_LIBRARY)
      SET(INC_FOUND FALSE)
ENDIF (AVCODEC_INCLUDE_DIR AND AVCODEC_LIBRARY)


IF (INC_FOUND)
      MESSAGE(STATUS "Found include avcodec.h: ${AVCODEC_INCLUDE_DIR}")
      MESSAGE(STATUS "Found library ${_lib}: ${AVCODEC_LIBRARY}")
ELSE (INC_FOUND)
      MESSAGE(FATAL_ERROR "Could not find ${_lib}")
ENDIF (INC_FOUND)
ENDMACRO (FINDAVCODEC _lib )