#ifndef MODULE_BITMAP_BITMAP_COMPOSITE_H
#define MODULE_BITMAP_BITMAP_COMPOSITE_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <k3dsdk/ibitmap_sink.h>
#include <k3dsdk/ibitmap_source.h>
#include <k3dsdk/property_collection.h>
#include <k3dsdk/bitmap.h>

namespace libk3dbitmap
{

template<typename base_t>
class bitmap_composite :
	public base_t,
	public k3d::ibitmap_source,
	public k3d::ibitmap_sink
{
public:
	bitmap_composite(k3d::idocument& Document) :
		base_t(Document),
		m_bitmap_a(init_owner(*this) + init_name("input_a") + init_label(_("Input A")) + init_description(_("A input bitmap")) + init_value<k3d::bitmap*>(0)),
		m_bitmap_b(init_owner(*this) + init_name("input_b") + init_label(_("Input B")) + init_description(_("B input bitmap")) + init_value<k3d::bitmap*>(0)),
		m_bitmap_o(init_owner(*this) + init_name("output") + init_label(_("Output Bitmap")) + init_description(_("Output bitmap")) + init_slot(sigc::mem_fun(*this, &bitmap_composite<base_t>::on_create_bitmap)))
	{
	}

	k3d::iproperty& bitmap_source_output()
	{
		return m_bitmap_o;
	}

	k3d::iproperty& bitmap_sink_input()
	{
		return m_bitmap_a;
	}

protected:
	virtual void on_create_bitmap(k3d::bitmap& Bitmap) = 0;
	
	k3d_data(k3d::bitmap*, immutable_name, change_signal, no_undo, local_storage, no_constraint, writable_property, no_serialization) m_bitmap_a;
	k3d_data(k3d::bitmap*, immutable_name, change_signal, no_undo, local_storage, no_constraint, writable_property, no_serialization) m_bitmap_b;
	k3d_data(k3d::bitmap*, immutable_name, change_signal, no_undo, demand_storage, no_constraint, read_only_property, no_serialization) m_bitmap_o;
};

} // namespace libk3dbitmap

#endif // !MODULE_BITMAP_BITMAP_COMPOSITE_H

