#ifndef K3DSDK_MESH_SOURCE_H
#define K3DSDK_MESH_SOURCE_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "data.h"
#include "imesh_source.h"
#include "mesh.h"

namespace k3d
{

template<typename base_t>
class mesh_source :
	public base_t,
	public imesh_source
{
public:
	mesh_source(idocument& Document) :
		base_t(Document),
		m_output_mesh(init_owner(*this) + init_name("output_mesh") + init_label(_("Output Mesh")) + init_description("Output mesh") + init_slot(sigc::mem_fun(*this, &mesh_source<base_t>::create_mesh)))
	{
	}

	iproperty& mesh_source_output()
	{
		return m_output_mesh;
	}

	sigc::slot1<void, iunknown*> make_reset_mesh_slot()
	{
		return m_output_mesh.make_reset_slot();
	}

	sigc::slot1<void, iunknown*> make_update_mesh_slot()
	{
		return sigc::mem_fun(*this, &mesh_source<base_t>::update_mesh);
	}

protected:
	k3d_data(mesh*, data::immutable_name, data::change_signal, data::no_undo, data::demand_storage, data::no_constraint, data::read_only_property, data::no_serialization) m_output_mesh;

private:
	void create_mesh(mesh& Mesh)
	{
		on_create_mesh(Mesh);
		on_update_mesh(Mesh);
	}

	void update_mesh(iunknown* const Hint)
	{
		if(mesh* const output_mesh = m_output_mesh.internal_value())
		{
			on_update_mesh(*output_mesh);
			m_output_mesh.changed_signal().emit(Hint);
		}
	}

	virtual void on_create_mesh(mesh& Mesh) = 0;
	virtual void on_update_mesh(mesh& Mesh) = 0;
};

} // namespace k3d

#endif // !K3DSDK_MESH_SOURCE_H

