/** @file hash_fastq_merge_cmdline.hpp
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.4
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef HASH_FASTQ_MERGE_CMDLINE_H
#define HASH_FASTQ_MERGE_CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef HASH_FASTQ_MERGE_CMDLINE_PACKAGE
/** @brief the program name (used for printing errors) */
#define HASH_FASTQ_MERGE_CMDLINE_PACKAGE "jellyfish merge"
#endif

#ifndef HASH_FASTQ_MERGE_CMDLINE_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define HASH_FASTQ_MERGE_CMDLINE_PACKAGE_NAME "jellyfish merge"
#endif

#ifndef HASH_FASTQ_MERGE_CMDLINE_VERSION
/** @brief the program version */
#define HASH_FASTQ_MERGE_CMDLINE_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct hash_fastq_merge_args
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  long size_arg;	/**< @brief Merged hash table size.  */
  char * size_orig;	/**< @brief Merged hash table size original value given at command line.  */
  const char *size_help; /**< @brief Merged hash table size help description.  */
  int mer_len_arg;	/**< @brief Mer length.  */
  char * mer_len_orig;	/**< @brief Mer length original value given at command line.  */
  const char *mer_len_help; /**< @brief Mer length help description.  */
  char * output_arg;	/**< @brief Output file (default='merged.jf').  */
  char * output_orig;	/**< @brief Output file original value given at command line.  */
  const char *output_help; /**< @brief Output file help description.  */
  int reprobes_arg;	/**< @brief Maximum number of reprobes (default='62').  */
  char * reprobes_orig;	/**< @brief Maximum number of reprobes original value given at command line.  */
  const char *reprobes_help; /**< @brief Maximum number of reprobes help description.  */
  long out_buffer_size_arg;	/**< @brief Size of output buffer per thread (default='20000000').  */
  char * out_buffer_size_orig;	/**< @brief Size of output buffer per thread original value given at command line.  */
  const char *out_buffer_size_help; /**< @brief Size of output buffer per thread help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int size_given ;	/**< @brief Whether size was given.  */
  unsigned int mer_len_given ;	/**< @brief Whether mer-len was given.  */
  unsigned int output_given ;	/**< @brief Whether output was given.  */
  unsigned int reprobes_given ;	/**< @brief Whether reprobes was given.  */
  unsigned int out_buffer_size_given ;	/**< @brief Whether out-buffer-size was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct hash_fastq_merge_cmdline_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure hash_fastq_merge_args (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure hash_fastq_merge_args (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *hash_fastq_merge_args_purpose;
/** @brief the usage string of the program */
extern const char *hash_fastq_merge_args_usage;
/** @brief all the lines making the help output */
extern const char *hash_fastq_merge_args_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *hash_fastq_merge_args_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int hash_fastq_merge_cmdline (int argc, char **argv,
  struct hash_fastq_merge_args *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use hash_fastq_merge_cmdline_ext() instead
 */
int hash_fastq_merge_cmdline2 (int argc, char **argv,
  struct hash_fastq_merge_args *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int hash_fastq_merge_cmdline_ext (int argc, char **argv,
  struct hash_fastq_merge_args *args_info,
  struct hash_fastq_merge_cmdline_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int hash_fastq_merge_cmdline_dump(FILE *outfile,
  struct hash_fastq_merge_args *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int hash_fastq_merge_cmdline_file_save(const char *filename,
  struct hash_fastq_merge_args *args_info);

/**
 * Print the help
 */
void hash_fastq_merge_cmdline_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void hash_fastq_merge_cmdline_print_full_help(void);
/**
 * Print the version
 */
void hash_fastq_merge_cmdline_print_version(void);

/**
 * Initializes all the fields a hash_fastq_merge_cmdline_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void hash_fastq_merge_cmdline_params_init(struct hash_fastq_merge_cmdline_params *params);

/**
 * Allocates dynamically a hash_fastq_merge_cmdline_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized hash_fastq_merge_cmdline_params structure
 */
struct hash_fastq_merge_cmdline_params *hash_fastq_merge_cmdline_params_create(void);

/**
 * Initializes the passed hash_fastq_merge_args structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void hash_fastq_merge_cmdline_init (struct hash_fastq_merge_args *args_info);
/**
 * Deallocates the string fields of the hash_fastq_merge_args structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void hash_fastq_merge_cmdline_free (struct hash_fastq_merge_args *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int hash_fastq_merge_cmdline_required (struct hash_fastq_merge_args *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* HASH_FASTQ_MERGE_CMDLINE_H */
