/*
Jaxe - Editeur XML en Java

Copyright (C) 2003 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package jaxe;

import org.apache.log4j.Logger;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;

import javax.swing.*;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

import org.w3c.dom.Element;

public class DialogueXpath extends JFrame implements ActionListener, ItemListener, CaretListener {
    /**
     * Logger for this class
     */
    private static final Logger LOG = Logger.getLogger(DialogueXpath.class);
    
    private static final ResourceBundle rb = JaxeResourceBundle.getRB();
    JTextField textF = new JTextField("");
    JCheckBox box1, box2;
    ButtonGroup groupe;
    private JButton butOk, butAnnuler;
    private ArrayList<Element> listeElements = new ArrayList<Element>();
    DialogueRechercher DialRech;
    JaxeDocument doc;
    private final JComboBox list;
    private Element refElementCourant;
    private String nomElementCourant = "";
    private JTextField textInterne;
    private ZoneAttribut[] attributs;
    String typeRechTxt;
    private final JPanel pane;

    private JPanel exprPane;

    private final JPanel listPane;

    private JPanel textPane, attrPane, buttonPane;
    private int natt;
    private boolean existNS = false;

    public DialogueXpath(final DialogueRechercher DR, final JaxeDocument doc) {
        super(rb.getString("xpath.ExprXpath"));
        DialRech = DR;
        this.doc = doc;
        final org.w3c.dom.Node DomRoot = doc.DOMdoc.getDocumentElement();
        if (DomRoot != null) {
            if (DomRoot.getNamespaceURI() != null)
                existNS = true;
        }
        
        pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, BoxLayout.Y_AXIS));

        listPane = new JPanel(new FlowLayout());
        final JLabel textElt = new JLabel(rb.getString("xpath.TitreElt"));
        listeElements = triListingElt(doc.cfg.listeTousElements());
        final ArrayList<String> listeTitre = new ArrayList<String>();
        for (final Element ref : listeElements) {
            if (existNS) {
                final String prefixe = doc.cfg.prefixeElement(ref);
                if (prefixe == null)
                    listeTitre.add(doc.cfg.titreElement(ref));
                else
                    listeTitre.add(prefixe + ":" + doc.cfg.titreElement(ref));
            } else
                listeTitre.add(doc.cfg.titreElement(ref));
        }
        list = new JComboBox(listeTitre.toArray());
        if ("".equals(nomElementCourant)) {
            refElementCourant = listeElements.get(0);
            nomElementCourant = doc.cfg.nomElement(refElementCourant);
            final ArrayList<Element> latt = doc.cfg.listeAttributs(refElementCourant);
            natt = latt.size();
        }
        list.addItemListener(this);
        listPane.add(textElt);
        listPane.add(list);
                
        majAttPanel();
        majExprXpath();
        setContentPane(pane);
        
        pack();
        final Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        setLocation((screen.width - getSize().width)/2,(screen.height - getSize().height)/2);
        setVisible(true);
        
        addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(final WindowEvent e) {
                dispose();
                DialRech.setVisible(true);
            }
        });
    }

    
    public void majAttPanel() {
        if (refElementCourant == null) {
            dispose();
            JOptionPane.showMessageDialog(this, rb.getString("xpath.ErrBalise"), rb.getString("xpath.Err"), JOptionPane.INFORMATION_MESSAGE);
            return;
        }
        textPane = new JPanel();
        textPane.setLayout(new BoxLayout(textPane, BoxLayout.X_AXIS));
        final JLabel includingText = new JLabel(rb.getString("xpath.IncludingText"));
        textInterne = new JTextField("");
        textInterne.addCaretListener(this);
        typeRechTxt = "contient";
        groupe = new ButtonGroup();
        box1 = new JCheckBox(rb.getString("xpath.TexteExact"),false);
        groupe.add(box1);
        box1.addItemListener(new ItemListener() {
            public void itemStateChanged(final ItemEvent e) {   
                typeRechTxt = "texte exact";
                majExprXpath();
            }
        } );
        box2 = new JCheckBox(rb.getString("xpath.Contient"),true);
        groupe.add(box2);
        box2.addItemListener(new ItemListener() {
            public void itemStateChanged(final ItemEvent e) {   
                typeRechTxt = "contient";
                majExprXpath();
            }
        } );
        textPane.add(Box.createHorizontalStrut(5));
        textPane.add(includingText);
        textPane.add(Box.createHorizontalStrut(2));
        textPane.add(textInterne);
        textPane.add(box1);
        textPane.add(box2);
        textPane.add(Box.createHorizontalStrut(5));
        
        attrPane = new JPanel();
        final JScrollPane scp = new JScrollPane(attrPane,
                ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER) {
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (dim.height > 500)
                    dim.height = 500;
                return(dim);
            }
        };
        scp.getVerticalScrollBar().setUnitIncrement(10);
        scp.setOpaque(false);
        scp.setBorder(BorderFactory.createTitledBorder(
            BorderFactory.createEtchedBorder(1, Color.white,new Color(70,70,70)),
            rb.getString("xpath.TitleAtt") + " \" " + doc.cfg.nomElement(refElementCourant) + " \"", 1, 2));
        final ArrayList<Element> latt = doc.cfg.listeAttributs(refElementCourant);
        natt = latt.size();
        attributs = new ZoneAttribut[natt];
        attrPane.setLayout(new GridBagLayout());
        final GridBagConstraints c = new GridBagConstraints();
        if (natt == 0) {
            final JLabel textAtt = new JLabel(rb.getString("xpath.NoneAtt"));
            textAtt.setForeground(Color.gray);
            attrPane.add(textAtt);
            attrPane.add(Box.createVerticalStrut(30));
        }
        for (int i=0; i<natt; i++) {
            final ZoneAttribut zatt = new ZoneAttribut();
            attributs[i] = zatt;
            final Element att = latt.get(i);
            zatt.nom = doc.cfg.nomAttribut(att);
            zatt.titre = doc.cfg.titreAttribut(refElementCourant, att);
            final JLabel textAtt = new JLabel(zatt.titre + " : ");
            final ArrayList<String> lval = doc.cfg.listeValeursAttribut(att);
            zatt.valeurs = lval;
            if (lval != null && lval.size() > 0) {
                zatt.valeurs.add(0, "");
                final String[] titres = new String[zatt.valeurs.size()];
                for (int j=0; j<zatt.valeurs.size(); j++)
                    titres[j] = doc.cfg.titreValeurAttribut(refElementCourant, att, zatt.valeurs.get(j));
                zatt.champ = new JComboBox(titres);
                ((JComboBox) zatt.champ).addActionListener(new ActionListener() {
                     public void actionPerformed(final ActionEvent e) {   
                         majExprXpath();
                     }
                 } );
            } else {
                zatt.champ = new JTextField(42);
                ((JTextField) zatt.champ).addCaretListener(this);
            }
            c.gridx = 0;
            c.gridy = i;
            c.anchor = GridBagConstraints.EAST;
            attrPane.add(textAtt,c);
            c.gridx = 1;
            c.gridy = i;
            c.anchor = GridBagConstraints.WEST;
            attrPane.add(zatt.champ,c);
            if (zatt.champ instanceof JTextField) {
                zatt.typeRech = "contient";
                groupe = new ButtonGroup();
                box1 = new JCheckBox(rb.getString("xpath.MotExact"),false);
                groupe.add(box1);
                box1.addItemListener(new ItemListener() {
                    public void itemStateChanged(final ItemEvent e) {   
                        zatt.typeRech = "mot exact";
                        majExprXpath();
                    }
                } );
                c.gridx = 2;
                c.gridy = i;
                attrPane.add(box1,c);  
                box2 = new JCheckBox(rb.getString("xpath.Contient"),true);
                groupe.add(box2);
                box2.addItemListener(new ItemListener() {
                    public void itemStateChanged(final ItemEvent e) {   
                        zatt.typeRech = "contient";
                        majExprXpath();
                    }
                } );
                c.gridx = 3;
                c.gridy = i;
                attrPane.add(box2,c);
            } else {
                zatt.typeRech = "mot exact";
            }
        }
        
        exprPane = new JPanel(new FlowLayout());
        final JLabel textRes = new JLabel(rb.getString("xpath.Expr"));
        textF = new JTextField("", 55);
        textF.setEditable(false);
        textF.setForeground(Color.red);
        exprPane.add(textRes);
        exprPane.add(textF);
        
        buttonPane = new JPanel();
        butOk = new JButton(rb.getString("xpath.Ok"));
        butOk.addActionListener(this);
        butOk.setActionCommand("OK");
        getRootPane().setDefaultButton(butOk);
        butAnnuler = new JButton(rb.getString("xpath.Annuler"));
        butAnnuler.addActionListener(this);
        butAnnuler.setActionCommand("Annuler");
        buttonPane.add(butOk);
        buttonPane.add(butAnnuler);
        
        pane.add(Box.createVerticalStrut(10));
        pane.add(listPane);
        pane.add(Box.createVerticalStrut(10));
        pane.add(textPane);
        pane.add(Box.createVerticalStrut(10));
        pane.add(scp);
        pane.add(Box.createVerticalStrut(10));
        pane.add(exprPane);
        pane.add(Box.createVerticalStrut(5));
        pane.add(buttonPane);
    }
        
    
    public void caretUpdate(final CaretEvent e) {
        majExprXpath();
    }
    
    
    public void actionPerformed(final ActionEvent e) {
        if (e.getSource() == butOk) {
            dispose();
            DialRech.tfRechercher.setText(textF.getText());
            DialRech.setVisible(true);
        }
        if (e.getSource() == butAnnuler) {
            dispose();
            DialRech.setVisible(true);
        }
    }
    
    
    public void majExprXpath() {
        boolean existAtt = false;
        final StringBuilder expr = new StringBuilder();
        if (existNS) {
            final String prefix = doc.cfg.prefixeElement(refElementCourant);
            if (prefix != null) {
                expr.append("//");
                expr.append(prefix);
                expr.append(":");
                expr.append(nomElementCourant);
            } else {
                expr.append("//*[local-name()=\"");
                expr.append(nomElementCourant);
                expr.append("\"");
                existAtt = true;
            }
        } else {
            expr.append("//");
            expr.append(nomElementCourant);
        }    
        final String text = textInterne.getText();
        if (!text.equals("")) {
            if (existAtt)
                expr.append(" and ");
            else {
                expr.append("[");
                existAtt = true;
            }            
            if (typeRechTxt.equals("contient")) {
                expr.append("contains(.,\"");
                expr.append(text);
                expr.append("\")");
            } else { 
                expr.append(".=\"");
                expr.append(text);
                expr.append("\"");
            }
        }
        for (final ZoneAttribut zatt : attributs) {
            String valAtt = "";
            if (zatt.champ instanceof JTextField)
                valAtt = ((JTextField)zatt.champ).getText();
            else if (zatt.champ instanceof JComboBox) {
                final int index = ((JComboBox)zatt.champ).getSelectedIndex();
                valAtt = zatt.valeurs.get(index);
            }
            final boolean nonvide = (!"".equals(valAtt));
            if (nonvide){
                if (existAtt) {
                    expr.append(" and ");
                } else {
                    expr.append("[");
                    existAtt = true;
                }
                if (zatt.typeRech.equals("contient")) {
                    expr.append("contains(@");
                    expr.append(zatt.nom);
                    expr.append(",\"");
                    expr.append(valAtt);
                    expr.append("\")"); 
                } else {
                    expr.append("@");
                    expr.append(zatt.nom);
                    expr.append("=\"");
                    expr.append(valAtt);
                    expr.append("\""); 
                } 
            }
        }
        if (existAtt)
            expr.append("]");
        textF.setText(expr.toString());
    }

    
    public void itemStateChanged(final ItemEvent e) {
        final Object source = e.getSource();
        if ((source == list) && (e.getStateChange() == 1)) {
            refElementCourant = listeElements.get(list.getSelectedIndex());
            nomElementCourant = doc.cfg.nomElement(refElementCourant);
            pane.removeAll();
            majAttPanel();
            pane.validate();
            majExprXpath();
            pack();
        }
    }
    
    
    public ArrayList<Element> triListingElt(final ArrayList<Element> list){
        final ArrayList<Element> listeTriee = new ArrayList<Element>(list.size());
        final char[][] replaceChar = {{'','O'},{'','I'},{'','I'},{'','A'},{'','A'},{'','E'},{'','E'},{'','E'},{'','E'}};
        if (list.size() > 0)
            listeTriee.add(0,list.get(0));
        for (int i=1; i<list.size(); i++) {
            boolean ajout = false;
            String eltTraite = (doc.cfg.titreElement(list.get(i)).toUpperCase());
            for (final char[] element : replaceChar) {
                eltTraite = eltTraite.replace(element[0], element[1]);
            }    
            for (int j=0; j<i; j++) {
                String eltTrie = (doc.cfg.titreElement(listeTriee.get(j)).toUpperCase());
                for (final char[] element : replaceChar) {
                    eltTrie = eltTrie.replace(element[0], element[1]);
                } 
                if (((eltTraite.trim()).compareToIgnoreCase((eltTrie.trim()).toUpperCase())) <= 0) {
                    listeTriee.add(j, list.get(i));
                    ajout = true;
                    j = i;
                }
            }
            if (!ajout)
                listeTriee.add(i, list.get(i));
        }
        
        final ArrayList<Element> listeSansDoublon = new ArrayList<Element>();
        Element refprecedent = null;
        for (final Element ref : listeTriee) {
            if (refprecedent == null || !doc.cfg.nomElement(refprecedent).equals(doc.cfg.nomElement(ref)))
                listeSansDoublon.add(ref);
            else {
                final String uriprecedent = doc.cfg.espaceElement(refprecedent);
                final String uri = doc.cfg.espaceElement(ref);
                if (!((uri == null && uriprecedent == null) || (uri != null && uri.equals(uriprecedent))))
                    listeSansDoublon.add(ref);
            }
            refprecedent = ref;
        }
        return listeSansDoublon;
    }        
    
    class ZoneAttribut {
        JComponent champ;
        String nom;
        String titre;
        ArrayList<String> valeurs;
        String typeRech;
    }
    
}
