#include "hrn.h"
#include "hrn-texture-cache.h"
#include "hrn-tile-frame.h"
#include "hrn-up-tile.h"
#include "hrn-tileable.h"

enum {
    PROP_0,
};

enum {
    LAST_SIGNAL,
};

struct _HrnUpTilePrivate {
    ClutterActor *thumbnail;
};

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HRN_TYPE_UP_TILE, HrnUpTilePrivate))
static void tileable_interface_init (HrnTileableInterface *iface);
G_DEFINE_TYPE_WITH_CODE (HrnUpTile, hrn_up_tile, NBTK_TYPE_TABLE,
                         G_IMPLEMENT_INTERFACE (HRN_TYPE_TILEABLE,
                                                tileable_interface_init));

static void
hrn_up_tile_finalize (GObject *object)
{
    G_OBJECT_CLASS (hrn_up_tile_parent_class)->finalize (object);
}

static void
hrn_up_tile_dispose (GObject *object)
{
    G_OBJECT_CLASS (hrn_up_tile_parent_class)->dispose (object);
}

static void
hrn_up_tile_set_property (GObject      *object,
                          guint         prop_id,
                          const GValue *value,
                          GParamSpec   *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static void
hrn_up_tile_get_property (GObject    *object,
                          guint       prop_id,
                          GValue     *value,
                          GParamSpec *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static gboolean
hrn_up_tile_enter_event (ClutterActor         *actor,
                         ClutterCrossingEvent *event)
{
    HrnUpTile *tile = (HrnUpTile *) actor;
    HrnUpTilePrivate *priv = tile->priv;

    nbtk_widget_set_style_pseudo_class ((NbtkWidget *) priv->thumbnail,
                                        "hover");
    return FALSE;
}

static gboolean
hrn_up_tile_leave_event (ClutterActor         *actor,
                         ClutterCrossingEvent *event)
{
    HrnUpTile *tile = (HrnUpTile *) actor;
    HrnUpTilePrivate *priv = tile->priv;

    nbtk_widget_set_style_pseudo_class ((NbtkWidget *) priv->thumbnail, NULL);
    return FALSE;
}

static gboolean
hrn_up_tile_release_event (ClutterActor       *actor,
                           ClutterButtonEvent *event)
{
    HrnUpTile *tile = (HrnUpTile *) actor;

    if (event->button != 1) {
        return FALSE;
    }

    hrn_tileable_activated ((HrnTileable *) tile,
                            HRN_TILEABLE_ACTION_UP_LEVEL, tile);

    return TRUE;
}

static void
hrn_up_tile_class_init (HrnUpTileClass *klass)
{
    GObjectClass *o_class = (GObjectClass *) klass;
    ClutterActorClass *a_class = (ClutterActorClass *) klass;

    o_class->dispose = hrn_up_tile_dispose;
    o_class->finalize = hrn_up_tile_finalize;
    o_class->set_property = hrn_up_tile_set_property;
    o_class->get_property = hrn_up_tile_get_property;

    a_class->enter_event = hrn_up_tile_enter_event;
    a_class->leave_event = hrn_up_tile_leave_event;
    a_class->button_release_event = hrn_up_tile_release_event;

    g_type_class_add_private (klass, sizeof (HrnUpTilePrivate));
}

static guint
tileable_get_count (HrnTileable *tileable)
{
    return 1;
}

static ClutterActor *
tileable_get_thumbnail (HrnTileable *tileable)
{
    return NULL;
}

static void
tileable_set_position (HrnTileable *tileable,
                       guint        x,
                       guint        y)
{
}

static HrnClusterNode *
tileable_get_node (HrnTileable *tileable)
{
    return NULL;
}

static void
tileable_interface_init (HrnTileableInterface *iface)
{
    iface->get_count = tileable_get_count;
    iface->get_thumbnail = tileable_get_thumbnail;
    iface->set_position = tileable_set_position;
    iface->get_node = tileable_get_node;
}

static void
hrn_up_tile_init (HrnUpTile *self)
{
    HrnUpTilePrivate *priv = GET_PRIVATE (self);

    self->priv = priv;

    clutter_actor_set_reactive ((ClutterActor *) self, TRUE);

    priv->thumbnail = (ClutterActor *) nbtk_label_new ("");
    nbtk_widget_set_style_class_name ((NbtkWidget *) priv->thumbnail,
                                      "HrnUpButtonThumbnail");
    clutter_actor_set_size (priv->thumbnail, THUMBNAIL_WIDTH,
                            THUMBNAIL_HEIGHT);
    nbtk_table_add_actor (NBTK_TABLE (self), priv->thumbnail, 0, 0);
}

