#ifndef __HRN_SOURCE_MANAGER_H__
#define __HRN_SOURCE_MANAGER_H__

#include <glib-object.h>

#include <bickley/bkl-item.h>

#include "hrn-source.h"

G_BEGIN_DECLS

#define HRN_TYPE_SOURCE_MANAGER                                         \
   (hrn_source_manager_get_type())
#define HRN_SOURCE_MANAGER(obj)                                         \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                HRN_TYPE_SOURCE_MANAGER,                \
                                HrnSourceManager))
#define HRN_SOURCE_MANAGER_CLASS(klass)                                 \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             HRN_TYPE_SOURCE_MANAGER,                   \
                             HrnSourceManagerClass))
#define IS_HRN_SOURCE_MANAGER(obj)                                      \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                HRN_TYPE_SOURCE_MANAGER))
#define IS_HRN_SOURCE_MANAGER_CLASS(klass)                              \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             HRN_TYPE_SOURCE_MANAGER))
#define HRN_SOURCE_MANAGER_GET_CLASS(obj)                               \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               HRN_TYPE_SOURCE_MANAGER,                 \
                               HrnSourceManagerClass))

typedef struct _HrnSourceManagerPrivate HrnSourceManagerPrivate;
typedef struct _HrnSourceManager      HrnSourceManager;
typedef struct _HrnSourceManagerClass HrnSourceManagerClass;

struct _HrnSourceManager
{
    GObject parent;

    HrnSourceManagerPrivate *priv;
};

struct _HrnSourceManagerClass
{
    GObjectClass parent_class;
};

GType hrn_source_manager_get_type (void) G_GNUC_CONST;
HrnSource *hrn_source_manager_get_local_source (HrnSourceManager *manager);
GList *hrn_source_manager_get_transient_sources (HrnSourceManager *manager);
HrnSource *hrn_source_manager_get_source_for_path (HrnSourceManager *manager,
                                                   const char       *path);
BklItem *hrn_source_manager_get_item_for_uri (HrnSourceManager *manager,
                                              const char       *uri,
                                              HrnSource       **ret_source);
gboolean hrn_source_manager_is_ready (HrnSourceManager *manager);


G_END_DECLS

#endif /* __HRN_SOURCE_MANAGER_H__ */
