#ifndef __HRN_CLUSTERIZER_H__
#define __HRN_CLUSTERIZER_H__

#include <glib.h>
#include <bickley/bkl.h>

#include "hrn-cluster-node.h"

typedef struct _HrnClusterTree {
    HrnClusterNode *audio;
    HrnClusterNode *image;
    HrnClusterNode *video;
    GHashTable *uri_to_item;
    GPtrArray *items;
} HrnClusterTree;

HrnClusterTree *hrn_cluster_tree_new (void);
void hrn_cluster_tree_free (HrnClusterTree *tree);
void hrn_cluster_tree_add_item (HrnClusterTree *tree,
                                BklItem        *item);
void hrn_cluster_tree_remove_item (HrnClusterTree *tree,
                                   BklItem        *item);
void hrn_cluster_tree_filter_items (HrnClusterTree *tree,
                                    GHashTable     *filter);

#endif
