{- This module was generated from data in the Kate syntax highlighting file makefile.xml, version 1.09,
   by  Per Wigren (wigren@home.se) -}

module Text.Highlighting.Kate.Syntax.Makefile ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Data.List (nub)
import qualified Data.Set as Set
import Data.Map (fromList)
import Data.Maybe (fromMaybe)

-- | Full name of language.
syntaxName :: String
syntaxName = "Makefile"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "GNUmakefile;Makefile*;makefile*"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Makefile" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Makefile",["Normal"])], synStLanguage = "Makefile", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return ()
    "String" -> (popContext >> return ())
    "Value" -> return ()
    "VarFromValue" -> return ()
    "VarFromNormal" -> return ()
    "Commands" -> (popContext >> return ())
    _ -> return ()
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents, synStCharsParsedInLine = 0, synStPrevChar = '\n' }

withAttribute attr txt = do
  if null txt
     then fail "Parser matched no text"
     else return ()
  let style = fromMaybe "" $ lookup attr styles
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (nub [style, attr], txt)

styles = [("Normal Text","Normal"),("Keyword","Keyword"),("Comment","Comment"),("String","String"),("Variable","DataType"),("Target","DecVal"),("Section","Others"),("Operator","Char"),("Commands","BaseN"),("Special","Float")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "include define else endef endif ifdef ifeq ifndef ifneq"

regex_'5b'5f'5cw'5cd'5d'2a'5cs'2a'28'3f'3d'3a'3d'7c'3d'29 = compileRegex "[_\\w\\d]*\\s*(?=:=|=)"
regex_'5b'5f'5cw'5cd'2d'5d'2a'5cs'2a'3a = compileRegex "[_\\w\\d-]*\\s*:"
regex_'5b'2e'5d'2e'2a'3a = compileRegex "[.].*:"
regex_'5b'24'5d'5b'5c'28'7b'5d = compileRegex "[$][\\({]"
regex_'23'2e'2a'24 = compileRegex "#.*$"
regex_'5c'5c'24 = compileRegex "\\\\$"
regex_'5b'5e'5c'5c'5d'3f'24 = compileRegex "[^\\\\]?$"
regex_'40'5b'2d'5f'5cd'5cw'5d'2a'40 = compileRegex "@[-_\\d\\w]*@"
regex_'5b'5c'29'7d'5d'28'3f'3d'2f'29 = compileRegex "[\\)}](?=/)"
regex_'5b'5c'29'7d'5d'5b'5e'24'5d = compileRegex "[\\)}][^$]"
regex_'5b'5c'29'7d'5d'24 = compileRegex "[\\)}]$"
regex_'5b'5f'5cw'2d'5d'2a'5cb = compileRegex "[_\\w-]*\\b"

defaultAttributes = [("Normal","Normal Text"),("String","String"),("Value","String"),("VarFromValue","Variable"),("VarFromNormal","Variable"),("Commands","Normal Text")]

parseRules "Normal" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5b'5f'5cw'5cd'5d'2a'5cs'2a'28'3f'3d'3a'3d'7c'3d'29 >>= withAttribute "Variable") >>~ pushContext "Value")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'5b'5f'5cw'5cd'2d'5d'2a'5cs'2a'3a >>= withAttribute "Target"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5b'2e'5d'2e'2a'3a >>= withAttribute "Section"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((pRegExpr regex_'5b'24'5d'5b'5c'28'7b'5d >>= withAttribute "Operator") >>~ pushContext "VarFromNormal")
                        <|>
                        ((pDetect2Chars False '\\' '#' >>= withAttribute "Special"))
                        <|>
                        ((pDetect2Chars False '\\' '\\' >>= withAttribute "Special"))
                        <|>
                        ((pAnyChar "+*=%$():\\;" >>= withAttribute "Operator"))
                        <|>
                        ((pFirstNonSpace >> pAnyChar "@-" >>= withAttribute "Operator") >>~ pushContext "Commands")
                        <|>
                        ((pRegExpr regex_'23'2e'2a'24 >>= withAttribute "Comment")))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pLineContinue >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "Value" = 
  do (attr, result) <- (((pRegExpr regex_'5c'5c'24 >>= withAttribute "Operator"))
                        <|>
                        ((pRegExpr regex_'5b'5e'5c'5c'5d'3f'24 >>= withAttribute "String") >>~ (popContext >> return ()))
                        <|>
                        ((pRegExpr regex_'5b'24'5d'5b'5c'28'7b'5d >>= withAttribute "Operator") >>~ pushContext "VarFromValue")
                        <|>
                        ((pRegExpr regex_'40'5b'2d'5f'5cd'5cw'5d'2a'40 >>= withAttribute "Special") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False ';' >>= withAttribute "Operator") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "VarFromValue" = 
  do (attr, result) <- (((pRegExpr regex_'5b'5c'29'7d'5d'28'3f'3d'2f'29 >>= withAttribute "Operator") >>~ (popContext >> return ()))
                        <|>
                        ((pRegExpr regex_'5b'5c'29'7d'5d'5b'5e'24'5d >>= withAttribute "Operator") >>~ (popContext >> return ()))
                        <|>
                        ((pRegExpr regex_'5b'5c'29'7d'5d'24 >>= withAttribute "Operator") >>~ (popContext >> popContext >> return ())))
     return (attr, result)

parseRules "VarFromNormal" = 
  do (attr, result) <- ((pAnyChar ")}" >>= withAttribute "Operator") >>~ (popContext >> return ()))
     return (attr, result)

parseRules "Commands" = 
  do (attr, result) <- (((pRegExpr regex_'5b'24'5d'5b'5c'28'7b'5d >>= withAttribute "Operator") >>~ pushContext "VarFromNormal")
                        <|>
                        ((pRegExpr regex_'5b'5f'5cw'2d'5d'2a'5cb >>= withAttribute "Commands") >>~ (popContext >> return ())))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
