/* 
 * ### Copyright (C) 2008 Michael Fuchs ###
 * ### All Rights Reserved.             ###
 *
 * Author: Michael Fuchs
 * E-Mail: michael.fuchs@dbdoclet.org
 * URL:    http://www.michael-a-fuchs.de
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.service.StringServices;
import org.dbdoclet.trafo.html.docbook.DbtConstants;
import org.dbdoclet.trafo.html.docbook.DocBookTransformer;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.tag.docbook.Anchor;
import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Link;
import org.dbdoclet.trafo.tag.docbook.Para;
import org.dbdoclet.trafo.tag.docbook.SimPara;
import org.dbdoclet.trafo.tag.docbook.ULink;
import org.dbdoclet.trafo.tag.docbook.XRef;
import org.dbdoclet.trafo.tag.html.A;

public class AEditor extends Editor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));
		DocBookTagFactory dbfactory = values.getTagFactory();

		Script script = getTransformer().getScript();

		DocBookElement ancestor;
		DocBookElement parent = getParent();
		DocBookTransformer transformer = getTransformer();

		traverse(true);

		// The referncen of attribute parent must not be changed. Because of
		// this we
		// need a temporary variable to store a new parent for
		// different situations.
		ancestor = parent;

		if (parent.isContentModel()) {

			Para para = dbfactory.createPara();
			parent.appendChild(para);
			ancestor = para;
		}

		A htmlA = (A) getHtmlElement();

		String name = htmlA.getName();
		String href = htmlA.getHref();

		if (name != null && name.length() > 0) {

			Anchor anchor = dbfactory.createAnchor();
			anchor.setId(transformer.createUniqueId(name));

			boolean createXrefLabel = script.isParameterOn(
					DbtConstants.SECTION_DOCBOOK,
					DbtConstants.PARAM_DOCBOOK_CREATE_XREF_LABEL, true);

			if (createXrefLabel == true) {
				anchor.setXrefLabel(StringServices.replace(
						htmlA.getTextContent(), "\"", "&quot;"));
			}

			ancestor.appendChild(anchor);

		} else if (href != null && href.equals("#") == false
				&& href.startsWith("#")) {

			String label = htmlA.getTextContent();

			if ((label != null) && (label.length() > 0)) {

				Link link = dbfactory.createLink(transformer.getUniqueId(href));
				link.setParentNode(ancestor);
				ancestor.appendChild(link);
				setCurrent(link);

			} else {

				XRef xref = dbfactory.createXRef(transformer.getUniqueId(href));
				xref.setParentNode(ancestor);
				ancestor.appendChild(xref);
				setCurrent(ancestor);
			}

		} else {

			DocBookElement linkElement;

			if (isDocBook5()) {

				Link link = dbfactory.createLink();
				link.setParentNode(ancestor);

				if (href != null) {
					link.setHref(href);
				} else {
					link.setHref("");
				}

				linkElement = link;

			} else {

				ULink ulink = dbfactory.createULink();
				ulink.setParentNode(ancestor);
				ulink.setUrl(href);
				linkElement = ulink;
			}

			if (linkElement.validate()) {

				setCurrent(linkElement);
				ancestor.appendChild(getCurrent());
				transformer.addLink(linkElement);

			} else {

				SimPara candidate = dbfactory.createSimPara();
				candidate.setParentNode(ancestor);

				if (candidate.validate()) {

					ancestor.appendChild(candidate);
					candidate.appendChild(ancestor);
				}
			}
		}

		return finalizeValues();
	}
}
