//
// C++ Implementation: gutendb
//
// Description:
//
//
// Author: Lorn Potter <lorn.potter@gmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gutendb.h"
#include "gutenindex.h"

#include "serverindex.h"

#include <QTreeWidgetItem>
#include <QTreeWidget>
#include <QtSql>
#include <QSqlDatabase>
#include <QSettings>
#include <QMessageBox>
#include <QDir>

#ifdef Q_WS_QWS
#include <Qtopia>
#endif

gutenDb::gutenDb()
        : QObject(),
          databaseNeedsUpdate(0),
          dbpath(QDir::homePath().append("/.gutenbrowser/gutenbrowser.sqlite"))

{
    useSql = true;
      //  QTimer::singleShot(0, this, SLOT(connectDatabase()));
}


gutenDb::~gutenDb()
{
    closeDatabase();
}

void gutenDb::updateLibraryDatabase()
{
      //save installed etexts
    QList<QStringList> installedEtexts = returnInstalled();
    if(db.isOpen()) {
        closeDatabase();
    }
    qWarning() << __PRETTY_FUNCTION__ << dbpath;
    
    QFile dbFile(dbpath);
    //    if(dbFile.exists())
        if(dbFile.remove()) {
            openDatabase();
            insertIndex();
            
            for (int i = 0; i < installedEtexts.size(); ++i) {
                installEtext(installedEtexts.at(i)[4]); //book idGuten
            }
        } else {
            QMessageBox::critical(0, qApp->tr("Cannot remove database"),
                                  qApp->tr("Cannot remove database file."),
                                  QMessageBox::Cancel,
                                  QMessageBox::NoButton);
        }
}

bool gutenDb::connectDatabase()
{
    qWarning() << __PRETTY_FUNCTION__;
    if(!db.isOpen()) {
        if(useSql/* && !db.isValid()*/) {
            db = QSqlDatabase::addDatabase("QSQLITE");
              // db = QSqlDatabase::addDatabase("QMYSQLDriver");
              // db.setHostName("");
#ifdef Q_WS_QWS
            db.setDatabaseName(Qtopia::applicationFileName(QLatin1String("Gutenb"), dbpath));
#else
            db.setDatabaseName(dbpath);
#endif

            db.setUserName("gutenuser");
            db.setPassword("1234");

            if(!db.open()) {
                QMessageBox::critical(0, qApp->tr("Cannot open database"),
                                      qApp->tr("Unable to establish a database connection.\n"
                                               "Click Cancel to exit."),
                                      QMessageBox::Cancel,
                                      QMessageBox::NoButton);
                useSql = false;
                return false;
            }

            if(!db.isValid()) {
                QMessageBox::critical(0, qApp->tr("Cannot open database"),
                                      qApp->tr("Unable to establish a database connection.\n"
                                               "Click Cancel to exit."),
                                      QMessageBox::Cancel,
                                      QMessageBox::NoButton);
                useSql = false;
                return false;
            }

        }
    } else {
        qWarning() << "db is open";
    }
    
    qWarning("%d table entry",(db.tables(QSql::Tables).count()));
    QSqlQuery xsql;
    xsql.exec(QLatin1String("PRAGMA synchronous = OFF"));   // full/normal sync is safer, but by god slower.
    xsql.exec(QLatin1String("PRAGMA temp_store = memory"));
    xsql.exec(QLatin1String("PRAGMA temp_store_directory = '/tmp';"));

    if(!databaseTablesExist()) {
        createTables();
    }

    return true;
}

void gutenDb::createTables()
{
    qWarning() << __PRETTY_FUNCTION__;
    QSqlQuery query;
//title, author, installed, id, file
    query.exec("create table etext( title varchar(100), author varchar(100), installed int, file varchar(50), id int)");
    query.exec("create table servers( nation varchar(100), provider varchar(100), url varchar(120))");  
    query.exec("create table installed( id int, filepath varchar(256))");     
    
    if(!query.exec()) {
        qWarning(query.lastError().driverText().toLocal8Bit());
        qWarning(query.lastQuery().toLocal8Bit());
        return ;
    }
    
    databaseNeedsUpdate = true;    
}

void gutenDb::openDatabase()
{
    qWarning() << __PRETTY_FUNCTION__;
/*  if (!QtopiaSqlPrivate::defaultConn) {
    QtopiaSqlPrivate::defaultConn = connect(QLatin1String(QSqlDatabase::defaultConnection));
    init(*QtopiaSqlPrivate::defaultConn);
    }*/
    connectDatabase();
    if(!db.isOpen())
        QMessageBox::information(0,tr("Database"),
                                 tr("<p>Could not connect to database.</p>"),0);
}


void gutenDb::closeDatabase()
{
    qWarning() << __PRETTY_FUNCTION__;
    if(db.isOpen())
        db.close();

#ifdef Q_WS_QWS
    QSqlDatabase::removeDatabase(Qtopia::applicationFileName(QLatin1String("Gutenb"), dbpath));
#else
    QSqlDatabase::removeDatabase(dbpath);
#endif

//   delete QtopiaSqlPrivate::defaultConn;
//   QtopiaSqlPrivate::defaultConn = 0;
}


bool gutenDb::insertIndex()
{
    qWarning() << __PRETTY_FUNCTION__;
    if(!db.isOpen()) {
        QMessageBox::information(0,tr("Database"),
                                 tr("<p>Could not open database to insert the index.</p>"),0);
        return false;
    }

    qWarning("insertIndex");
    index = new gutenIndex();
    index->downloadNewIndex();
    
    if(!index->parseIndex() ) {
        return false;
    }

    QList<QStringList> libraryVector = index->getLibrary();
    QSqlQuery query;

    for (int i = 0; i < libraryVector.size(); ++i) {
        QString queryCommand("INSERT INTO etext (title, author, installed, file, id) VALUES (:t, :a, :d, :f, :i)");
        query.prepare(queryCommand);
          // from gutenindex:
          // 0    title
          // 1    author
          // 2    book id
          // 3    file

        query.bindValue(":t",libraryVector.at(i)[0].simplified());
        query.bindValue(":a",libraryVector.at(i)[1].simplified());
        query.bindValue(":d","");
        query.bindValue(":f",libraryVector.at(i)[2].simplified());
        query.bindValue(":i",libraryVector.at(i)[3].simplified());
        
        if(!query.exec()) {
            qWarning(query.lastError().driverText().toLocal8Bit());
            qWarning(query.lastQuery().toLocal8Bit());
            return false;
        }
    }
    qWarning("Finished updating database");
      //qWarning(QTime::currentTime().toString("HH:mm:ss").toLocal8Bit());

    delete index;
    index = 0;
    databaseNeedsUpdate = true;
    return databaseNeedsUpdate;
}

void gutenDb::insert(QStringList &list)
{
    Q_UNUSED(list);
}

QList<QStringList> gutenDb::lookup(const QString &mode, const QString& string)
{
    if(!db.isOpen())
        return QList<QStringList>();
 
    qWarning("gutenDb::lookup "+mode.toLocal8Bit()+" "+string.toLocal8Bit());

    QList<QStringList>  queryResult;
    QStringList list;
    QSqlQuery query;
    QString queryCommand = QString("SELECT * FROM etext WHERE %1 LIKE '\%%2\%'").arg(mode).arg(string);
    query.prepare(queryCommand);

    if(!query.exec()) {
        qWarning(query.lastError().driverText().toLocal8Bit());
        qWarning(query.lastQuery().toLocal8Bit());
        return queryResult;
    }

    while(query.next()) {
        list.clear();
          /* from db:
             0   title
             1   author
             2   installed
             3   file
             4   id
          */
        list
            <<  query.value(0).toString()
            <<  query.value(1).toString()
            <<  query.value(2).toString()
            <<  query.value(3).toString()
            <<  query.value(4).toString();
        queryResult << list;
    }

    return queryResult;
}

QList<QStringList> gutenDb::returnAllEtext()
{
    if(!db.isOpen())
        return QList<QStringList>();

    QList<QStringList>  queryResult;
    QStringList list;
    QSqlQuery query;
    QString queryCommand = QString("SELECT * FROM etext");
    query.prepare(queryCommand);

    if(!query.exec()) {
        qWarning(query.lastError().driverText().toLocal8Bit());
        qWarning(query.lastQuery().toLocal8Bit());
        return queryResult;
    }

    while(query.next()) {
        qApp->processEvents();
        list.clear();
          /* from db:
             0   title
             1   author
             2   installed
             3   file
             4   id   */
        list
            <<  query.value(0).toString()
            <<  query.value(1).toString()
            <<  query.value(2).toString()
            <<  query.value(3).toString()
            <<  query.value(4).toString();
        queryResult << list;
    }

    qWarning("returnAllEtext size %d",queryResult.size());

    return queryResult;
}

QList<QStringList> gutenDb::find(const QString &mode, const QString& string)
{
    if(!db.isOpen())
        return QList<QStringList>();
    
    qWarning() << __PRETTY_FUNCTION__ << mode<< string;
    
    QList<QStringList>  queryResult;
    QStringList list;
    QSqlQuery query;
    
    QString queryCommand = QString("SELECT * FROM etext WHERE %1='%2'").arg(mode).arg(string);
    //    qWarning() <<  queryCommand;
    query.prepare(queryCommand);
    
    if(!query.exec()) {
        
        qWarning(query.lastError().driverText().toLocal8Bit());
        qWarning(query.lastQuery().toLocal8Bit());
        return queryResult;
    }
    
    while(query.next()) {
        list.clear();
          /* from db:
             0   title
             1   author
             2   installed
             3   file
             4   id
          */
        qWarning() <<  "YAY Found " << query.value(3).toString();
        list
            <<  query.value(0).toString()
            <<  query.value(1).toString()
            <<  query.value(2).toString()
            <<  query.value(3).toString()
            <<  query.value(4).toString();
        queryResult << list;
    }
    qWarning() << queryResult.size();
    return queryResult;
}

QList<QStringList> gutenDb::returnInstalled()
{
    if(!db.isOpen())
        return QList<QStringList>();

    QList<QStringList>  queryResult;
    QStringList list;
    QSqlQuery query;
    QString queryCommand = QString("SELECT * FROM etext WHERE installed = 'X'");
    query.prepare(queryCommand);

    if(!query.exec()) {
        qWarning(query.lastError().driverText().toLocal8Bit());
        qWarning(query.lastQuery().toLocal8Bit());
        return queryResult;
    }

    while(query.next()) {
        list.clear();
        list
            <<  query.value(0).toString()
            <<  query.value(1).toString()
            <<  query.value(2).toString()
            <<  query.value(3).toString()
            <<  query.value(4).toString();
        queryResult << list;
    }
    qWarning("returninstalled size %d",queryResult.size());
    return queryResult;
}

bool gutenDb::installEtext(const QString & idString)
{
    qWarning() << __PRETTY_FUNCTION__ << idString;
    QSqlQuery query;
    QString queryCommand("UPDATE etext SET installed = :m WHERE id = :i");
    query.prepare(queryCommand);

    query.bindValue(":m","X");
 
    query.bindValue(":i",idString);

    if(!query.exec()) {
        qWarning(query.lastError().driverText().toLocal8Bit());
        qWarning(query.lastQuery().toLocal8Bit());
        return false;
    }
    qWarning("Etext is installed");
    return true;
}

bool gutenDb::insertServers(QList<QStringList> serverVector)
{
      //   qWarning("insertServers");
      //   qWarning("gutenDb::insertServers size of serverlist is now %d", serverVector.size());
    QSqlQuery query;

    for (int i = 0; i < serverVector.size(); ++i) {
        QString queryCommand("INSERT INTO servers (nation, provider, url ) VALUES (:n, :p, :u)");

        query.prepare(queryCommand);
        query.bindValue(":n",serverVector.at(i)[0].simplified());
        query.bindValue(":p",serverVector.at(i)[1].simplified());
        query.bindValue(":u",serverVector.at(i)[2].simplified());

        if(!query.exec()) {
            qWarning(query.lastError().driverText().toLocal8Bit());
            qWarning(query.lastQuery().toLocal8Bit());
            return false;
        }
    }
    return true;

}


QList<QStringList> gutenDb::returnServers()
{
    QList<QStringList>  queryResult;
    QStringList list;

    QSqlQuery query;
    QString queryCommand = QString("SELECT * FROM servers");
    query.prepare(queryCommand);

    if(!query.exec()) {
        qWarning(query.lastError().driverText().toLocal8Bit());
        qWarning(query.lastQuery().toLocal8Bit());
        return queryResult;
    }

    while(query.next()) {
        list.clear();
        list
            <<  query.value(0).toString()
            <<  query.value(1).toString()
            <<  query.value(2).toString();

        queryResult << list;
    }
    return queryResult;
}

bool gutenDb::removeBook(const QString & item)
{
    qWarning() << __PRETTY_FUNCTION__ << item;
    // just remove X from db entry
    //    qWarning() << __PRETTY_FUNCTION__ << item.simplified();
    QSqlQuery query;
    
    QString queryCommand("DELETE FROM installed WHERE id = :i");
    query.prepare(queryCommand);
    
    query.bindValue(":i",item.simplified());

    if(!query.exec()) {
        qWarning(query.lastError().driverText().toLocal8Bit());
        qWarning(query.lastQuery().toLocal8Bit());
        return false;
    }
    
    QSqlQuery query2;
    
    QString queryCommand2("UPDATE etext SET installed = :m WHERE id = :i");
    query2.prepare(queryCommand2);
    
    query2.bindValue(":m","");
    query2.bindValue(":i",item.simplified());
    
    if(!query2.exec()) {
        qWarning(query2.lastError().driverText().toLocal8Bit());
        qWarning(query2.lastQuery().toLocal8Bit());
        return false;
    }
    
    
    return true;
}


/*!
    \fn gutenDb::databaseTablesExist()
 */
bool gutenDb::databaseTablesExist()
{
    qWarning() << __PRETTY_FUNCTION__;
    if(db.tables(QSql::Tables).count() < 1 ) {
        return false;
    }
    return true;
}


/*!
    \fn gutenDb::setEtextPath(const QString &id, const QString &path)
 */
bool gutenDb::setEtextPath(const QString &id, const QString &path)
{
    qWarning() << __PRETTY_FUNCTION__ << id << path;
    QSqlQuery query;
    QString queryCommand("INSERT INTO installed (id, filepath ) VALUES (:i, :f)");
    query.prepare(queryCommand);
    
    query.bindValue(":i",id);
    query.bindValue(":f",path);
    
    if(!query.exec()) {
        qWarning(query.lastError().driverText().toLocal8Bit());
        qWarning(query.lastQuery().toLocal8Bit());
        return false;
    }
    qWarning("Etextpath is installed");
    return true;
}


/*!
    \fn gutenDb::getEtextPath(const QString &id)
 */
QString gutenDb::getEtextPath(const QString &id)
{
    qWarning() << __PRETTY_FUNCTION__ << id;
    QSqlQuery query;
    QString queryCommand = QString("SELECT * FROM installed WHERE id = :i");
    query.prepare(queryCommand);
    query.bindValue(":i",id);
    
    if(!query.exec()) {
        qWarning(query.lastError().driverText().toLocal8Bit());
        qWarning(query.lastQuery().toLocal8Bit());
        return false;
    }
    
    while(query.next()) {
        return query.value(1).toString();
    }
    
    qWarning("Etextpath is installed");
    return QString();
}
