/*
 *  Copyright (C) 2001 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <string.h>
#include <time.h>
#include "gtm.h"
#include "log.h"

static GtkTextTag *log_text_date_tag;
static GtkTextTagTable *log_text_tags;
static GtkTextBuffer *log_text_buffer;
static GtkWidget *log_text_view;
static GtkWidget *log_text_scroll;

static gchar *
get_time_date (void)
{
    time_t cur_time;
    struct tm *tm;

    cur_time = time (NULL);
    tm = localtime (&cur_time);
    return g_strdup_printf ("%04d/%02d/%02d %02d:%02d:%02d",
                            tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday,
                            tm->tm_hour, tm->tm_min, tm->tm_sec);
}

static void
style_set_cb (GtkWidget *widget, GtkStyle *previous_style, GtkWidget *hbox)
{
    /* Set the new text box size (it tries to set it to 4 lines) */
    GtkStyle *style = gtk_widget_get_style (log_text_view);
    GdkFont *font = gtk_style_get_font (style);

    gtk_widget_set_usize (hbox, 10, 
                          (2 + gdk_char_height (font, '|')) * 4 + 10);
}

GtkWidget *
log_create (void)
{
    GtkWidget *hbox;
    gchar *log_start_text, *time_date;
    GdkColormap *cmap;
    GdkColor color;

    log_text_date_tag = gtk_text_tag_new ("date");
    cmap = gdk_colormap_get_system ();
    color.red = 0;
    color.green = 0;
    color.blue = 0xcccc;
    if (!gdk_color_alloc (cmap, &color)) {
        g_warning ("Couldn't allocate color");
    } else {
      g_object_set (G_OBJECT (log_text_date_tag),
		    "foreground-gdk", &color, NULL);
    }

    log_text_tags = gtk_text_tag_table_new ();
    gtk_text_tag_table_add (log_text_tags, log_text_date_tag);

    log_text_buffer = gtk_text_buffer_new (log_text_tags);

    hbox = gtk_hbox_new (FALSE, 0);
    log_text_view = gtk_text_view_new_with_buffer (log_text_buffer);
    log_text_scroll = gtk_scrolled_window_new (NULL, NULL);

    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (log_text_scroll),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
				    
    gtk_container_add (GTK_CONTAINER (log_text_scroll), log_text_view);

    gtk_box_pack_start (GTK_BOX (hbox), log_text_scroll, TRUE, TRUE, 0);
    gtk_signal_connect (GTK_OBJECT (log_text_view), "style_set",
                        GTK_SIGNAL_FUNC (style_set_cb),
                        (gpointer) hbox);

    gtk_widget_show_all (hbox);

    time_date = get_time_date ();
    log_start_text =
        g_strdup_printf (_ ("GTM Log started on %s\n"), time_date);

    gtk_text_buffer_set_text (log_text_buffer, log_start_text, -1);
    g_free (time_date);
    g_free (log_start_text);

    return hbox;
}

void
log_insert_entry (gchar *text)
{
    GtkTextIter iter;
    gchar *time_date;

    gtk_text_buffer_get_end_iter (log_text_buffer, &iter);
    gtk_text_buffer_insert (log_text_buffer, &iter,
			    "\n", -1);
    time_date = get_time_date ();
    gtk_text_buffer_insert_with_tags (log_text_buffer, &iter, time_date, -1,
				      log_text_date_tag, NULL);
    g_free (time_date);
    gtk_text_buffer_get_end_iter (log_text_buffer, &iter);
    gtk_text_buffer_insert (log_text_buffer, &iter, ": ", -1);
    gtk_text_buffer_get_end_iter (log_text_buffer, &iter);
    gtk_text_buffer_insert (log_text_buffer, &iter, text, -1);
}
