#
#  gpsman --- GPS Manager: a manager for GPS receiver data
#
# Copyright (c) 1998-2008 Miguel Filgueiras mig@ncc.up.pt Universidade do Porto
#
#    This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.
#
#  File: langengl.tcl
#  Last change:  18 September 2008
#
# French language file by Valre Robin (valere.robin _AT_ wanadoo.fr)
#  Last change by him:  11 November 2001
#  last input from him inserted:  18 September 2008
#
# Includes contributions by Jean H Theoret (ve2za _AT_ rac.ca)
# Includes contributions by Benoit Steiner (benetsteph _AT_ free.fr)
# Includes typo corrections by Laurent Bonnaud (bonnaud _AT_ lis.inpg.fr)
#

# file langengl.tcl is consulted first; no need for duplicating entries here

# only 3 chars long names; check also ALLMONTH in file i18n-utf8.tcl
set MONTHNAMES "Jan Fev Mar Avr Mai Jun Jul Aou Sep Oct Nov Dec"

set DLUNIT(KM,dist) km
set DLUNIT(KM,subdist) m
set DLUNIT(KM,speed) km/h
set DLUNIT(KM,area) "km2"
set DLUNIT(NAUTMILE,dist) "mn"
set DLUNIT(NAUTMILE,area) "mn2"
set DLUNIT(NAUTMILE,speed) noeud

set DLUNIT(M,dist) $DLUNIT(KM,subdist)
set DLUNIT(FT,dist) $DLUNIT(STATMILE,subdist)

set DTUNIT $DLUNIT($DISTUNIT,dist)
set SPUNIT $DLUNIT($DISTUNIT,speed)
set ARUNIT $DLUNIT($DISTUNIT,area)
set ALUNIT $DLUNIT($ALTUNIT,dist)

set MESS(RTcomp) "#\tWP\t\t$DTUNIT\tdeg\t$ALUNIT"
set MESS(TRcomp) "#\t\t\t\t$ALUNIT\t$DTUNIT\t$DTUNIT\th:m:s\t$SPUNIT\tdeg"
set MESS(WPNearest) "WP\t\t$DTUNIT\tdeg"

array set MESS {
    badscale   "Valeur errone pour l'chelle de la carte"
    oktoexit   "Ok pour quitter (les donnes non sauves vont tre perdues)"
    okclrmap   "Ok pour effacer la carte"
    namelgth   "Le nom ne doit pas dpasser %d caractres"
    cmmtlgth   "=== Un commentaire ne peut dpasser %d caractres"
    namevoid   "Le nom ne peut tre vide"
    baddate   "Date errone; ligne"
    badhdg   "Mauvais en-tte %s: doit tre %s ou +/-"
    badcoord   "Mauvais format ou intervalle de coordonnes: \"%s\" doit tre %s"
    outofrng   "Nombre non valide"
    UTMZN   "Doit tre une lettre parmi A..H, J..N, ou P..Z"
    badstrg "Caractre(s) erron(s)"
    strgvoid   "Une chane de caractre ne peut tre vide"
    nan   "\"%s\" n'est pas un nombre"
    written   "crit par"
    undefWP   "L'itinraire %s a des points (WPs) non dfinis; non sauv ou export"
    bigRT   "Itinraire %s > nombre max; non export"
    unkndatum   "Donne inconnue"
    badcommdWP   "Mauvaise commande en chargeant les WPs; ligne"
    notabsWP   "Mauvaise dfinition d'un point d'itinraire; pas de tabulation, ligne"
    undefinedWP   "Rfrence  un point d'itinraire inconnu: %s"
    nofieldsWP   "Mauvais point d'itinraire, pas assez de champs; ligne"
    excfieldsWP  "Mauvais point d'itinraire, trop de champs; ligne"
    badWPsRT   "Route avec une liste de points d'itinraire errone; ligne"
    toomuchWPs   "Attention: plus de %d points dans l'itinraire"
    badcommdTP   "Mauvaise commande lors du chargement de TPs; ligne"
    badTP    "Mauvais point dans la trace; ligne"
    badTPsTR   "Trace avec une liste errone de points; ligne"
    noheader   "Le fichier ne commence pas par un en-tte"
    loaderr   "Erreur lors du chargement du fichier; ligne"
    unkncommd   "Commande errone lors du chargement du fichier; ligne"
    noformat   "Le fichier ne commence pas par une ligne Format"
    badformat   "Mauvaise ligne format"
    badRT   "Mauvaise dfinition de route; ligne"
    badRTargs   "Argument de route erron; ligne"
    badTR   "Mauvaise dfinition de trace; ligne"
    fileact   "%s le fichier de %s?"
    filexists   "Le fichier existe!"
    GPSok   "Connexion correcte"
    toomany   "Trop de %ss (> %d)"
    cantfgt   "Oubli impossible %s: appartient  un item de la carte"
    cantfgted   "Oubli impossible %s: en cours d'dition"
    cantmapRTunkn   "La route n'est pas sur la carte; pas d'info sur point d'itinraire"
    cantmapRTed   "La route n'est pas sur la carte; point d'itinraire en cours d'dition"
    cantrun   "Excution impossible"
    inprogr   "Opration en cours"
    cantread   "Lecture du fichier auxiliaire impossible"
    cantwrtopt   "criture du fichier de prfrence impossible"
    voidRT   "La route ne contient pas de points"
    activeRT   "La route 0 est active; continuer?"
    voidTR   "La trace ne contient pas de points"
    idinuse   "Identificateur dj utilis"
    cantunmap  "Impossible d'liminer %s de la carte: appartient  un item de la carte"
    askrevert   "Retour aux donnes initiales?"
    askforget   "Oubli de ce %s?"
    notimpl   "Non implment"
    forgetall   "Oubli de tous les lments %s de la liste?"
    counted   "Il y a %d %ss dfini(e)s"
    notlisted   "Item non list"
    wrgval   "Valeur errone pour"
    voidGR   "Le groupe n'a pas d'lment."
    initselfGR   "Le groupe se contient lui mme par"
    GRelout   "La commande pour GR est hors d'une dfinition; ligne"
    badGRels   "Groupe avec une mauvaise liste d'lments; ligne"
    badcommdGRel   "Commande errone lors du chargement d'lments GR; ligne"
    notypeforGRel   "lment sans type; ligne"
    badGRel   "Mauvaise dfinition d'lment; ligne"
    check   "Connexion en cours de vrification"
    toomanyerr   "Erreurs trop nombreuses; abandon..."
    getWP   "Acquisition des points d'itinraire"
    getRT   "Acquisition des routes"
    getTR   "Acquisition des traces"
    getLAP  "Acquisition des tapes"
    putWP   "Chargement des points d'itinraire"
    putRT   "Chargement des routes"
    putTR   "Chargement des traces"
    fillbuffWP  "Chargement des buffers de point d'itinraire"
    fillbuffRT  "Chargement des buffers de RT"
    noACKNAK  "Rception d'un paquet au lieu de ACK/NAK; vrifier la connexion GPS"
    badplatform   "Pas de port d'entre/sortie"
    badserial "Impossibilit d'ouvrir le priphrique %s"
    nodata    "Pas de %ss dans le rcepteur"
    badimage "Fichier image erron"
    mapadjust "Placer les points d'itinraire sur la carte puis cliquer sur Ok"
    duplicate "%s est dj slectionn"
    clrcurrmap "Effacement de la carte courante?"
    mbkbaddatum "Donnes absentes ou inconnues"
    mbkbadscale "L'chelle ne doit pas tre ngative"
    mbkbadat "Arguments errons"
    edityourrisk "ditez  vos risques!"
    okclrbkmap   "Ok pour effacer le fond de carte"
    okclrbkim    "Ok pour effacer l'image "
    badSYMBOLcode "Code de symbole erron"
    badDISPOPTcode "Code d'option d'affichage erron"
    goingdown "Prfrences sauvegardes; redmarrer"
    putwhat "criture de quel type d'item?"
    readwhat "Lecture de quel type d'item?"
    noWPinx "Trop de points d'itinraire pour le rcepteur"
    noICinx "Trop d'icnes pour le rcepteur"
    getIC "Rception des icnes"
    serial1 "Prambule de l'en-tte erron"
    serial2 "Commande incorrecte"
    checksum1 "Checksum de l'en-tte erron"
    checksum2 "Checksum sur les donnes erron"
    receiver "Priphrique non connect!"
    importonly1 "Importation d'une seule sorte de donnes"
    exportonly1 "Exportation d'une seule sorte de donnes"
    outdatedprefs "Fichier des prfrences prim ;  vrifier maintenant"
    mustchoose1type "Il faut slectionner une seule sorte d'item"
    nosuchitems "Pas d'lment correspondant  la description"
    resultsin "Rsultats de recherche dans le groupe"
    badWP "point d'itinraire non dfini ou absent"
    badangle "L'angle doit tre compris entre 0 et 360 degrs"
    georefhow  "Mthode de go-rfrencement"
    cantsolve  "Rsolution de l'quation impossible"
    transfcantscale "chelle absente dans la transformation courante"
    oldfilefmt "Format de fichier prim ; merci de sauver dans le nouveau format de fichier"
    unknProj "Projection de la carte inconnue"
    unknTransf "Transformation de la carte inconnue"
    badProjargs "Arguments de la projection errons"
    badTransfargs "Arguments de la transformation errones"
    badfield "Mauvaise paire d'attribut-valeur"
    badattr "Mauvais nom d'attribut"
    missattrs "Argument manquant"
    mbkbadproj "Projection de la carte errone"
    mbkbadtransf "Transformation de la carte errone"
    notUTMproj "Information sauvegarde pour l'UTM; continuer avec la projection"
    projchg    "Merci de confirmer les paramtres de la projection"
    badparam "Valeur errone pour %s"
    connectedto "Connect  %s"
    recnotsuppd "Modle du rcepteur non support"
    gotprots "Dfinition du protocole reue"
    badprots "Dfinition du protocole erron"
    defprots "Utilisation de la table du protocole"
    nohidden "Suppression des donnes caches?"
    badRS "Itinraire en dehors de la route dfinie; ligne"
    badWPsRSs "Itinraire avant le premier ou aprs le dernier WP; ligne"
    windowdestr "La fentre a t dtruite!"
    badhidden "Format errone pour les donnes caches"
    replname "Remplacer \"%s\" par un nom ayant au plus %d caractres parmi \"%s\""
    badalt "Valeur errone pour l'altitude"
    baddistunit "Unit de distance errone pour l'chelle de la carte dans le fichier de prfrences"
    badgridzone "Zone de grille errone"
    outofgrid "Position en dehors du domaine de la grille"
    timeoffnotint "Le dcalage horaire doit tre un entier ou se terminer par .5"
    cantchkprot "Vrification impossible avec le protocole courant"
    mustconn1st "Connexion avec le rcepteur  vrifier"
    rltmnotsupp "Journalisation en temps rel non supporte par ce rcepteur"
    createdir "Crer un rpertoire %s et redmarrer"
    oktomkdir "Accord pour crer le rpertoire %s?"
    projnameabbr "Donner un nom et un nom court  la nouvelle projection"
    abbrevinuse "Nom court dj pris"
    nameinuse "Nom dj pris"
    projinuse "La projection est dj utilise; les modifications vont tre perdues"
    gridneedsdatum "Dfinition de grille errone pour %s; donne non saisie"
    badgriddatum "La donne pour la grille %s doit tre %s"
    cantchggriddatum "La grille ncessite la donne %s"
    gridinuse "Grille utilise par %s, ne peut pas tre dtruite; continuer?"
    gridinusenochg "Grille utilise par %s; modification non prise en compte"
    cantwrtprgr "criture impossible du fichier des projections utilisateur"
    cantwrtdtel "criture impossible du fichier des donnes utilisateur"
    movingWP "Placer %s avec le bouton gauche\nAbandonner avec le bouton droit"
    missingdata "Pas assez de donnes!"
    needs1wp "L'itinraire doit contenir au moins un point"
    emptypos "Position avec des champs vides"
    cantwrtsstate "criture impossible du fichier de sauvegarde d'tat: %s"
    cantrdsstate "Lecture impossible du fichier de sauvegarde d'tat: %s"
    corruptsstate "Fichier de sauvegarde d'tat corrompu: %s"
    editrisk "ditez  vos risques!"
    savestate "Sauvegarde de l'tat courant?"
    delsstate "Destruction des fichiers de sauvegarde d'tat?"
    badmapinfo "Mauvais fichier de paramtres de carte"
    badMHloc "Localisation Maidenhead errone"
    areais "L'aire du polygone (ne se recoupant pas) est %.3f%s"
    areatoosmall "L'aire est trop petite (<0.001 km2)"
    projarea "Calcul de l'aire projete"
    selfintsct "Rptition d'un point : la route ne doit pas se recouper!"
    badinvmdist "Erreur d'approximation dans l'inversion de la distance mridienne"
    badinvproj "Erreur d'approximation dans l'inversion de la projection %s"
    negdlatlong "Intervalle lat/long erron : ne peut tre negatif!"
    allundef "Dfinitions manquantes pour les points du groupe"
    badfloats "Erreurs dans la conversion en virgule flottante; connecter tout de mme?"
    noprintcmd "Commande d'impression absente;  positionner dans les options"
    cantexecasroot "GPSMan ne peut tre excut par le super-utilisateur ROOT"
    badargtofunc "Argument erron pour la fonction %s"
    redefproj "La projection %s dfinie par l'utilisateur efface une projection prdfinie ayant le mme nom abrg ; dfinition  modifier!"
    badattr "Champ optionnel inconnu pour %s :  %s"
    badattrval "Champ optionnel erron pour %s : %s "
    couldntcd "chec du changement de rpertoire %s"
    shpext "Mauvaise extension %s; utilisation de .shp, .shx, .dbf?"
    shpcntopen "Cration/Ouverture du fichier de profil impossible"
    shpcntcrtfs "Cration des champs .dbf du profil impossible"
    shpcntwrtfs "criture des champs .dbf du profil impossible"
    shpoutmem "Saturation mmoire!"
    shpemptyfile "Fichier vide"
    shpwrongfile "Type de fichier invalide"
    shplessdim "Nombre de dimensions insuffisant dans le fichier; continuer?"
    shpbadWPinRT "%d-ime WP aux coordonnes errones ignors dans la route %s"
    badGTMvers "Version du fichier GTrackMaker inacceptable"
    badGTMfile "Chane initiale errone dans le fichier GTrackMake"
    badGTMcounts "Nombre(s) ngatif(s) dans le fichier GTrakMake"
    badGTMlat "Dbordement de la latitude dans le fichier GTrackMaker"
    badGTMlong "Dbordement de la longitude dans le fichier GTrackMaker"
    badGTMdatum "Mauvaise donne dans le fichier GTrackMaker"
    unobscmap "Erreur probablement cause par le recouvrement de la carte par une icne ou une fentre: recommencer aprs un dlai."
    cantwrtimg "Erreur d'criture dans un fichier au format %s"
    TRsimplres "Cration d'une trace simplifie %s"
    cantsaveRTid "%s route(s) non sauvegarde(s) : identifiant non numrique"
    cantsaveTRid "%s trace(s) non sauvegard(s) : identifiant non numrique"
    badtrvconf "Configuration corrompue; recommencer avec une configuration vide"
    drvsimoff "Simulateur de conduite : pas encore dmarr"
    needWP "Simulateur de conduite : charger ou dfinir des points de route"
    chgrecprot "Changer le protocole du rcepteur"
    frgetGRcs "Oubli du groupe et de tous ses lments?"
    clrtrvlog "Effacement du journal de voyage?"
    nmeainuse "Capture en temps-rel ou lecture d'un fichier NMEA en cours"
    badfile "Erreur lors de la lecture d'un fichier"
    RTnoWPname "Un point d'une route ne peux plus tre dsign uniquement par son nom"
    distlarge "Distance trop grande!"
    timeconsmg "Opration potentiellement longue: continuer?"
    badtimeval "Mauvaise heure"
    badLAP "tapes errones"
    lapncnsdrd "tapes non lues"
    undefinedTR   "TR inconnu"
    emptymenu "Menu vide; continuer?"
    cantwrtsymenu "Impossible d'criture le fichier des menus de symboles"
    cantwrtmbaks "Impossible d'criture le fichier de fond de carte"
    abbrevhasspaces "Nom court ne peut pas avoir des blancs"
    getAL  "Acquisition de l'almanach"
    needNpoints "Merci de fournir au moins %s points!"
    twotimeoffsets "Fichier contenant des dcalages horaires diffrents"
    notimeoffset "Pas d'information de dcalage horaire, suppos nul"
    baddateas "Mauvaise format de date: %s"
    unknownenc "Code de caractre inconnu : %s"
    chgbaudto "Essai de changement de la vitesse  %s; merci d'attendre..."
    baudchgfailed "Changement de la vitesse de transfert impossible"
    busytrylater "Opration en cours; merci d'essayer plus tard"
    obssplit "Resultat de la fragmentation de la %s nomme \"%s\""
}

set TXT(RTcompflds) "# WP {$DTUNIT} deg {$ALUNIT} stage label"
set TXT(TRcompflds) \
    "TP {} {} {} {$ALUNIT} {$DTUNIT} {$DTUNIT} h:m:s {$SPUNIT} deg"
set TXT(starttoend) "Dpart: vers la fin %s $DTUNIT;"
set TXT(startmax) "max %s $DTUNIT;"
set TXT(WPnearflds) "WP {$DTUNIT} deg"
set TXT(within) "Parmi (${DTUNIT}s)"
set TXT(between) "Entre (${DTUNIT}s)"

array set TXT {
    GMtit   "GPS Manager - version"
    exit   Fin
    map   Carte
    load   Chargement
    loadfrm   "Chargement depuis"
    save   Sauvegarde
    saveels "Sauvegarde des lments"
    saveto   "Sauvegarde vers"
    clear   Effacement
    clearall   "Effacement complet"
    newWP   "Nouveau point d'itinraire"
    newRT   "Nouvelle route"
    newTR   "Nouvelle trace"
    newGR   "Nouveau groupe"
    import   Importation
    importfrm   "Importation depuis"
    export   Exportation
    exportels "Exportation depuis"
    exportto   "Exportation vers"
    count   Comptage
    trueN   "Nord vrai"
    automagn   "Auto Magntique"
    usrdef   "Dfini par l'utilisateur"
    nameWP   Point
    nameRT   Route
    nameTR   Trace
    nameGR   Groupe
    namePlot Graphique
    nameMap  Carte
    nameRTComp   "Calcul de route"
    nameTRComp   "Calcul de trace"
    GPSrec   "Rcepteur GPS"
    turnoff   "Arrt"
    get   Prendre
    put   Mettre
    all   Tout
    select   Slectionner
    selection   Slection
    options   Options
    DMS   DMS
    DMM   DMM
    DDD   DDD
    UTM/UPS   UTM/UPS
    message   Message
    cancel   Abandon
    file   Fichier
    ovwrt   craser
    app   Ajout
    onligne   "en ligne"
    offligne  "hors ligne"
    check   Vrifier
    create   Crer
    revert   Rtablir
    colour   couleur
    grey   gris
    mono   mono
    portr   portrait
    landsc   paysage
    legend   Lgende
    incscale   "Inclure l'chelle"
    more   Plus
    waypoint   Waypoint
    name   Nom
    created Cr
    cmmt   Commentaire
    withWP  "Avec ce point d'itinraire:"
    displ   "Afficher sur la carte"
    startRT "Dmarrage de la route"
    route   Route
    number   Nombre
    insb   "Insrer avant"
    insa   "Insrer aprs"
    del   Dtruire
    repl   "Remplacer par"
    comp   Calculer
    RTcomp   "Calcul de route"
    savecomp "Sauvegarde du calcul"
    totdst   "Distance totale"
    tottime   "Temps total"
    track   Trace
    chophd   "Supprimer avant"
    choptl   "Supprimer aprs"
    incb   "Inclure avant"
    date   Date
    newdate   "Nouvelle date pour le point suivant"
    endprTR   "Fin de la trace prcdente"
    begnxt   "Dbut du prochain"
    date1st   "Date du premier point du prochain"
    TRcomp   "Calcul de trace"
    avgsp   "Vitesse moyenne"
    maxsp   "Vitesse maximale"
    minsp   "Vitesse minimale"
    lat   Lat
    long   Long
    ze   ZE
    zn   ZN
    eastng   "Est"
    nrthng   "Nord"
    zone   Zone
    change   Changer
    forget   Oublier
    others   Autres
    opt_Interf  "Interface utilisateur"
    optLANG   Langage
    optISOLATIN1   "Caractres composs"
    optDELETE   "DEL efface le dernier caractre"
    optMWINDOWSCONF  "Fentre principale"
    optGPSREC   "Modle de GPS"
    opt_GPSRecConf   "Paramtres du rcepteur"
    optNAMELENGTH   "Longueur maximale pour un nom"
    optINTERVAL "Intervale d'chantillonage"
    optCOMMENTLENGTH   "Longueur maximale pour un commentaire"
    optMAXWPOINTS   "Nombre max des points d'itinraire"
    optMAXROUTES   "Nombre max de routes"
    optMAXWPINROUTE   "Nombre max de points dans une route"
    optMAXTPOINTS   "Nombre max de points dans une trace"
    optCREATIONDATE   "L'enregistrement a une date de cration"
    optNOLOWERCASE   "L'enregistrement n'a pas de minuscule"
    optDEFAULTSYMBOL "Symbole par dfaut pour un point d'itinraire"
    optDEFAULTDISPOPT "Option d'affichage par dfaut pour un point d'itinraire"
    opt_Data "Donnes"
    optEQNAMEDATA "Donne avec le mme nom"
    optKEEPHIDDEN "Garder les donnes caches"
    optDatum   Donne
    optTimeOffset   "Dcalage horaire"
    optACCFORMULAE "Formule juste"
    optASKPROJPARAMS "Confirmer les paramtres de projection"
    optBalloonHelp "Bulles d'aide"
    optNumberingTracks "Numrotation des points des traces"
    opt_Formats   "Units et formats"
    optDISTUNIT   "Distance"
    KM    km
    NAUTMILE    "mile nautique"
    STATMILE    "mile"
    optPositionFormat   "Format de position"
    optDateFormat   "Format de date"
    opt_Geom   "Gomtrie des fentres"
    opt_MapGeom   "Gomtrie des cartes"
    optMAPWIDTH   "Largeur de carte"
    optMAPHEIGHT   "Hauteur de la carte"
    optMAPSCLENGTH   "Longueur de l'chelle"
    optMAPSCALE   "chelle de la carte"
    optMAXMENUITEMS   "Nombre maximum d'lments par menu"
    optLPOSX   "Abscisse de la fentre des listes"
    optLPOSY   "Ordonne de la fentre des listes"
    optMPOSX   "Abscisse de la fentre de la carte"
    optMPOSY   "Ordonne de la fentre de la carte"
    optRPOSX   "Abscisse de la fentre du rcepteur"
    optRPOSY   "Ordonne de la fentre du rcepteur"
    optEPOSX   "Abscisse de la fentre d'erreur"
    optEPOSY   "Ordonne de la fentre d'erreur"
    optDPOSX   "Abscisse de la fentre de dialogue"
    optDPOSY   "Ordonne de la fentre de dialogue"
    optDPOSRTMAP "Position de la fentre de route par rapport  la carte"
    optLISTWIDTH   "Largeur de la liste"
    optLISTHEIGHT  "Hauteur de la liste"
    optCOLOUR   Couleurs
    optCOLOUR,fg   "Premier plan"
    optCOLOUR,bg   "Fond d'cran"
    optCOLOUR,messbg   "Fond pour les erreurs"
    optCOLOUR,confbg   "Fond pour les confirmations"
    optCOLOUR,selbg    "Fond pour les slections"
    optCOLOUR,dialbg   "Fond pour les saisies"
    optCOLOUR,offligne "Rcepteur hors ligne"
    optCOLOUR,onligne  "Rcepteur en ligne"
    optCOLOUR,check    "Bouton  cocher slectionn"
    optCOLOUR,ballbg   "Fond pour les bulles d'aide"
    optCOLOUR,ballfg   "Premier plan pour les bulles d'aide"
    optMAPCOLOUR  "Couleur pour la carte"
    optMAPCOLOUR,mapsel   "Item slectionn"
    optMAPCOLOUR,WP   "Points sur la carte"
    optMAPCOLOUR,RT   "Routes sur la carte"
    optMAPCOLOUR,mkRT "Routes dfinies sur la carte"
    optMAPCOLOUR,TR   "Traces sur la carte"
    optMAPCOLOUR,TP   "Point d'itinraire sur la carte"
    optMAPCOLOUR,mapleg   "Lgende de la carte"
    optMAPCOLOUR,anim  "Animation sur la carte"
    optMAPCOLOUR,emptygrid  "Image vide"
    optMAPCOLOUR,fullgrid   "Image existante"
    opt_Files "Priphriques et fichiers"
    optDEFSPORT "Priphrique"
    optSAVESTATE "Sauvegarde de l'tat en quittant"
    optDELSTATE "Destruction des fichiers aprs avoir restaur l'tat"
    optPERMS   "Permission du fichier"
    optPAPERSIZE "Taille du papier"
    red   Rouge
    green   Vert
    blue   Bleu
    owner   Propritaire
    permgroup   Groupe
    others   Autres
    fread   Lecture
    fwrite   criture
    fexec   Excution
    YYYYMMDD   AAAAMMJJ
    MMDDYYYY   MMJJAAAA
    DDMMMYYYY   JJMMAAAA
    YYYY-MM-DD  AAAA-MM-JJ
    mainwd   "Fentre principale"
    distazim   "Distance et direction"
    nearestWPs   "Points les plus proches"
    fromto   "De %s  %s"
    degrees   degrs
    nameWPDistBear   "distance et direction"
    nameWPNearest   "point d'itinraire le plus prs"
    inrect   "Dans le rectangle"
    forthisWP   "pour ce point d'itinraire"
    formappedWPs   "pour les points d'itinraire sur la carte"
    group   Groupe
    element   lment
    insert   Insertion
    joinGR   "Joindre au groupe"
    TRtoRT   "Conversion de trace en route"
    TRRTnpoints   "Nombre de points  garder"
    TRTRdispl   "Affichage de la trace"
    WP   WP
    RT   RT
    TR   TR
    GR   GR
    commrec   "Communication avec le rcepteur"
    abort   Arrt
    ACKs   ACKs
    NAKs   NAKs
    packets   paquets
    unnamed   "(inconnu)"
    fromTR    "Depuis la trace : %s"
    mapload "Image de go-rfrencement"
    loadmback Chargement
    savemback "Sauvegarde des informations de go-rfrencement"
    chgmback Modification
    clearmback Effacement
    backgrnd Fond
    nameMapBkInfo "Fond de carte"
    nameMapInfo "Paramtres de la carte"
    mpbkchg "Changement du fond"
    mpbkgrcs "Position de la grille"
    nameImage Image
    symbol Symbole
    SYCATgeneral "Utilisation gnrale"
    SYCATland Terre
    SYCATwater Eau
    SYCATaviation Aviation
    SY1st_aid "Premiers secours"
    SYWP_buoy_white "Boue, blanche"
    SYWP_dot "WP"
    SYairport "Aroport"
    SYamusement_park "Parc de loisirs"
    SYanchor "Ancre"
    SYavn_danger "Danger"
    SYavn_faf "Premier point d'approche"
    SYavn_lom "Localizer outer marker"
    SYavn_map "Point d'approche manqu"
    SYavn_ndb "Signal ND"
    SYavn_tacan "TACAN"
    SYavn_vor "VHF omni-range"
    SYavn_vordme "VOR-DME"
    SYavn_vortac "VOR/TACAN"
    SYball "Balle"
    SYbeach "Plage"
    SYbell "Cloche"
    SYboat "Bateau"
    SYboat_ramp "Embarcadre"
    SYborder "Poste frontire"
    SYbowling "Bowling"
    SYbridge "Pont"
    SYbuilding "Btiment"
    SYbuoy_amber "Boue, ambre"
    SYbuoy_black "Boue, noire"
    SYbuoy_blue "Boue, bleue"
    SYbuoy_green "Boue, verte"
    SYbuoy_green_red "Boue, verte et rouge"
    SYbuoy_green_white "Boue, verte et blanche"
    SYbuoy_orange "Boue, orange"
    SYbuoy_red "Boue, rouge"
    SYbuoy_red_green "Boue, rouge et verte"
    SYbuoy_red_white "Boue, rouge et blanche"
    SYbuoy_violet "Boue, violette"
    SYbuoy_white "Boue, blanche"
    SYbuoy_white_green "Boue, blanche et verte"
    SYbuoy_white_red "Boue, blanche et rouge"
    SYcamping "Campement"
    SYcapitol_city "Ville, toile"
    SYcar "Vhicule"
    SYcar_rental "Location de vhicule"
    SYcar_repair "Garage"
    SYcasino "Casino"
    SYcastle "Chteau"
    SYcemetery "Cimetire"
    SYchapel "Chapelle"
    SYchurch "glise"
    SYcircle_x "Rond avec un X"
    SYcivil "Civil location"
    SYcontrolled "Aire rglemente"
    SYcrossing "Croisement"
    SYdam "Barrage"
    SYdanger "Danger"
    SYdeer "Cerf"
    SYdiamond_green "Diamant, vert"
    SYdiamond_red "Diamant, rouge"
    SYdiver_down_1 "Plonge 1"
    SYdiver_down_2 "Plonge 2"
    SYdollar "Dollar"
    SYdot "Point"
    SYdrinking_water "Eau potable"
    SYduck "Canard"
    SYelevation "Altitude"
    SYexit_no_serv "Sortie, pas de service"
    SYexit "Sortie"
    SYfactory "Usine"
    SYfastfood "Restauration rapide"
    SYfish "Poisson"
    SYfitness "Remise en forme"
    SYflag "Drapeau"
    SYfreeway "Autoroute"
    SYfuel "Carburant"
    SYfuel_store "Carburant et magasin"
    SYgeo_name_land "Nom topographique, naturel"
    SYgeo_name_man "Nom topographique, artificiel"
    SYgeo_name_water "Nom topographique, eau"
    SYglider "Planeur"
    SYgolf "Golf"
    SYheliport "Hliport"
    SYhorn "Corne"
    SYhouse "Maison"
    SYice_skating "Patinoire"
    SYinfo "Point d'information"
    SYintersection "Intersection"
    SYis_highway "Autoroute"
    SYknife_fork "Nourriture"
    SYladder "chelle"
    SYlanding "Atterrissage"
    SYlarge_city "Ville, grande"
    SYlarge_exit_ns "Sortie sans service, grande"
    SYlarge_ramp_int "Ramp int, large"
    SYlevee "Digue"
    SYlight "Lumire"
    SYlodging "Hbergement"
    SYmany_fish "Banc de poisson"
    SYmany_tracks "Nombreuses traces"
    SYmark_x "Marque, x"
    SYmedium_city "Ville, moyenne"
    SYmile_marker "Point kilomtrique"
    SYmilitary "Zone militaire"
    SYmine "Mine"
    SYMOB "Homme  la mer"
    SYmonument "Monument"
    SYmountains "Montagnes"
    SYmovie "Cinma"
    SYmug "Mug"
    SYmuseum "Muse"
    SYntl_highway "Autoroute nationale"
    SYnull "(transparent)"
    SYnull_2 "(vide)"
    SYoil_field "Puits de ptrole"
    SYparachute "Parachute"
    SYpark "Parc"
    SYparking "Parking"
    SYpharmacy "Pharmacie"
    SYphone "Tlphone"
    SYpicnic "Pique nique"
    SYpizza "Pizza"
    SYpolice "Police"
    SYpost_office "Bureau de poste"
    SYprivate "Proprit prive"
    SYradio_beacon "Signal radio"
    SYramp_int "Croisement de rampes"
    SYrestricted "Aire  accs restreint"
    SYrestrooms "WC"
    SYRV_park "Camping car"
    SYscenic "Point de vue"
    SYschool "cole"
    SYseaplane "Base d'hydravion"
    SYshopping_cart "Commerces"
    SYshort_tower "Tour, courte"
    SYshowers "Douches"
    SYskiing "Ski nautique"
    SYskull "Skull"
    SYsmall_city "Ville, petite"
    SYsnow_skiing "Ski"
    SYsoft_field "Zone meuble"
    SYsquare_green "Carr, vert"
    SYsquare_red "Carr, rouge"
    SYst_highway "Autoroute rgionale"
    SYstadium "Stade"
    SYstore "Magasin"
    SYstreet_int "Croisement de rues"
    SYsummit "Sommet"
    SYswimming "Natation"
    SYtake_off "Dcollage"
    SYtall_tower "Tour, haute"
    SYtheater "Thtre"
    SYtoll "Page"
    SYtow_truck "Dpanneuse"
    SYtraceback "Itinraire de retour"
    SYtracks "Traces"
    SYtrail_head "Dpart de piste"
    SYtree "Arbre"
    SYtruck_stop "Arrt pour camion"
    SYtunnel "Tunnel"
    SYultralight "ULM"
    SYus_highway "Autoroute nord amricaine"
    SYweight_station "Station de pesage"
    SYwreck "pave"
    SYzoo "Zoo"
    psvisible "Seul lment visible"
    DISPsymbol "Symbole uniquement"
    DISPs_name "Symbole et nom"
    DISPs_comment "Symbole et commentaire"
    DISPname "Nom uniquement"
    DISPcomment "Commentaire uniquement"
    dispopt "Affichage"
    mapitems "Affichage des lments sur la carte"
    nameIC "Icne"
    prod "Produit"
    WPCapac "Capacit en points d'itinraire"
    ICCapac "Capacit en icnes"
    RTCapac "Capacit en route"
    TRCapac "Capacit en traces"
    protcl "Protocole"
    ICGraph "Graphique des icnes"
    WPperRT "Point par route"
    notinGR "n'est pas dans le (sous-)groupe"
    onlyinGR "uniquement dans le (sous-)groupe"
    loadgrels "Chargement des lments"
    importgrels "Importation des lments"
    about "Informations sur GPSman..."
    contrib "   Contributions de"
    errorsto "Error reports to:"
    obsTRToRT "WPs created by a TR to RT conversion"
    nameLists "Listes"
    nameData "Donnes"
    MWCmap "Cartes"
    MWClists "Listes"
    MWCsingle "Fentre simple"
    search "Recherche"
    rmrk "NB"
    closeto "Fermer vers"
    with "Avec"
    srchres "Trouv"
    database "Base de donnes"
    where "O"
    what "Quoi"
    list "liste"
    distance "Distance"
    fromWP "depuis le point"
    fromPos "depuis la position"
    azimuth "Direction"
    any "indiffrente"
    opening "Ouverture"
    suggested "suggr"
    another "Un autre"
    srchdd1 "Recherche sur"
    srchdd2Data "tous les lments"
    srchdd2GR "Groupe(s)"
    from "depuis"
    started "partant de "
    transf  "Transformation de coordonnes"
    TRNSFAffine    "Affine"
    TRNSFAffineConf  "Affine Conforme"
    TRNSFNoRot      "Conforme sans rotation"
    projection "Projection"
    lat0  "Latitude du centre"
    long0 "Longitude centre"
    lat1  "Latitude du 1er parallle"
    lat2  "Latitude du 2me parallle"
    latF  "Latitude de l'origine errone"
    longF "Longitude de l'origine errone"
    k0 "Facteur d'chelle"
    PRJUTM "UTM/UPS"
    PRJTM "Mercator Transverse"
    PRJCMP "Carte Militaire Portugaise"
    PRJBNG "Grille Nationale Britannique"
    PRJBWI "British West Indies"
    PRJITM "Mercator Transverse Irlandaise"
    PRJGKK "Grille Allemande"
    PRJLCC1 "Lambert Conique Conf 1"
    PRJLCC2 "Lambert Conique Conf 2"
    PRJKKJP "Grille Finlandaise de base"
    PRJKKJY "Grille Finlandaise uniforme"
    PRJSEG "Grille Sudoise"
    PRJMerc1 "Mercator 1"
    PRJMerc2 "Mercator 2"
    PRJCS "Cassini-Soldner"
    dontaskagain "Ne plus demander"
    rename "Utiliser le nouveau nom"
    oname "Nom d'origine"
    never "Jamais"
    ask "Demander"
    always "Toujours"
    stage "tape"
    label "tiquette"
    alt "Altitude"
    optALTUNIT "Altitude"
    locate "Localiser"
    animation  Animation
    fast Rapide
    slow Lent
    start "Dpart"
    pause Pause
    speed Vitesse
    centred "Centrage"
    state "tat"
    animinit "dbut / fin"
    animon "en cours"
    animpause "en pause"
    animabort "arrt"
    realtimelog "Traage en temps rel"
    garmin Garmin
    nmea "NMEA 0183"
    stext "Simple texte"
    simul "Simulateur"
    lowrance Lowrance
    getlog "Charger le journal"
    stop "Arrt"
    dolog "Enregistrement"
    show Montrer
    hide Cacher
    posfixerror erreur
    posfix_  ?
    posfix2D 2D
    posfix3D 3D
    posfix2D-diff "2D d"
    posfix3D-diff "3D d"
    posfixGPS GPS
    posfixDGPS DGPS
    posfixAuto ok
    posfixsimul simul
    restart "Redmarrage"
    mkTR "Faire une route"
    PVTflds "# t lat long alt fix EPE EPH EPV vel_x vel_y vel_z TRK"
    namePVTData "Journaliser les donnes"
    mkavgWP "Calcul du point moyen"
    move Dplacer
    define Dfinir
    open Ouvrir
    defs "Dfinitions"
    baseproj "Projection de base"
    abbrev "Nom court"
    grid Grille
    use Utiliser
    unit Unit
    feasting "Erreur sur l'axe Est-Ouest"
    fnorthing "Erreur sur l'axe Nord-Sud"
    bounds Limite
    max Max
    min Min
    easting "Axe Est-Ouest"
    northing "Axe Nord-Sud"
    fixeddatum "donnes fixes"
    elevation Altitude
    usewps "Utiliser les points d'itinraire"
    chgpfrmt "Changer le format de position"
    here Ici
    atprevwp "Au point prcdent"
    prevwp "Point prcdent"
    firstwp "Premier point"
    chglstrs "diter la phase prcdente"
    chgnxtrs "diter la phase suivante"
    contnend "Ajouter en fin"
    closemenu "Fermeture du menu"
    ellpsd Ellipsode
    datum Datum
    userdefs "Dfinitions de l'utilisateur"
    edmap "diter sur la carte"
    actual "rel"
    rtimelogintv "Intervalle de journalisation"
    inca "Inclure aprs"
    invert "Inverser"
    recwindow "Fentre du rcepteur"
    volume "Volume"
    latS "Lat Sud"
    latN "Lat Nord"
    longW "Long Ouest"
    longE "Long Est"
    no Non
    PRJAPOLY "Polyconique amricaine - American Polyconic"
    computations Calculs
    comparea "Calcul de l'aire"
    cluster "Groupement de points"
    mkclusters "Construction de groupements"
    dlat "Intervalle de latitude"
    dlong "Intervalle de longitude"
    collcntr "Dtection des centres..."
    compclstr "Calcul des groupements..."
    crtgclstrgrs "Cration des groupes..."
    PRJStereogr "Strographique"
    PRJTWG "Grille tawanaise"
    chgdatum "Remplacer datum..."
    optPRINTCMD "Commande d'impression"
    optMAPFONTSIZE "Taille de police pour la carte"
    print Impression
    prevctr "Centre prcdent"
    PRJSOM "Mercator Oblique Suisse"
    PRJLV03 "Grille suisse LV03"
    PRJIcG "Grille islandaise"
    PRJRDG "Grille nerlandaise"
    chgmfsize "Changement de taille pour la police de la carte"
    printopt "Options d'impression"
    numberid "Numro/Identifiant"
    hiddendata "Donne masque"
    YYYY/MM/DD  YYYY/MM/DD
    cwpsdef "Dfinir les point de contrle"
    nextTP "Prochain point de trace"
    generate "Gnrer"
    generateall "Gnrer tout"
    optSERIALBAUD "Vitesse de transfert"
    optDEFTRTWIDTH "Largeur des routes"
    optDEFTTRWIDTH "Largeur des traces"
    width "Largeur"
    TRtoTR   "Simplification d'une trace"
    TRlinedispl   "Affichage des rsultats"
    obsTRsimpl "Trace rsultant d'une simplification"
    simplTRto "Simplifier en"
    exstglog "Journal existant"
    contnsly "en continu"
    animate "animer"
    animabbrev "anim."
    noanabbr "pas d'anim."
    zelev "Echelle-Z"
    xyelev "Echelle-XY"
    notext "sans texte"
    view "vue"
    sideview "vue de cot"
    persptv "Perspective"
    SYgeocache "Gocache"
    SYgeocache_fnd "Gocache trouve"
    optMAPCOLOUR,trvtrk "Flche de trace"
    optMAPCOLOUR,trvtrn "Flche "
    optMAPCOLOUR,trvcts "Flche de course"
    optMAPCOLOUR,trvcts2 "Seconde flche de course"
    optMAPCOLOUR,trvvel_z "Flche haut/bas"
    optMAPCOLOUR,trvwrnimportant "Avertissement important (nav)"
    optMAPCOLOUR,trvwrnnormal "Avertissement (nav)"
    optMAPCOLOUR,trvwrninfo "Information (nav)"
    travel "Voyage"
    notravel "Arrt du voyage"
    optTRAVELFONTSIZE "Taille de la police d'affichage des voyages"
    travdisplay "Configuration de l'affichage"
    travchgdisplay "Changement pour l'affichage %s"
    travdsetup "Configuration de l'affichage du voyage"
    navMOB "Homme  la mer"
    startnav "Navigation"
    navWP "Aller au point"
    goback "Retour"
    follow "Suivre %s"
    exactly "exactement"
    fromnrst "depuis le plus prs"
    inrvrs " l'envers"
    forgetgoal "Oubli du but"
    suspend "Suspension"
    resume "Reprise"
    TRVfix "Fix"
    TRVhour "Heure"
    TRVspeed "Vitesse"
    TRVpos "Pos."
    TRValt "Alt."
    TRVtrk "Dir."
    TRVnxtWP "Vers"
    TRVprvWP "Depuis"
    TRVete "ETE"
    TRVeta "ETA"
    TRVvmg "VMG"
    TRVxtk "XTK"
    TRVcts "Dir."
    TRVtrn "Rot."
    TRVvel_z "Vitesse vert."
    TRVtrkcts "Trace, dir."
    TRVdist "Dist"
    TRVc_trkcts "Flche"
    TRVc_trn "Flche"
    TRVc_vel_z "Haut/Bas"
    add "Ajout"
    addlabelled "Ajout avec tiquette"
    remove "Suppression"
    mindist "Distance cible"
    chginggoal "Changement vers le but suivant"
    chggoalhlp "Changement depuis le but\ncourant jusqu'au prochain\nsur une route"
    soon "bientt"
    late "tard"
    warnings "Avertissements"
    dowarn "mission d'avertissements"
    warnconf "Configuration d'avertissements"
    priority "Priorit"
    high "haute"
    medium "mdiane"
    low "basse"
    warnprox "Distance au point <"
    warnanchor "Distance au point >"
    warnspeed "Vitesse >"
    warntrn "Rotation (abs.) >"
    warnvspeed "Vitesse verticale"
    warnxtk "XTK (abs.)>"
    fntsize "Taille de police"
    trvhlpbox "Utiliser le bouton droit pour rordonnancer les lments ci-dessous"
    trvhlpbxs "Utiliser le bouton droit pour rordonnancer les lments de la liste"
    trvwarrv "Arrive  %s!"
    trvwleave "Dpart de %s!"
    trvwspeed "Vitesse > %s!"
    trvwtrn "Rotation > %s!"
    trvwvspeed "Vitesse verticale en dehors de [%s,%s]!"
    trvwxtk "XTK > %s!"
    trvwnolog "Journalisation en temps-rel arrte"
    trvwnopos "Positions prcdentes indisponibles"
    trvwuwps "La route a des points indfinis."
    trvwchg "Aller au prochain %s"
    TP "Point de trace"
    drivesim "simulateur de conduite"
    startfrom "Dpart depuis..."
    outofctrl "Hors de contrle"
    right "Droite"
    left "Gauche"
    straight "Tout droit"
    rthlpdsim "Flches : conduite, changement de vitesse\nEspace : tout droit"
    forgetGRcs "Oubli du groupe+els"
    renres "NOUV"
    chggoal "Changer pour le nouveau but"
    Ghidden_class Classe
    Ghidden_subclass "Sous-Classe"
    Ghidden_lnk_ident "Identifiant de scne"
    Ghidden_colour Couleur
    Ghidden_attrs Attributs
    Ghidden_depth Profondeur
    Ghidden_state "tat"
    Ghidden_country Pays
    Ghidden_facility "Immeuble"
    Ghidden_city Ville
    Ghidden_addr Adresse
    Ghidden_int_road "Croisement de rues"
    Ghidden_dtyp "Affichage options et type"
    Ghidden_ete "ETE"
    Ghidden_display "Affichage?"
    Ghidden_yes Oui
    Ghidden_no Non
    Ghidden_user "Utilisateur"
    Ghidden_user_symbol "Utilisateur (symbole uniquement)"
    Ghidden_non_user "Non utilisateur"
    Ghidden_avn_airport "Aroport"
    Ghidden_avn_inters "Avn intersection"
    Ghidden_avn_NDB "NDB"
    Ghidden_avn_VOR "VOR"
    Ghidden_avn_airp_rway "Seuil de piste d'aroport"
    Ghidden_avn_airp_int "Intersection aroport"
    Ghidden_avn_airp_NDB "Aroport NDB"
    Ghidden_map_pt "Point de carte"
    Ghidden_map_area "Zone de carte"
    Ghidden_map_int "Intersection de carte"
    Ghidden_map_addr "Adresse de carte"
    Ghidden_map_line "Ligne de carte"
    Ghidden_locked "Verrouill"
    Ghidden_default "Dfaut"
    Ghidden_black Noir
    Ghidden_white Blanc
    Ghidden_red Rouge
    Ghidden_dark_red "Rouge fonc"
    Ghidden_green Vert
    Ghidden_dark_green "Vert fonc"
    Ghidden_blue Bleu
    Ghidden_dark_blue "Bleu fonc"
    Ghidden_yellow Jaune
    Ghidden_dark_yellow "Jaune fonc"
    Ghidden_magenta Magenta
    Ghidden_dark_magenta "Magenta fonc"
    Ghidden_cyan Cyan
    Ghidden_dark_cyan "Cyan fonc"
    Ghidden_light_gray "Gris clair"
    Ghidden_dark_gray "Gris fonc"
    Ghidden_line Ligne
    Ghidden_link Etape
    Ghidden_net "Rseau"
    Ghidden_direct Direct
    Ghidden_snap Snap
    PRJBMN "Grille BMN autrichienne"
    PRJCTR "Carta Tecnica Reg (I)"
    optDEFMAPPROJ "Projection de la carte"
    optDEFMAPPFRMT "Coordonnes de la carte"
    optMapGuideVersion "Version de MapGuide"    
    undo "Dfaire"
    UTMzone zone
    tfwfile  "Ficher TFW"
    ok Ok
    GRA   Grades
    newWPatdb "Nouveau WP   ..."
    PRJLamb93 "Lambert 93"
    PRJLambNTFe "NTF IIet"
    PRJLambNTF "NTF"
    NTFzone zone
    opinprogr "Opration en cours"
    working "En cours"
    aborted "Arrt!"
    errwarn "Erreur/Avertissement(s)!"
    SYbiker "Cycliste"
    SYbox_blue "Bote, bleue"
    SYbox_green "Bote, verte"
    SYbox_red "Bote, rouge"
    SYflag_pin_blue "Epingle-Drapeau, bleue"
    SYflag_pin_green "Epingle-Drapeau, verte"
    SYflag_pin_red "Epingle-Drapeau, rouge"
    SYhouse_2 "Maison 2"
    SYpin_blue "Epingle, bleue"
    SYpin_green "Epingle, verte"
    SYpin_red "Epingle, rouge"
    changegroupsymbol "Changer le symbole"
    ozimapfile "Fichier Ozi Map"
    info "Information"
    climbrate "Vitesse verticale"
    optUSESLOWOPWINDOW "Fentre de contrle des oprations lentes"
    optDEFTRECPROTOCOL "Protocole par dfaut"
    optLNSREACT "Les lignes sur la carte sont cliquable  la souris"
    syhlpbx "Utiliser le bouton droit pour\nrordonnancer les lments de la liste"
    optDEFMAPPFDATUM "Donnes pour les coordonnes de la carte"
    mkgrp "Crer un groupe"
    dispitems "Elments affichs"
    hiditems "Elments cachs"
    optAutoNumRts "Numrotation automatique des routes pour le chargement"
    Ghidden_transparent Transparent
    Ghidden_temp "Temprature"
    Ghidden_time "Estampille temporelle"
    Ghidden_cat Categorie
    SYopen_24hr "Ouvert 24/24"
    SYfhs_facility "Etablissement FHS"
    SYbot_cond "Conditions de fond"
    SYtide_pred_stn "Station de prvision des courants et mares"
    SYanchor_prohib "Mouillage interdit"
    SYbeacon "Balise"
    SYcoast_guard "Garde-cte"
    SYreef "Rcif"
    SYweedbed "Weedbed"
    SYdropoff "Embarcadre"
    SYdock "Dock"
    SYmarina "Marina"
    SYbait_tackle "Appts et quipement de pche"
    SYstump "Tronc"
    SYcntct_smiley "Smiley"
    SYcntct_ball_cap "Casquette de baseball"
    SYcntct_big_ears "Grande oreille"
    SYcntct_spike "Clou"
    SYcntct_goatee "Bouc"
    SYcntct_afro "Afro"
    SYcntct_dreads "Dreadlocks"
    SYcntct_female1 "Femme 1"
    SYcntct_female2 "Femme 2"
    SYcntct_female3 "Femme 3"
    SYcntct_ranger "Garde forrestier"
    SYcntct_kung_fu "Kung fu"
    SYcntct_sumo "Sumo"
    SYcntct_pirate "Pirate"
    SYcntct_biker "Cycliste"
    SYcntct_alien "Alien"
    SYcntct_bug "Insecte"
    SYcntct_cat "Chat"
    SYcntct_dog "Chien"
    SYcntct_pig "Cochon"
    SYhydrant "Pompe incendie"
    SYcircle_blue "Cercle, bleu"
    SYcircle_green "Cercle, vert"
    SYcircle_red "Cercle, rouge"
    SYdiamond_blue "Diamand, bleu"
    SYoval_blue "Ovale, bleu"
    SYoval_green "Ovale, vert"
    SYoval_red "Ovale, rouge"
    SYrect_blue "Bloc, bleu"
    SYrect_green "Bloc, vert"
    SYrect_red "Bloc, rouge"
    SYsquare_blue "Carr, bleu"
    SYtriangle_blue "Triangle, bleu"
    SYtriangle_green "Triangle, vert"
    SYtriangle_red "Triangle, rouge"
    SYletter_a_blue "A, bleu"
    SYletter_a_green "A, vert"
    SYletter_a_red "A, rouge"
    SYletter_b_blue "B, bleu"
    SYletter_b_green "B, vert"
    SYletter_b_red "B, rouge"
    SYletter_c_blue "C, bleu"
    SYletter_c_green "C, vert"
    SYletter_c_red "C, rouge"
    SYletter_d_blue "D, bleu"
    SYletter_d_green "D, vert"
    SYletter_d_red "D, rouge"
    SYnumber_0_blue "0, bleu"
    SYnumber_0_green "0, vert"
    SYnumber_0_red "0, rouge"
    SYnumber_1_blue "1, bleu"
    SYnumber_1_green "1, vert"
    SYnumber_1_red "1, rouge"
    SYnumber_2_blue "2, bleu"
    SYnumber_2_green "2, vert"
    SYnumber_2_red "2, rouge"
    SYnumber_3_blue "3, bleu"
    SYnumber_3_green "3, vert"
    SYnumber_3_red "3, rouge"
    SYnumber_4_blue "4, bleu"
    SYnumber_4_green "4, vert"
    SYnumber_4_red "4, rouge"
    SYnumber_5_blue "5, bleu"
    SYnumber_5_green "5, vert"
    SYnumber_5_red "5, rouge"
    SYnumber_6_blue "6, bleu"
    SYnumber_6_green "6, vert"
    SYnumber_6_red "6, rouge"
    SYnumber_7_blue "7, bleu"
    SYnumber_7_green "7, vert"
    SYnumber_7_red "7, rouge"
    SYnumber_8_blue "8, bleu"
    SYnumber_8_green "8, vert"
    SYnumber_8_red "8, rouge"
    SYnumber_9_blue "9, bleu"
    SYnumber_9_green "9, vert"
    SYnumber_9_red "9, red"
    numberfrom0 "Mise  zro du compteur"
    items "Elments"
    syusrmenu "Menu des symboles spcifiques"
    cfgsymenu "Configuration du menu des symboles spcifiques"
    insmnb   "Insrer un sous-menu avant"
    insmna   "Insrer un sous-menu aprs"
    opensbmn "Ouvrir un sous-menu"
    clssbmn  "Fermer un sous-menu"
    duration "Dure"
    calrs "Calories"
    optSUPPORTLAPS "Support pour les tapes"
    LAP  ETP
    nameLAP "tape"
    lapsrun "Course"
    fromfile "depuis un fichier"
    fromdef "depuis une dfinition"
    mbaktoload "Fond de map  charger"
    none "aucun"
    opt_Fonts "Tailles des polices"
    optFONTSIZE "Taille de police dfaut"
    optFIXEDFONTSIZE "Taille de police fixe"
    optICONSIZE "Taille des symboles"
    optTRNUMBERINTVL "Intervalle pour information des points sur les traces"
    optTRINFO "Information sur point de trace"
    nameAL "Almanach"
    alm_svid "identification du satellite"
    alm_week "semaine"
    alm_datatime "temps de rfrence"
    alm_clockc1 "coefficient de correction de l'horloge s"
    alm_clockc2 "coefficient de correction de l'horloge s/s"
    alm_ecc "excentricit"
    alm_sqrta "racine carre de a"
    alm_mnanom "anomalie moyenne"
    alm_argprgee "argument du prige"
    alm_rightasc "ascension droite"
    alm_rtrightasc "taxe de ascension droite"
    alm_inclin "inclinaison"
    alm_health "sant"
    lstsqs "Moindres carrs"
    lstsqsfile "Fichier des moindres carrs"
    alt_cumul "Dnivell cumul positif"
    optSHOWFILEITEMS "Affichage par dfaut des donnes lues"
    totdstng   "Distance totale, sans les sauts"
    tottimeng  "Temps total, sans les sauts"
    SYcross "Croix"
    SYcross_3p "Croix 3p"
    mapfitWPs "Affichage des WPs d'ajustement sur la carte"
    showfitinfo "Affichage des informations d'ajustement"
    xtcoord "xt"
    ytcoord "yt"
    delta   "d"
    residual "rt"
    rmsxydev "moyenne quadratique ou rms(x,y-deviations)"
    resstderr "erreur standard residuelle"
    chgdev "Changement de priphrique"
    maxalt "Altitude maximum"
    minalt "Altitude minimum"
    alt_cumul "Montes cumules"
    alt_cumuld "Descentes cumules"
    optSHOWFILEITEMS "Par dfaut, affichage sur la carte des donnes lues"
    vertgridlines "Lignes verticales"
    convert  "Conversion"
    split    "Fragmentation"
    bysel  "par points choisis"
    byseg  "par segments"
    openits "Ouvrir %s"
}

    # the following definitions must be coherent with $TXT
array set INVTXT {
    DMS   DMS
    DMM   DMM
    DDD   DDD
    Grades   GRA
    UTM/UPS   UTM/UPS
    WP   WP
    RT   RT
    TR   TR
    ETP LAP
    GR   GR
}
