/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 c-style: "K&R" -*- */

/*----------------------------------------------------------------------
 
  gpiv - Graphic program for Particle Image Velocimetry, based on gtk/gnome
          libraries.

   Copyright (C) 2002, 2003, 2004 Gerber van der Graaf

   This file is part of gpiv.

   Gpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

----------------------------------------------------------------------*/

/*
 * Image header window/tabulator callbacks
 * $Log: imgh.c,v $
 * Revision 1.9  2006/01/31 14:28:12  gerber
 * version 0.3.0
 *
 * Revision 1.7  2005/02/26 09:43:30  gerber
 * parameter flags (parameter_logic) defined as gboolean
 *
 * Revision 1.6  2005/01/19 15:53:41  gerber
 * Initiation of Data Acquisition (DAC); trigerring of lasers and camera
 * by using RTAI and Realtime Linux, recording images from IEEE1394
 * (Firewire) IIDC compliant camera's
 *
 * Revision 1.5  2004/10/15 19:24:05  gerber
 * GPIV_ and Gpiv prefix to defines and structure names of libgpiv
 *
 * Revision 1.4  2004/06/14 21:19:23  gerber
 * Image depth up to 16 bits.
 * Improvement "single int" and "drag int" in Eval tab.
 * Viewer's pop-up menu.
 * Adaption for gpiv_matrix_* and gpiv_vector_*.
 * Resizing console.
 * See Changelog for further info.
 *
 * Revision 1.3  2003/09/01 11:17:15  gerber
 * improved monitoring of interrogation process
 *
 * Revision 1.2  2003/08/22 15:24:52  gerber
 * interactive spatial scaling
 *
 * Revision 1.1.1.1  2003/06/17 17:10:52  gerber
 * Imported gpiv
 *
 */


#include "gpiv_gui.h"
#include "imgh.h"

void
on_radiobutton_imgh_mouse_1_enter(GtkWidget * widget, 
                                  GtkWidget * entry
                                  )
/*-----------------------------------------------------------------------------
 */
{
    GpivConsole *gpiv = gtk_object_get_data(GTK_OBJECT(widget), "gpiv");
    gchar *msg = _("No action");
    gnome_appbar_set_status(GNOME_APPBAR(gpiv->appbar), msg);
}



void
on_radiobutton_imgh_mouse_2_enter(GtkWidget * widget, 
                                  GtkWidget * entry
                                  )
/*-----------------------------------------------------------------------------
 */
{
    GpivConsole *gpiv = gtk_object_get_data(GTK_OBJECT(widget), "gpiv");
    gchar *msg = _("Points the length spanned by a ruler in the image");
    gnome_appbar_set_status(GNOME_APPBAR(gpiv->appbar), msg);
}



void
on_radiobutton_imgh_mouse_3_enter(GtkWidget * widget, 
                                  GtkWidget * entry
                                  )
/*-----------------------------------------------------------------------------
 */
{
    GpivConsole *gpiv = gtk_object_get_data(GTK_OBJECT(widget), "gpiv");
    gchar *msg = _("Points the vertical length by a ruler in the image");
    gnome_appbar_set_status(GNOME_APPBAR(gpiv->appbar), msg);
}



void
on_radiobutton_imgh_mouse_4_enter(GtkWidget * widget, 
                                  GtkWidget * entry
                                  )
/*-----------------------------------------------------------------------------
 * Main program of gpiv
 */
{
    GpivConsole *gpiv = gtk_object_get_data(GTK_OBJECT(widget), "gpiv");
    gchar *msg = _("Points the horizontal length by a ruler in the image");
    gnome_appbar_set_status(GNOME_APPBAR(gpiv->appbar), msg);
}



void
on_radiobutton_imgh_mouse(GtkWidget * widget, 
                          GtkWidget * entry
                          )
/*-----------------------------------------------------------------------------
 */
{
    m_select = atoi(gtk_object_get_data(GTK_OBJECT(widget),
					"mouse_select"));

    if (m_select == NO_MS) {
	piv_eval_par.int_geo = GPIV_AOI;
    } else if (m_select == SPANLENGTH_MS) {
    } else if (m_select == V_SPANLENGTH_MS) {
    } else if (m_select == H_SPANLENGTH_MS) {
    } else {}

}



void
on_spinbutton_post_scale_px(GtkSpinButton * widget, 
                            GtkWidget * entry
                            )
/*-----------------------------------------------------------------------------
 */
{
    GpivConsole *gpiv = gtk_object_get_data(GTK_OBJECT(widget), "gpiv");

    gpiv_var.img_span_px = gtk_spin_button_get_value_as_float(widget);
    gnome_config_push_prefix("/gpiv/RuntimeVariables/");
    gnome_config_set_float("span", gpiv_var.img_span_px);
    gnome_config_pop_prefix();
    gnome_config_sync();

    image_par.s_scale = 
        gpiv_var.img_length_mm / gpiv_var.img_span_px;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON
                              (gpiv->imgh->spinbutton_sscale), 
                              image_par.s_scale);
}



void
on_spinbutton_post_scale_mm(GtkSpinButton * widget, 
                            GtkWidget * entry
                            )
/*-----------------------------------------------------------------------------
 */
{
    GpivConsole *gpiv = gtk_object_get_data(GTK_OBJECT(widget), "gpiv");

    gpiv_var.img_length_mm = gtk_spin_button_get_value_as_float(widget);
    gnome_config_set_float("length", gpiv_var.img_length_mm);
    gnome_config_sync();

    image_par.s_scale = 
        gpiv_var.img_length_mm / gpiv_var.img_span_px;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON
                              (gpiv->imgh->spinbutton_sscale), 
                              image_par.s_scale);
}

/*
 * Yeah, I switched from indentation style. Do you like it? Gerber
 */

void
on_entry_imgh_title(GtkSpinButton *widget, 
		      GtkWidget *entry
                      )
/*-----------------------------------------------------------------------------
 */
{
        Imgheader * imgh = gtk_object_get_data(GTK_OBJECT(widget), "imgh");

        g_snprintf(image_par.title, GPIV_MAX_CHARS, "%s", 
                   gtk_entry_get_text(GTK_ENTRY(imgh->entry_imgtitle)));
        image_par.title_logic = TRUE;
        
        if (display_act != NULL) {
                g_snprintf(display_act->img.image_par.title, GPIV_MAX_CHARS,
                           "%s", image_par.title);
            display_act->img.image_par.title_logic = TRUE;
        }
}


void
on_entry_imgh_crdate(GtkSpinButton *widget, 
                     GtkWidget *entry
                     )
/*-----------------------------------------------------------------------------
 */
{
        Imgheader * imgh = gtk_object_get_data(GTK_OBJECT(widget), "imgh");

        g_snprintf(image_par.creation_date, GPIV_MAX_CHARS, "%s",
                   gtk_entry_get_text(GTK_ENTRY(imgh->entry_crdate)));
        image_par.creation_date_logic = TRUE;
        
        if (display_act != NULL) {
                g_snprintf(display_act->img.image_par.creation_date, 
                           GPIV_MAX_CHARS,"%s", image_par.creation_date);
            display_act->img.image_par.creation_date_logic = TRUE;
        }
}


void
on_entry_imgh_location(GtkSpinButton *widget, 
                       GtkWidget *entry
                       )
/*-----------------------------------------------------------------------------
 */
{
        Imgheader * imgh = gtk_object_get_data(GTK_OBJECT(widget), "imgh");

        g_snprintf(image_par.location, GPIV_MAX_CHARS, "%s",
                   gtk_entry_get_text(GTK_ENTRY(imgh->entry_location)));
        image_par.location_logic = TRUE;
        
        if (display_act != NULL) {
                g_snprintf(display_act->img.image_par.location, 
                           GPIV_MAX_CHARS,"%s", image_par.location);
                display_act->img.image_par.location_logic = TRUE;
        }
}


void
on_entry_imgh_author(GtkSpinButton *widget, 
		      GtkWidget *entry
                      )
/*-----------------------------------------------------------------------------
 */
{
         Imgheader * imgh = gtk_object_get_data(GTK_OBJECT(widget), "imgh");

         g_snprintf(image_par.author, GPIV_MAX_CHARS, "%s",
                    gtk_entry_get_text(GTK_ENTRY(imgh->entry_author)));
         image_par.author_logic = TRUE;
         
         if (display_act != NULL) {
             g_snprintf(display_act->img.image_par.author, GPIV_MAX_CHARS, 
                        "%s", image_par.author);
             display_act->img.image_par.author_logic = TRUE;
         }
}


void
on_entry_imgh_software(GtkSpinButton *widget, 
		      GtkWidget *entry
                      )
/*-----------------------------------------------------------------------------
 */
{
        Imgheader * imgh = gtk_object_get_data(GTK_OBJECT(widget), "imgh");

        g_snprintf(image_par.software, GPIV_MAX_CHARS, "%s",
                   gtk_entry_get_text(GTK_ENTRY(imgh->entry_software)));
        image_par.software_logic = TRUE;
        
        if (display_act != NULL) {
            g_snprintf(display_act->img.image_par.software, GPIV_MAX_CHARS, 
                       "%s", image_par.software);
            display_act->img.image_par.software_logic = TRUE;
        }
}


void
on_entry_imgh_source(GtkSpinButton *widget, 
		      GtkWidget *entry
                      )
/*-----------------------------------------------------------------------------
 */
{
        Imgheader * imgh = gtk_object_get_data(GTK_OBJECT(widget), "imgh");

        g_snprintf(image_par.source, GPIV_MAX_CHARS, "%s",
                   gtk_entry_get_text(GTK_ENTRY(imgh->entry_source)));
        image_par.source_logic = TRUE;
        
        if (display_act != NULL) {
                g_snprintf(display_act->img.image_par.source, GPIV_MAX_CHARS, 
                           "%s", image_par.source);
                display_act->img.image_par.source_logic = TRUE;
        }
}


void
on_entry_imgh_usertext(GtkSpinButton *widget, 
		      GtkWidget *entry
                      )
/*-----------------------------------------------------------------------------
 */
{
        Imgheader * imgh = gtk_object_get_data(GTK_OBJECT(widget), "imgh");

        g_snprintf(image_par.usertext, GPIV_MAX_CHARS, "%s",
                   gtk_entry_get_text(GTK_ENTRY(imgh->entry_usertext)));
        image_par.usertext_logic = TRUE;
        
        if (display_act != NULL) {
                g_snprintf(display_act->img.image_par.usertext, 
                           GPIV_MAX_CHARS, "%s", image_par.usertext);
            display_act->img.image_par.usertext_logic = TRUE;
        }
}


void
on_entry_imgh_warning(GtkSpinButton *widget, 
		      GtkWidget *entry
                      )
/*-----------------------------------------------------------------------------
 */
{
        Imgheader * imgh = gtk_object_get_data(GTK_OBJECT(widget), "imgh");

        g_snprintf(image_par.warning, GPIV_MAX_CHARS, "%s",
                   gtk_entry_get_text(GTK_ENTRY(imgh->entry_warning)));
        image_par.warning_logic = TRUE;
        
        if (display_act != NULL) {
                g_snprintf(display_act->img.image_par.warning, 
                           GPIV_MAX_CHARS, "%s", image_par.warning);
            display_act->img.image_par.warning_logic = TRUE;
        }
}


void
on_entry_imgh_disclaimer(GtkSpinButton *widget, 
		      GtkWidget *entry
                      )
/*-----------------------------------------------------------------------------
 */
{
        Imgheader * imgh = gtk_object_get_data(GTK_OBJECT(widget), "imgh");

        g_snprintf(image_par.disclaimer, GPIV_MAX_CHARS, "%s",
                   gtk_entry_get_text(GTK_ENTRY(imgh->entry_disclaimer)));
        image_par.disclaimer_logic = TRUE;

        if (display_act != NULL) {
                g_snprintf(display_act->img.image_par.disclaimer, 
                           GPIV_MAX_CHARS, "%s", image_par.disclaimer);
                display_act->img.image_par.disclaimer_logic = TRUE;
        }
}


void
on_entry_imgh_comment(GtkSpinButton *widget, 
		      GtkWidget *entry
                      )
/*-----------------------------------------------------------------------------
 */
{
        Imgheader * imgh = gtk_object_get_data(GTK_OBJECT(widget), "imgh");

        g_snprintf(image_par.comment, GPIV_MAX_CHARS, "%s",
                   gtk_entry_get_text(GTK_ENTRY(imgh->entry_comment)));
        image_par.comment_logic = TRUE;
        
        if (display_act != NULL) {
                g_snprintf(display_act->img.image_par.comment, 
                           GPIV_MAX_CHARS, "%s", image_par.comment);
                display_act->img.image_par.comment_logic = TRUE;
        }
}


