# gozerbot/jabberbot.py
#
#

""" jabber bot definition """

__copyright__ = 'this file is in the public domain'
__revision__ = '$Id: bot.py 75 2005-09-12 16:33:00Z bart $'

from gozerbot.eventhandler import commandhandler
from gozerbot.users import users
from gozerbot.monitor import jabbermonitor
from gozerbot.wait import Jabberwait, Jabbererrorwait
from gozerbot.generic import rlog, handle_exception, lockdec, waitforqueue, \
todefenc, jabberstrip
from gozerbot.config import config
from gozerbot.plugins import plugins
from gozerbot.jabbermsg import Jabbermsg
from gozerbot.jabberpresence import Jabberpresence
from gozerbot.pdod import Pdod
from gozerbot.dol import Dol
from gozerbot.datadir import datadir
from gozerbot.channels import Channels
from gozerbot.less import Less
from gozerbot.ignore import shouldignore
from gozerbot.callbacks import jcallbacks
from gozerbot.thr import start_new_thread
from gozerbot.limlist import Limlist
from gozerbot.fleet import fleet
from gozerplugs.plugs.jcoll import jcheck
import xmpp, time, Queue, os, threading, thread

jabberoutlock = thread.allocate_lock()
jabberinlock = thread.allocate_lock()
outlocked = lockdec(jabberoutlock)
inlocked = lockdec(jabberinlock)

class Jabberbot(object):

    """ jabber bot class """

    def __init__(self, botname):
        self.name = botname
        self.type = 'jabber'
        self.host = None
        self.port = None
        self.user = None
        self.password = None
        self.sock = None
        self.jid = None
        self.nick = None
        self.username = None
        self.me = None
        self.server = None
        self.lastin = None
        self.starttime = time.time()
        self.owner = config['jabberowner']
        # see if owner already has a user account if not merge otherwise add
        name = users.getname(self.owner)
        if not name:
            merged = users.merge('owner', self.owner)
            if not merged:
                users.add('owner', [self.owner], perms = ['USER', 'OPER'])
        self.test = 0
        self.stopped = 0
        self.connecttime = 0
        self.connection = None
        self.channels = {}
        self.backlog = Limlist(1000)
        self.privwait = Jabberwait()
        self.errorwait = Jabbererrorwait()
        self.jabber = True
        self.connectok = threading.Event()
        self.less = Less(5)
        self.userhosts = {}
        self.jids = {}
        self.topics = {}
        self.userchannels = Dol()
        self.timejoined = {}
        self.state = Pdod(datadir + os.sep + '%s.state' % self.name)
        self.channels = Channels(datadir + os.sep + '%s.channels' % self.name)
        if not self.state.has_key('joinedchannels'):
            self.state['joinedchannels'] = []
        if not self.state.has_key('ratelimit'):
            self.state['ratelimit'] = 0

    def doprocess(self):
        """ process loop """
        while not self.stopped:
            try:
                time.sleep(0.1)
                res = self.connection.Process()
                if res:
                    self.lastin = time.time()
            except Exception, ex:
                if not self.stopped:
                    handle_exception()
                    time.sleep(2)
                else:
                    return

    def doconnect(self, host, user, password, port=5222):
        """ connect to server .. start read loop """
        self.host = host
        self.port = port
        self.user = user
        self.password = password
        if not '@' in user:
            rlog(100, self.name, 'user needs to be in username@host format')
            return
        self.username = user.split('@')[0]
        self.me = user
        self.jid = xmpp.JID(user)
        self.server = self.jid.getDomain()
        self.nick = self.username
        self.password = password
        rlog(10, self.name, 'connecting to %s' % self.host)
#        self.connection = xmpp.Client(self.server, debug=['always', 'nodebuilder'])
        self.connection = xmpp.Client(self.server, debug=[])
        try:
            self.connection.connect((self.host, self.port))
        except IOError:
            handle_exception()
            rlog(10, self.name, "can't connect to %s" % self.host)
            return
        rlog(10, self.name, 'doing auth')
        auth = self.connection.auth(self.username, self.password, 'gozerbot')
        if not auth:
            rlog(10, self.name, 'auth for %s failed .. trying register' \
% self.username)
            info = {'username': self.username, 'password': self.password}
            xmpp.features.getRegInfo(self.connection, self.host, info)
            if not xmpp.features.register(self.connection, self.host, info):
                rlog(100, self.name, "can't register")
                return
            else:
                self.connection = xmpp.Client(self.server, debug=[])
                try:
                    self.connection.connect((self.host, self.port))
                except:
                    handle_exception()
                    rlog(10, self.name, "can't connect to %s" % self.host)
                    return
                auth = self.connection.auth(self.username, self.password, \
'gozerbot')
                rlog(100, self.name, "register succeded")
        self.connecttime = time.time()
        rlog(100, self.name, 'connected! type: %s' % \
self.connection.connected)
        self.connection.RegisterHandler('message', self.messageHandler)
        self.connection.RegisterHandler('presence', self.presenceHandler)
        self.connection.RegisterHandler('iq', self.iqHandler)
        self.connection.UnregisterDisconnectHandler(\
self.connection.DisconnectHandler)
        self.connection.RegisterDisconnectHandler(self.disconnectHandler)
        self.connection.UnregisterHandlerOnce = self.UnregisterHandlerOnce
        self.stopped = False
        commandhandler.start()
        start_new_thread(self.doprocess, ())
        start_new_thread(self.keepalive, ())
        #start_new_thread(self.keepchannelsalive, ())
        self.connection.sendInitPresence()
        self.connection.getRoster()
        self.connectok.set()
        return 1

    def joinchannels(self):
        """ join channels """
        time.sleep(5)
        for i in self.state['joinedchannels']:
            key = self.channels.getkey(i)
            nick = self.channels.getnick(i)
            result = self.join(i, key, nick)
            if result == 1:
                rlog(10, self.name, 'joined %s' % i)
            else:
                rlog(10, self.name, 'failed to join %s: %s' % (i, result))

    def keepalive(self):
        """ keepalive method .. send empty string to self every 3 minutes """
        while 1:
            if self.stopped:
                break
            self.say(self.jid, "")
            time.sleep(180)

    def sendpresence(self, to):
        """ send presence """
        presence = xmpp.Presence(to=to)
        presence.setFrom(self.me)
        self.send(presence)

    def keepchannelsalive(self):
        """ channels keep alive method """
        while 1:
            time.sleep(600)
            if self.stopped:
                break
            for i in self.state['joinedchannels']:
                self.say(i, "")

    def iqHandler(self, conn, node):
        """ handle iq stanza's """
        rlog(2, self.name + '-Iq', str(node))
        node.cmnd = 'Iq'
        node.conn = conn
        jcallbacks.check(self, node)

    @inlocked
    def messageHandler(self, conn, msg):
        """ message handler """
        if self.test:
            return
        if 'jabber:x:delay' in str(msg):
            return
        m = Jabbermsg(msg)
        m.toirc(self)
        if m.groupchat and m.getSubject():
            self.topiccheck(m)
            return
        if self.privwait.check(m):
            return
        if not m.txt:
            return
        if self.me in m.userhost:
            return 0
        if m.groupchat and self.nick == m.resource:
            return 0
        go = 1
        try:
            cc = self.channels[m.channel]['cc']
        except (TypeError, KeyError):
            cc = config['defaultcc'] or '!'
        try:
            channick = self.channels[m.channel]['nick']
        except (TypeError, KeyError):
            channick = self.nick
        if m.groupchat and not m.txt[0] in cc:
            go = 0
        if m.txt.startswith("%s: " % channick):
            m.txt = m.txt.replace("%s: " % channick, "")
            go = 1
        elif m.txt.startswith("%s, " % channick):
            m.txt = m.txt.replace("%s, " % channick, "")
            go = 1
        if m.txt[0] in cc:
            m.txt = m.txt[1:]
        if go and not 'dojcoll' in str(m.id):
            try:
                plugins.trydispatch(self, m)
            except:
                handle_exception()
        jcallbacks.check(self, m)
        jcheck(self, m)
        self.backlog.append(m)

    def presenceHandler(self, conn, pres):
        """ overloaded presence handler """
        p = Jabberpresence(pres)
        p.toirc(self)
        frm = p.getFrom()
        nickk = ""
        nick = frm.getResource()
        if nick:
            self.userhosts[nick] = str(frm)
            nickk = nick
        jid = None
        for i in p.getPayload():
            if i.getName() == 'x':
                for j in i.getPayload():
                    if j.getName() == 'item':
                        attrs = j.getAttrs()
                        if attrs.has_key('jid'):
                            jid = xmpp.JID(attrs['jid'])
        if nickk and jid:
            channel = frm.getStripped()
            if not self.jids.has_key(channel):
                self.jids[channel] = {}
            self.jids[channel][nickk] = jid
            self.userhosts[nickk.lower()] = str(jid)
            rlog(10, 'jabberbot', 'setting jid of %s (%s) to %s' % (nickk, \
 channel, jid))
        if p.type == 'subscribe':
            fromm = p.getFrom()
            self.send(xmpp.Presence(to=fromm, typ='subscribed'))
            self.send(xmpp.Presence(to=fromm, typ='subscribe'))
        nick = p.resource
        if p.type != 'unavailable':
            self.userchannels.adduniq(nick, p.channel)
            p.joined = True
        elif self.me in p.userhost:
            try:
                del self.jids[p.channel]
                rlog(10, 'jabberbot', 'removed %s channel jids' % p.channel)
            except KeyError:
                pass
        else:
            try:
                del self.jids[p.channel][p.nick]
                rlog(10, 'jabberbot', 'removed %s jid' % p.nick)
            except KeyError:
                pass
        p.conn = conn
        jcallbacks.check(self, p)
        self.errorwait.check(p)

    def disconnectHandler(self):
        """ overloaded disconnect handler """
        rlog(100, self.name, "disconnected")
        if not self.stopped:
            self.stopped = True
            time.sleep(90)
            rlog(100, self.name, 'reconnecting')
            newbot = Jabberbot(self.name)
            if newbot.doconnect(self.host, self.user, self.password, \
self.port):
                newbot.joinchannels()
            fleet.replace(self.name, newbot)

    @outlocked
    def send(self, what):
        """ send via jabber.Client and check for output monitor """
        if self.stopped:
            rlog(10, self.name, 'bot is stopped')
            return
        try:
            time.sleep(self.state['ratelimit'])
            rlog(2, '%s-send' % self.name, str(what))
            if self.connection.isConnected():
                self.connection.send(what)
            jabbermonitor.callcb(self.name, what)
        except:
            handle_exception()

    @outlocked
    def sendnocb(self, what):
        """ send via jabber.Client and check for output monitor """
        if self.stopped:
            return
        try:
            time.sleep(self.state['ratelimit'])
            if self.connection.isConnected():
                self.connection.send(what)
            rlog(2, '%s-send' % self.name, str(what))
        except:
            handle_exception()

    def action(self, printto, txt, groupchat=True):
        """ action txt to printto """
        txt = "/me " + txt
        txt = todefenc(jabberstrip(txt))
        if printto in self.state['joinedchannels'] and groupchat:
            message = xmpp.Message(to=printto, body=txt, typ='groupchat')
        else:
            message = xmpp.Message(to=printto, body=txt)
        self.send(message)
        
    def say(self, printto, txt, fromm=None, groupchat=True):
        """ say txt to printto """
        txt = todefenc(jabberstrip(txt))
        if printto in self.state['joinedchannels'] and groupchat:
            message = xmpp.Message(to=printto, body=txt, typ='groupchat')
        else:
            message = xmpp.Message(to=printto, body=txt, typ='chat')
        self.send(message)

    def saynocb(self, printto, txt, fromm=None, groupchat=True):
        """ say txt to printto """
        txt = todefenc(jabberstrip(txt))
        if printto in self.state['joinedchannels'] and groupchat:
            message = xmpp.Message(to=printto, body=txt, typ='groupchat')
        else:
            message = xmpp.Message(to=printto, body=txt, typ='chat')
        self.sendnocb(message)

    def wait(self, msg, txt):
        """ wait for user response """
        msg.reply(txt)
        queue = Queue.Queue()
        self.privwait.register(msg, queue)
        result = queue.get()
        if result:
            return result.getBody()

    def save(self):
        """ save bot's state """
        self.state.save()

    def quit(self):
        """ send unavailable presence """
        presence = xmpp.Presence()
        presence.setFrom(self.me)
        presence.setType('unavailable')
        for i in self.state['joinedchannels']:
            presence.setTo(i)
            self.send(presence)
        time.sleep(3)
        presence = xmpp.Presence()
        presence.setType('unavailable')
        self.send(presence)

    def exit(self):
        """ exit the bot """
        self.quit()
        time.sleep(2)
        self.stopped = True
        self.save()
        rlog(10, self.name, 'exit')

    def join(self, channel, password=None, nick=None):
        """ join conference """
        try:
            if not nick:
                nick = channel.split('/')[1]
        except IndexError:
            nick = self.nick
        channel = channel.split('/')[0]
        if not self.channels.has_key(channel):
            # init channel data
            self.channels.setdefault(channel, {})
        # setup error wait
        q = Queue.Queue()
        self.errorwait.register("409", q, 3)
        # do the actual join
        presence = xmpp.Presence(to=channel + '/' + nick)
        presence.setFrom(self.me)
        self.send(presence)
        errorobj = waitforqueue(q, 3)
        if errorobj:
            err = errorobj[0].error
            rlog(10, self.name, 'error joining %s: %s' % (channel, err))
            return err
        self.timejoined[channel] = time.time()
        chan = self.channels[channel]
        # if password is provided set it
        chan['nick'] = nick
        if password:
            chan['key'] = password
        # check for control char .. if its not there init to !
        if not chan.has_key('cc'):
            chan['cc'] = config['defaultcc'] or '!'
        if not chan.has_key('perms'):
            chan['perms'] = []
        self.channels.save()
        if channel not in self.state['joinedchannels']:
            self.state['joinedchannels'].append(channel)
        self.state.save()
        return 1

    def part(self, channel):
        """ leace conference """
        presence = xmpp.Presence(to=channel)
        presence.setFrom(self.jid)
        presence.setType('unavailable')
        self.send(presence)
        if channel in self.state['joinedchannels']:
            self.state['joinedchannels'].remove(channel)
        self.state.save()
        return 1

    def outputnolog(self, printto, what, how, who=None, fromm=None):
        """ doe output but don't log it """
        if fromm and shouldignore(fromm):
            return
        self.saynocb(printto, what)

    def topiccheck(self, msg):
        """ chek if topic is set """
        if msg.groupchat:
            try:
                topic = msg.getSubject()
                if not topic:
                    return None
                self.topics[msg.channel] = (topic, msg.userhost, time.time())
                rlog(10, self.name, 'topic of %s set to %s' % \
(msg.channel, topic))
            except AttributeError:
                return None

    def settopic(self, channel, txt):
        """ set topic """
        pres = xmpp.Message(to=channel, subject=txt)
        pres.setType('groupchat')
        self.send(pres)

    def gettopic(self, channel):
        """ get topic """
        try:
            topic = self.topics[channel]
            return topic
        except KeyError:
            return None

    def UnregisterHandlerOnce(self, a, b, xmlns=None):
        """ hack to work around missing method """
        print a, b
