/* gLife - An Artificial Life implementation using GNOME
 *
 * Copyright (C) 1999 Ali Abdin <aliabdin@aucegypt.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include "config.h"

#include <gnome.h>
#include <glade/glade.h>
#include <unistd.h>
#include <stdlib.h>
#include <libart_lgpl/art_rgb.h>


#include "glife.h"
#include "simulation.h"
#include "data.h"
#include "drawing.h"
#include "feedback.h"
#include "conf.h"

/* libglade callbacks */
void restart_cb (void);
void about_cb (void);
void exit_cb (void);
void end_cb (void);
void glifedocu_cb (void);
void start_simulation(GtkWidget *, gpointer); /* Found in simulation.c */
static void on_continue (GtkWidget *, gpointer);
static void on_pause (GtkWidget *, gpointer);
static void load_ui();

LifeData glife;
guint32 malecolor;
guint32 femalecolor;
guint32 terrcolor;


void
end_cb() {
	if (glife.timeout_on == FALSE) { 
		GtkWidget *w;
	
		gtk_timeout_remove (glife.timeoutid);
			
		erase_animals();
		init_terrain_data();
		render();
		w = glade_xml_get_widget (glife.xml, "pausebutton");
		gtk_widget_set_sensitive (w, FALSE);
		w = glade_xml_get_widget (glife.xml, "contbutton");
		gtk_widget_set_sensitive (w, FALSE);
		w = glade_xml_get_widget (glife.xml, "end_menu");
		gtk_widget_set_sensitive (w, FALSE);
		w = glade_xml_get_widget (glife.xml, "start_menu");
		gtk_widget_set_sensitive (w, TRUE);
		glife_log (_("Ending Simulation\n"));
		w = GTK_WIDGET(glade_xml_get_widget (glife.xml, "drawingarea"));
		gtk_widget_draw (w, NULL);
	} 
#if 1
	else {
		gchar *s;
		GtkWidget *w;

		s = g_strdup_printf (_("Please re-try after the animals have finished moving"));
		w = gnome_error_dialog (s);
		gnome_dialog_run_and_close (GNOME_DIALOG (w));
		g_free (s);
	}
#endif
}

void restart_cb () {
	if (glife.timeout_on == FALSE) {
		GtkWidget *w;
	
		gtk_timeout_remove (glife.timeoutid);
			
		erase_animals();
		init_terrain_data();
		render();
		w = glade_xml_get_widget (glife.xml, "pausebutton");
		gtk_widget_set_sensitive (w, FALSE);
		w = glade_xml_get_widget (glife.xml, "contbutton");
		gtk_widget_set_sensitive (w, FALSE);
		w = glade_xml_get_widget (glife.xml, "end_menu");
		gtk_widget_set_sensitive (w, FALSE);
		w = glade_xml_get_widget (glife.xml, "restart_menu");
		gtk_widget_set_sensitive (w, FALSE);
		w = glade_xml_get_widget (glife.xml, "start_menu");
		glife_log (_("Restarting Simulation\n"));
		start_simulation (w, NULL);
	}
	else {
		gchar *s;
		GtkWidget *w;

		s = g_strdup_printf (_("Please re-try after the animals have finished moving"));
		w = gnome_error_dialog (s);
		gnome_dialog_run_and_close (GNOME_DIALOG (w));
		g_free (s);

	}

}

void
exit_cb() {
	gtk_main_quit();
}


void
glifedocu_cb() {
	gchar *helpfile;

	helpfile = gnome_help_file_find_file ("glife", "index.html");

	if (helpfile != NULL) {
		gchar *url;

		url = g_strconcat ("ghelp:", helpfile, NULL);

		gnome_help_goto (NULL, url);

		g_free (url);
		g_free (helpfile);
	}
	else
		gnome_error_dialog (_("Could not find gLife manual!"));
}

void
about_cb() {
	GladeXML *xml;
	gchar *xml_path;
	GtkWidget *my_url;
	GtkWidget *w;

	xml_path = g_strdup (GLIFE_DATADIR "/glife.glade");
	if (!g_file_exists (xml_path)) {
                char *env = getenv ("PWD");
		g_free (xml_path);
                xml_path = g_strconcat (env,
                                        "/glife.glade",
                                        NULL);
	}

	my_url = gnome_href_new ("http://glife.sourceforge.net",
				 _("Visit gLife's website"));
	gtk_widget_show (GTK_WIDGET(my_url));

	xml = glade_xml_new (xml_path, "about1");

	w = glade_xml_get_widget (xml, "about1");
	gtk_box_pack_start (GTK_BOX ((GNOME_DIALOG (w))->vbox),
		            GTK_WIDGET(my_url),
			    FALSE, FALSE, 0);

	gtk_widget_show (w);

	g_free (xml_path);
	gtk_object_destroy (GTK_OBJECT (xml));	
}

static void
on_continue (GtkWidget *widget, gpointer data) {
	GtkWidget *w;

	w = glade_xml_get_widget (glife.xml, "pausebutton");
	gtk_widget_set_sensitive (GTK_WIDGET (w), TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (widget), FALSE);
	w = glade_xml_get_widget (glife.xml, "end_menu");
	gtk_widget_set_sensitive (w, TRUE);
	w = glade_xml_get_widget (glife.xml, "restart_menu");
	gtk_widget_set_sensitive (w, FALSE);
	
	glife.timeoutid = gtk_timeout_add (ruleset.timeout, do_update, widget);
}

static void
on_pause (GtkWidget *widget, gpointer data) {
	GtkWidget *w;

	gtk_timeout_remove (glife.timeoutid);
	gtk_widget_set_sensitive (GTK_WIDGET (widget), FALSE);
	w = glade_xml_get_widget (glife.xml, "contbutton");
	gtk_widget_set_sensitive (GTK_WIDGET (w), TRUE);
	w = glade_xml_get_widget (glife.xml, "end_menu");
	gtk_widget_set_sensitive (w, TRUE);
	w = glade_xml_get_widget (glife.xml, "restart_menu");
	gtk_widget_set_sensitive (w, TRUE);			
}


static void
load_ui() {
	GtkWidget *w;
	
       	/* Make Terrain opaque yellow by default */
	terrcolor = GNOME_CANVAS_COLOR_A (255, 255, 0, 255);
	
	/* Make males transparent blue */
	malecolor = GNOME_CANVAS_COLOR_A (0, 0, 255, 175);

	/* Make females transparent red */
	femalecolor = GNOME_CANVAS_COLOR_A (255, 0, 0, 175);

	init_terrain_data();/* */

	render(); /* Render before expose */

	w = glade_xml_get_widget (glife.xml, "drawingarea");
	gtk_signal_connect (GTK_OBJECT (w), "expose-event",
			    GTK_SIGNAL_FUNC (on_darea_expose),
			    drawbuf);

	w = glade_xml_get_widget (glife.xml, "terrinfo");
	gtk_signal_connect (GTK_OBJECT (w), "clicked",
			    GTK_SIGNAL_FUNC (terrinfo_cb),
			    NULL);

	w = glade_xml_get_widget (glife.xml, "animinfo");
	gtk_signal_connect (GTK_OBJECT (w), "clicked",
			    GTK_SIGNAL_FUNC (animinfo_cb),
			    NULL);


	w = glade_xml_get_widget (glife.xml, "contbutton");
	gtk_signal_connect (GTK_OBJECT (w), "clicked",
	                    GTK_SIGNAL_FUNC (on_continue),
                            NULL);
	
	w = glade_xml_get_widget (glife.xml, "pausebutton");
	gtk_signal_connect (GTK_OBJECT (w), "clicked",
			    GTK_SIGNAL_FUNC (on_pause), NULL);

	w = glade_xml_get_widget (glife.xml, "end_menu");
	gtk_widget_set_sensitive (w, FALSE);

	w = glade_xml_get_widget (glife.xml, "restart_menu");
	gtk_widget_set_sensitive (w, FALSE); 
	
	glade_xml_signal_autoconnect (glife.xml);
}

int
main(int argc, char **argv)
{
	gchar *s = NULL;
	gchar *xml_path;
	GtkWidget *w;
	
	srand (time (NULL) + getpid());
	srand48 (time (NULL) + getpid()); /* Do it just in case we decide to use lrand48 */
	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);
	
	gnome_init (PACKAGE, VERSION, argc, argv);
	glade_gnome_init();
	gdk_rgb_init();
	
	gtk_widget_push_visual (gdk_rgb_get_visual());
	gtk_widget_push_colormap (gdk_rgb_get_cmap());

	/* Fill rgb buffer with white */
	art_rgb_fill_run ((art_u8 *)drawbuf, 255, 255, 255, width*height);
	  

	xml_path = g_strdup (GLIFE_DATADIR "/glife.glade");
	if (!g_file_exists (xml_path)) {
		char *env = getenv ("PWD");
		g_free (xml_path);
		xml_path = g_strconcat (env,
				        "/glife.glade",
					NULL);
		if (!g_file_exists (xml_path)) {
			s = g_strdup(_("Could not find the glade file\n"));
			w = gnome_error_dialog(s);
			gnome_dialog_run_and_close (GNOME_DIALOG (w));
			return 0;
		}
	}
	
	glife.xml = glade_xml_new (xml_path, "app");
	if (!glife.xml) {
		s = g_strdup_printf (_("Could not load XML file '%s'"),
				     xml_path);
		w = gnome_error_dialog (s);
		gnome_dialog_run_and_close (GNOME_DIALOG (w));
		return 0;
	}

	g_free (xml_path);
	
	load_options();
	load_ui();
	gtk_widget_pop_visual();
	gtk_widget_pop_colormap();
	
	gtk_main();
	
	return 0;
}
