%define nam	gLife
%define ver	0.2.1
%define rel	1

%define prefix		/usr
%define sysconfdir	/etc

Summary:	Artificial life implementation using GNOME
Name:		%nam
Version:	%ver
Release:	%rel
Copyright:	GPL
Group:		Amusements/Games
Source:		http://download.sourceforge.net/glife/%{nam}-%{ver}.tar.gz
URL:		http://glife.sourceforge.net/
BuildRoot:	/var/tmp/%{nam}-%{ver}-root
Docdir:		%{prefix}/doc

Requires: 	gnome-libs >= 1.0.0
Requires:	libglade >= 0.11

%description
gLife embodies the concepts found in artificial life and cellular automata (subsets of artificial intelligence), with a bias towards creating an artificial society. It provides a limited set of rules, towards the goal of making some sort of society emerge.

%changelog

* Mon Feb 21 2000  Julian Missig  <julian@linuxpower.org>

- First version of the spec file. It seems to work.

%prep
%setup -q

%build
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh	\
	--prefix=%{prefix} --sysconfdir=%{sysconfdir}
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure	\
	--prefix=%{prefix} --sysconfdir=%{sysconfdir}
fi

make

%install
rm -rf $RPM_BUILD_ROOT
make install \
	prefix=$RPM_BUILD_ROOT%{prefix} \
	sysconfdir=$RPM_BUILD_ROOT%{sysconfdir}

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog INSTALL NEWS README FAQ BUGS
%{prefix}/bin/*
%{prefix}/share/gnome/apps/*
%{prefix}/share/glife/*
%{prefix}/share/gnome/help/glife/*
#if we ever get translations - %{prefix}/share/locale/*/*/*
%{prefix}/share/locale/*/*/*
