// $Id: unknown.cc,v 1.6 2002/05/14 08:25:45 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "widget.hh"

class UnknownWidget : public Gtk_Widget
{public:
	typedef Gtk_Widget Parent;
	virtual const std::string TypeName(const Widget &w) const
	{  return GtkPrefix()+"Label"; }
	virtual const std::string IncludeName(const Widget &w) const
	{  return Configuration.GtkmmIncludePath()+"label.h"; }
	UnknownWidget();
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg() << Configuration.CString_WithQuotes(w.Class()+" "+w.Name()); }
#if 0	
	// treat like a placeholder
	virtual void GHDeclaration(const Widget &w, CxxFile &f) const
	{}
#endif	
#if 0	
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
#endif
};

static UnknownWidget UnknownWidget;

UnknownWidget::UnknownWidget()
{  Writer[""]=this;
}
