// $Id: gnome_calculator.cc,v 1.3 2002/11/04 11:31:03 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2001  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "box.hh"

class Gnome_Calculator : public Gtk_VBox
{public:
	typedef Gtk_VBox Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_Calculator();
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
};

static Gnome_Calculator Gnome_Calculator;

const std::string Gnome_Calculator::TypeName(const Widget &w) const
{  return GnomeUIPrefix()+"Calculator";
}

const std::string Gnome_Calculator::IncludeName(const Widget &w) const
{  return Configuration.GnomeUImmIncludePath()+"calculator.h";
}

Gnome_Calculator::Gnome_Calculator()
{  Writer["GnomeCalculator"]=this;
}

