// $Id: entry.cc,v 1.29 2003/04/24 08:20:41 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "entry.hh"

static Gtk_Entry Gtk_Entry(false);

const std::string Gtk_Entry::TypeName(const Widget &w) const
{  return GtkPrefix()+"Entry";
}

const std::string Gtk_Entry::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"entry.h";
}

Gtk_Entry::Gtk_Entry(bool base_class_init)
{  if (!base_class_init) Writer["GtkEntry"]=this;
}

void Gtk_Entry::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteIntProperty(w,f,instance, "position");
   WriteBoolProperty(w,f,instance, "text_visible", false, "visibility");
   WriteBoolProperty(w,f,instance, "visibility");
   WriteBoolProperty(w,f,instance, "editable");
   WriteIntProperty(w,f,instance, "max_length");
   WriteTranslatableProperty(w,f,instance, "text");
   WriteBoolProperty(w,f,instance, "has_frame");
   // invisible_char is really difficult, we have to convert an UTF-8
   // string to a gunichar, perhaps I do it later
   WriteBoolProperty(w,f,instance, "activates_default");
   WriteIntProperty(w,f,instance, "width_chars");
}

bool Gtk_Entry::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  const char prefix[]="gtk_entry_";
   const int plen(sizeof(prefix)-1);
   if (method.substr(0,plen)==prefix) method=method.substr(plen);
   if (((method=="set_text" || method=="set") && matches("const std::string &\\_",args))
	|| (method=="append_text" && matches("const std::string &\\_",args))
	|| (method=="prepend_text" && matches("const std::string &\\_",args))
	|| (method=="set_position" && (matches("int\\ \\_",args) || matches("gint\\ \\_",args)))
	|| (method=="set_max_length" && (matches("int\\ \\_",args) || matches("gint\\ \\_",args)))
	|| (method=="set_visibility" && matches("bool\\ \\_",args)))
   {  scope=Gtk_Entry::TypeName(w);
      is_signal=false;
      return true;
   }
   return Parent::isInternalMethod(w,method,args,scope,is_signal);
}

