// $Id: combo.cc,v 1.42 2003/03/05 09:33:34 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "combo.hh"
#include "../strsep.h"

static Gtk_Combo Gtk_Combo(false);

const std::string Gtk_Combo::TypeName(const Widget &w) const
{  return GtkPrefix()+"Combo";
}

const std::string Gtk_Combo::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"combo.h";
}

Gtk_Combo::Gtk_Combo(bool base_class_init)
{  if (!base_class_init) Writer["GtkCombo"]=this;
}

void Gtk_Combo::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   // work around gtk bug (see gbwidget.c:3584)
   // "GTK BUG WORKAROUND - a combo should manage the size of its entry."
   if (GTKMM1) WriteIntIntProperty(w,f,instance+"get_entry()->", "width", "height", "usize");

   WriteBoolProperty(w,f,instance, "case_sensitive");
   WriteBoolProperty(w,f,instance, "use_arrows");
   WriteBoolProperty(w,f,instance, "use_arrows_always");
   
   if (Configuration.glade2)
   {  Widget::const_iterator i=w.begin();
      for (;i!=w.end() && (*i).ChildName()!="list"; ++i);
      if (i!=w.end() && ((*i).begin() != (*i).end()))
      {  f.StartBlock().Declaration() << "const char * const items[]";
         f.Assignment() << "{ ";
         for (Widget::const_iterator j=(*i).begin();j!=(*i).end();++j)
         {  assert((*j).Class()=="GtkListItem");
            f << Configuration.static_Translatable((*j).getProperty("label")) 
              << ", ";
         }
         f << "0 }";
         f.Statement() << instance << "set_popdown_strings(items)";
         f.EndBlock();
      }
   }
   // items   
   else if (w.hasProperty("items")) // append them
   {  const std::string items(w.getProperty("items","<none>\n"));
      const std::string name(Configuration.InstanceName(w.Name()));
#ifdef __MINGW32__
      char buffer[items.size()+1];
#else      
      char *buffer=(char*)alloca(items.size()+1);
#endif      
      memcpy(buffer,items.c_str(),items.size()+1);
      char *token,*stringp=buffer;
      f.StartBlock().Declaration() << "const char * const items[]";
      f.Assignment() << "{ ";
      if ((token=strsep(&stringp,"\n")))
      {  f << Configuration.static_Translatable(token) << ", ";
      }
      while (stringp && (token=strsep(&stringp,"\n")))
      {  if (!stringp && !token[0]) // do not use the last empty string
            break;
         f << Configuration.static_Translatable(token) << ", ";
      }
      f << "0 }";
      // hmmm can we translate this?
      f.Statement() << instance << "set_popdown_strings(items)";
      f.EndBlock();
   }
   // now set the entry's text again (was lost by setting the popdown strings)
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).ChildName()=="GtkCombo:entry" || (*i).ChildName()=="entry")
         WriteTranslatableProperty((*i),f,instance+"get_entry()->", "text");
   }
}

Subwidget Gtk_Combo::IsSubwidget(const Widget &w,const Widget &ch) const
{  std::string cn=ch.ChildName();
   if (cn=="GtkCombo:entry" || cn=="entry" || cn=="list") return is_Subwidget_all;
   return not_Subwidget;
}

const std::string Gtk_Combo::InternalInstance(const Widget &parent,const Widget &w2) const
{  std::string cn=w2.ChildName();
   if (cn=="GtkCombo:entry" || cn=="entry") return "get_entry()->";
   if (GTKMM1 && cn=="list") return "get_list()->";
   return Parent::InternalInstance(parent,w2);
}
