// $Id: bonobo_dock.cc,v 1.4 2002/11/18 11:46:09 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Bonobo_Dock : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Bonobo_Dock();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual void AddChild(const Widget &w,CxxFile &f,const std::string &instance) const;
};

static Bonobo_Dock Bonobo_Dock;

const std::string Bonobo_Dock::TypeName(const Widget &w) const
{  return BonoboUIPrefix()+"Dock";
}

const std::string Bonobo_Dock::IncludeName(const Widget &w) const
{  if (Configuration.libbonobomm_version >= Pkg_Version(1,3,0))
      return Configuration.BonobommIncludePath()+"widgets/dock.h";
   return "bonobo/bonobo-dock.h";
}

Bonobo_Dock::Bonobo_Dock()
{  Writer["BonoboDock"]=this;
}

void Bonobo_Dock::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   bool allow_floating(w.getBoolProperty("allow_floating"));
   f.Statement() << instance << "allow_floating_items(" << PRINT_BOOL(allow_floating) << ')';
   
}

void Bonobo_Dock::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{  // const ChildParamList ch=w.get_Child_params();
   
   if (w.ChildName()=="BonoboDock:contents")
   {  f.Statement() << instance << "set_client_area("
   		<< Reference(w) << ')';
   }
   else
   {  std::string placement(w.getProperty("placement","BONOBO_DOCK_TOP"));
      int pos;
      if (GNOME2) {
	while ((pos = placement.find("BONOBO_DOCK_")) != std::string::npos) {
	  placement.replace(pos, strlen("BONOBO_DOCK_"), "Gnome::Bonobo::DOCK_");
	}
      }
      // TODO: Why are we hard-coding to DOCK_TOP??
      // std::string _placement(w.getProperty("placement"));
      int band(w.getIntProperty("band",0));
      int position(w.getIntProperty("position",0));
      int offset(w.getIntProperty("offset",0));
      bool in_new_band(w.getBoolProperty("in_new_band"));
      f.Statement() << instance << "add_item(" << Reference(w)
   	<< ", " << placement << ", " << band << ", " << position << ", "
   	<< offset << ", " << PRINT_BOOL(in_new_band) << ')';
   // add_floating_item (w,x,y,GtkOrientation orientation)
// #warning floating support missing ???
   }
}

