.\" @(#)$RCSfile: gfal_unlink.man,v $ $Revision: 1.1.1.1 $ $Date: 2003/11/19 12:56:29 $ CERN Jean-Philippe Baud
.\" Copyright (C) 2003 by CERN
.\" All rights reserved
.\"
.TH GFAL_UNLINK 3 "$Date: 2003/11/19 12:56:29 $" GFAL "Library Functions"
.SH NAME
gfal_unlink \- remove a file entry
.SH SYNOPSIS
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_unlink (const char *" filename ");"
.SH DESCRIPTION
.B gfal_unlink
removes a file entry.
.TP
.I filename
specifies the file name (this can only be a TURL in the current implementation).
.SH RETURN VALUE
This routine returns 0 if the operation was successful or -1 if the operation
failed. In the latter case,
.B errno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B ENOENT
The named file does not exist.
.TP
.B EACCES
Search permission is denied on a component of the
.I filename
prefix or write permission on the parent directory is denied.
.TP
.B EFAULT
.I filename
is a NULL pointer.
.TP
.B ENOTDIR
A component of
.I filename
prefix is not a directory.
.TP
.B EINVAL
.I filename
has an invalid syntax.
.TP
.B ECOMM
Communication error.
.TP
.B EPROTONOSUPPORT
Access method not supported.
.SH SEE ALSO
.B gfal(3)
