%define name gaby
%define version 2.0.2
%define release 1
%define prefix /usr
%define builddir $RPM_BUILD_DIR/%{name}-%{version}

Summary: Gaby is a small personal databases manager. 
Name: %{name}
Version: %{version}
Release: %{release}
Group: X11/Gnome/Applications/Databases
Copyright: GPL
Url: http://gaby.sourceforge.net
Packager: Frederic Peters <fpeters@tiscalinet.be>
Distribution: N/A 
Source: %{name}-%{version}.tar.gz
Buildroot: /var/tmp/%{name}-%{version}-%{release}-root

%description
Gaby is a small personal databases manager using GTK+ and Gnome (if available) 
for its GUI. It was designed to provide straight-forward access to databases a
'normal' user would like (addresses, books, ...) while keeping the ability to 
easily create databases for other needs. On a technical side it was designed 
with extensibility in mind and relies a lot on plug-ins. 

%prep
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix} --sysconfdir=/etc --mandir=%{prefix}/share/man --infodir=%{prefix}/share/info --disable-static
make

%install
make install prefix=$RPM_BUILD_ROOT%{prefix} \
			sysconfdir=$RPM_BUILD_ROOT/etc \
			mandir=$RPM_BUILD_ROOT%{prefix}/share/man \
			infodir=$RPM_BUILD_ROOT%{prefix}/share/info \
			SKIPGNOMEDATA=1
strip $RPM_BUILD_ROOT%{prefix}/bin/* && true
find $RPM_BUILD_ROOT%{prefix} -name *.a -exec rm {} \;
find $RPM_BUILD_ROOT%{prefix} -name *.la -exec chmod -x {} \;
find $RPM_BUILD_ROOT%{prefix} -name *.so -exec chmod -x {} \;
find $RPM_BUILD_ROOT%{prefix} -name *.so -exec strip {} \;
(
  BASEDIR=$RPM_BUILD_ROOT
  GNOMEDATADIR=$BASEDIR/`gnome-config --datadir`
  REALDOCDIR=%{prefix}/share/doc/gaby-%{version}
  DOCDIR=$BASEDIR/$REALDOCDIR
  install -d $GNOMEDATADIR/pixmaps
  cp -f gnome-gaby*.png $GNOMEDATADIR/pixmaps
  install -d $GNOMEDATADIR/gnome/apps/Applications
  cp -f *.desktop $GNOMEDATADIR/gnome/apps/Applications
  install -d $GNOMEDATADIR/gnome/help/gaby
  install -d $DOCDIR
  cp -f AUTHORS BUGS COPYING ChangeLog INSTALL NEWS README gaby.lsm $DOCDIR/
  mv $BASEDIR%{prefix}/share/doc/gaby/* $BASEDIR/usr/share/doc/gaby-%{version}/
  rm -rf $BASEDIR/usr/share/doc/gaby
  # TODO: shouldn't have to tell which languages to install...
  ln -sf $REALDOCDIR/C $GNOMEDATADIR/gnome/help/gaby/C
  ln -sf $REALDOCDIR/en $GNOMEDATADIR/gnome/help/gaby/en
  ln -sf $REALDOCDIR/fr $GNOMEDATADIR/gnome/help/gaby/fr
  rm -f $BASEDIR%{prefix}/bin/gcd	$BASEDIR%{prefix}/bin/videobase \
	$BASEDIR%{prefix}/bin/gnomecard $BASEDIR%{prefix}/bin/appindex
  ln -s gaby $BASEDIR%{prefix}/bin/gaby-gcd
  ln -s gaby $BASEDIR%{prefix}/bin/gaby-videobase
  rm -f $BASEDIR/etc/gaby/desc.gabysql
)

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%attr(755,root,root) %{prefix}/bin/gaby 
%attr(755,root,root) %{prefix}/bin/gabyprint 
%attr(755,root,root) %{prefix}/bin/gabyscript
%attr(755,root,root) %{prefix}/bin/gabybuilder
%attr(755,root,root) %{prefix}/bin/gnomecard-gaby
%{prefix}/lib/gaby/
%{prefix}/share/
%dir /etc/gaby/
%config /etc/gaby/desc.appindex
%config /etc/gaby/desc.gaby
%config /etc/gaby/desc.gaby-cgi
%config /etc/gaby/desc.gabyglade
%config /etc/gaby/desc.gbc
%config /etc/gaby/desc.gcd
%config /etc/gaby/desc.gnomecard
%config /etc/gaby/desc.gtest
%config /etc/gaby/desc.videobase

