/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: instDialog.h,v 1.35 2007/05/11 02:14:30 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __INSTDIALOG_H_
#define __INSTDIALOG_H_


#include "../../config.h"

#include "instdialog_q.h"
#include "instConf.h"

#include <instoptionsdialog_q.h>

#include <qstring.h>
#include <qstringlist.h>
#include <qprocess.h>

#include <fstream>
#include <set>
#include <map>
#include <list>

class QEventLoop;
class SSHSession;
class QTextEdit;
class QListViewItem;
class QCheckListItem;
class QButton;
class QProgressBar;
class QStringList;
class QCheckTableItem;

namespace libfwbuilder
{
    class Firewall;
}

enum BatchOperation {BATCH_INSTALL,BATCH_COMPILE} ;

typedef std::map<libfwbuilder::Firewall *,QListViewItem *> t_listMap;
typedef std::map<libfwbuilder::Firewall *,QCheckTableItem *> t_tableMap;
typedef std::list<libfwbuilder::Firewall *> t_fwList;
typedef std::pair<QString,QString> t_procMess; // first - compilation result, second - installation result;
typedef std::set<libfwbuilder::Firewall*> t_fwSet;


class instDialog : public instDialog_q {

    Q_OBJECT

    bool        ready;
    bool        activationCommandDone;
    instConf    cnf;

    QString     ssh;
    
    QString     confScript;
    QStringList confFiles;
    
    QString     fwb_prompt;
    
    QString     newKeyMsg;
    
    int         phase;

    QString replaceMacrosInCommand(const QString &cmd);
    QString getActivationCmd();
    //libfwbuilder::Firewall * firewall;
    t_fwSet reqFirewalls;


    // session is used when e run built-in installer
    SSHSession  *session;

    // proc is used to launch external oprocess, such as compiler or
    // user-defined installer script
    QProcess       proc;

    std::map<libfwbuilder::Firewall *, t_procMess>    processedFirewalls;

    t_fwList      firewalls;
    t_fwList      opList;

    t_fwList::iterator   opListIterator;

    t_listMap            opListMapping;
    t_tableMap           compileMapping;
    t_tableMap           installMapping;
    
    QStringList          args;
        
    QTextEdit           *currentLog;
    QButton             *currentSaveButton;
    QButton             *currentStopButton;
    QProgressBar        *currentProgressBar;
    QProgressBar        *currentFirewallsBar;
    QLabel              *currentLabel;
    QLabel              *currentFWLabel;
    QString              currentSearchString;
    
    BatchOperation       operation;
    instOptionsDialog_q *dlg;
    QString              pendingLogLine;

    int progress;
    int totalRules;
    int processedRules;
    int lastPage;
    bool stopProcessFlag;
    bool compileFlag;
    bool customScriptFlag;
    bool showSelectedFlag;

    void fillCompileSelectList();
    void selectAll(t_tableMap &mapping);
    void deselectAll(t_tableMap &mappin);
    void fillCompileOpList();
    void fillLastList();
    bool doInstallPage();
    void resetInstallSSHSession();    
    bool testFirewall(libfwbuilder::Firewall*);
    void finishInstall(bool success=true);
    void fillInstallOpList();
    void installSelected();
    void initInstall();
    void analyseInstallQueue(bool &fPix, bool &fCustInst);
    libfwbuilder::Firewall *findFirewallbyListItem(QListViewItem* item);
    libfwbuilder::Firewall *findFirewallbyTableItem(QCheckTableItem *item);
    
    
 public:
    instDialog(QWidget* p, BatchOperation op);
    virtual ~instDialog();
    
    void setReady(bool f) { ready=f; }

    void summary();


    QWidget* page(int n) { return QWizard::page(n); }
    
    void initiateCopy(const QString &file);
    void runSSH(SSHSession *s);
    void displayCommand(const QStringList &args);
    bool runCompile(libfwbuilder::Firewall *fw);
    bool runInstall(libfwbuilder::Firewall *fw);
    bool prepareArgForCompiler(libfwbuilder::Firewall *fw);
    bool isTableHasChecked();
    void clearReqFirewalls();
    void addReqFirewall(libfwbuilder::Firewall *f);
    void addToLog(const QString &buf); 
    
protected:

    virtual void showEvent( QShowEvent *ev);
    virtual void hideEvent( QHideEvent *ev);
    virtual void prepareInstallerOptions();
    
    virtual void prepareInstConf(libfwbuilder::Firewall *fw);
    virtual void storeInstallerOptions();
    virtual void findFirewalls();

    QString getFullPath(instConf &cnf, const QString &file );

 protected slots:
     void processExited();
     void installerFinished();
     void installerError();
     void selected(const QString &title);
     void reject();
     void testRunRequested();
     
     void append(const QString &line);
     void appendRich(const QString &line);
     void updateProgressBar(int n,bool setsize);

    void continueRun();
    virtual void saveLog();
    virtual void togleDetailMC();

    virtual void readFromStdout();
    virtual void selectAllFirewalls();
    virtual void deselectAllFirewalls();

    
    void compileSelected();
    void stopCompile();
    void stopInstall();
    void findFirewallInCompileLog(QListViewItem*);
    void showSelected();
    void tableValueChanged(int row, int col);
    
    
};


#endif
