# FitsClipBoard class
# Function: keep data (keywords, columns, rows or a block of data ) 
# for copying ...
# infoType:                            infoInfo:
#          tableBlock    {xdim ydim $blocks}  : blocks is a list of strings
#          tableRows     {numCols   $blocks}  :
#                                             : block ans rows use tcl variables
#          tableColumn   {dataAddress type numRows colName colType colUnit colNull}
#                                             : column use c variable in memory
#          keywords      {numKeys $keys}      : keywords use tcl string.
#          hdus          {numHDUs $sourceFileName} :
# 
#

class FitsClipBoard {
    
    constructor {args} {}
    destructor {}

    public method toggleView {}
    public method hide {}
    public method activate {}
    public method register {type src desc dataList}
    public method report {}
    public method clean {}
    public method hasRec {}
    
    private method buildWindow {}
    private method postMenus {}

    private variable infoType "None"
    private variable infoSrc  "None"
    private variable infoInfo "None"
    private variable dataBlock ""
    private variable droot
    private variable mBar
}


#
# Provide a lowercased access method for the FitsClipBoard class.
#
proc fcb {pathName args} {
    uplevel FitsClipBoard $pathName $args
}


body FitsClipBoard::constructor {args} {
   buildWindow
   hide
}


body FitsClipBoard::destructor {} {
    global backupDir

    catch { file delete [file join $backupDir cb.fits] }
    catch { destroy $droot }
}

body FitsClipBoard::buildWindow {} {
    global isMac

   set droot .[namespace tail $this]
   powToplevel $droot .dummy

   wm title $droot "fv Clipboard"

# Bind Menubar Events
   
   bind $droot <<CloseWindow>> [code $this hide]
   bind $droot <<Clear>>       [code $this clean]
   bind $droot <<PostMenus>>   [code $this postMenus]

# Create Menubar
   
   if { $isMac } {
       set mBar .mbar.clip
       set evtWndw ""
   } else {
       set mBar $droot.mbar
       set evtWndw $droot
   }
   $droot config -menu $mBar
    
   if { ![winfo exists $mBar] } {
       menu $mBar -postcommand "doMenuEvent <<PostMenus>> $evtWndw"
       if { $isMac } {
           $mBar add cascade -menu $mBar.apple
           $mBar add cascade -menu $mBar.file  -label File
           $mBar add cascade -menu $mBar.edit  -label Edit
           $mBar add cascade -menu .mbar.wind  -label Windows
           $mBar add cascade -menu $mBar.help  -label Help
           buildApplMenu $mBar.apple
           buildFileMenu $mBar.file
           buildEditMenu $mBar.edit
           # Opts and Wind use global menu
           buildHelpMenu $mBar.help v v
           $mBar.help delete 0 1
           $mBar.file entryconfig "Close" -state normal
       } else {
           $mBar add cascade -menu $mBar.edit -label Edit
           menu $mBar.edit -tearoff False \
                 -postcommand "doMenuEvent <<PostMenus>> $evtWndw"
           $mBar.edit add command -label Clear \
               -command "doMenuEvent <<Clear>>"
           $mBar.edit add command -label Close \
               -command "doMenuEvent <<CloseWindow>>"
       }
   }
    
# Create Window Body
   frame $droot.bodyF
   pack  $droot.bodyF -side top -fill both -expand 1
   
   label $droot.bodyF.typeT -text "Type" -width 10
   label $droot.bodyF.srcT  -text "Source" -width 10
   label $droot.bodyF.infoT -text "Info" -width 10
   frame $droot.bodyF.sepF  -relief raised -bd 2 -height 6
   
   label $droot.bodyF.typeL -textvariable [scope infoType]
   label $droot.bodyF.srcL  -textvariable [scope infoSrc]
   label $droot.bodyF.infoL -textvariable [scope infoInfo]
   
   grid configure $droot.bodyF.typeT -column 0 -row 0 -sticky "snew"
   grid configure $droot.bodyF.srcT  -column 2 -row 0 -sticky "snew"
   grid configure $droot.bodyF.infoT -column 1 -row 0 -sticky "snew"
   grid configure $droot.bodyF.sepF  -column 0 -row 1 -columnspan 3 \
	 -sticky "snew" 
   grid configure $droot.bodyF.typeL -column 0  -row 3 -sticky "snew"
   grid configure $droot.bodyF.srcL  -column 2 -row 3 -sticky "snew"
   grid configure $droot.bodyF.infoL -column 1 -row 3 -sticky "snew"

   grid columnconfigure $droot.bodyF 2 -weight 5
}

body FitsClipBoard::postMenus {} {
    global isMac

    if { [hasRec] } {
        $mBar.edit entryconfig "Clear" -state normal
    } else {
        $mBar.edit entryconfig "Clear" -state disabled
    }
   update idle
}


body FitsClipBoard::toggleView {} {
   if { ! [winfo exists $droot] } {
      buildWindow
   }
   if { [winfo viewable $droot] } {
      hide
   } else {
      activate
   }	 
}

body FitsClipBoard::hide {} {
    wm withdraw $droot
}

body FitsClipBoard::activate {} {
    wm deiconify $droot
    raise $droot
}

body FitsClipBoard::register {type src desc dataList} {
    if { [hasRec] } {
	clean
    }

    set infoType $type
    set infoSrc  $src
    set infoInfo $desc
    set dataBlock $dataList
}

body FitsClipBoard::clean {} {
    if { ![hasRec] } {
	return 
    }

# clean up the tcl variables
    set infoType "None"
    set infoSrc  "None"
    set infoInfo "None"
}

body FitsClipBoard::hasRec {} {
    if { $infoType == "None" } {
	return 0
    } else {
	return 1
    }
}

body FitsClipBoard::report {} {
    return [list $infoType $infoSrc $dataBlock]
}
