#!/usr/bin/perl
#
# ssh_dump.pl - Script to suck data outta the database to be processed by ssh_create.pl
#
# Symlink attack fix Copyright (C) 2009 Sylvain Beucler / GPLv2+ / no warranty
use DBI;
use English;

## Become this effective user (EUID/EGID) and perform this action.
## 
## This protect against symlink attacks; they are inevitable when
## working in a directory owned by a local user.  We could naively
## check for the presence of symlinks, but then we'd still be
## vulnerable to a symlink race attack.
## 
## We'll use set_e_uid/set_e_gid for efficiency and simplicity
## (e.g. we can get the return value directly), which is enough for
## opening files and similar basic operations.  When calling external
## programs, you should use fork&exec&setuid/setgid.
## 
# arg1: username
# arg2: a Perl sub{}
sub SudoEffectiveUser {
    my $user = $_[0];
    my $sub_unprivileged = $_[1];

    my ($uid,$gid) = GetUserUidGid($user);
    if ($uid eq "" or $gid eq "") {
	print "Unknown user: $user";
	return;
    }

    my $old_GID = $GID; # save additional groups
    $! = '';
    $EGID = "$gid $gid"; # set egid and additional groups
    if ($! ne '') {
	warn "Cannot setegid($gid $gid): $!";
	return;
    }
    $EUID = $uid;
    if ($! ne '') {
	warn "Cannot seteuid($uid): $!";
	return;
    }

    # Perform the action under this effective user:
    my $ret = &$sub_unprivileged();

    # Back to root
    undef($EUID);     # restore euid==uid
    $EGID = $old_GID; # restore egid==gid + additional groups

    return $ret;
}

## Get system uid/gid
sub GetUserUidGid {
    my $user = $_[0];
    my ($name,$passwd,$uid,$gid,
	$quota,$comment,$gcos,$dir,$shell,$expire) = getpwnam($user);
    return ($uid,$gid);
}

require("/usr/share/gforge/lib/include.pl");  # Include all the predefined functions

# Run as gforge
my($name,$passwd,$uid,$gid,$quota,$comment,$gcos,$dir,$shell) = getpwnam("gforge");
$> = $uid;

my $verbose=0;
my $ssh_array = ();

&db_connect;

$dbh->{AutoCommit} = 0;

# Dump the Table information
$query = "SELECT user_name,unix_uid,authorized_keys FROM users WHERE authorized_keys != '' AND status !='D'";
$c = $dbh->prepare($query);
$c->execute();
while(my ($username, $unix_uid, $ssh_key) = $c->fetchrow()) {
	$new_list = "$username:$unix_uid:$ssh_key\n";
	push @ssh_array, $new_list;
}

# Run as root
$> = 0; 

my ($username, $ssh_keys, $ssh_dir);

if($verbose){print("\n\n	Processing Users keys creation\n\n")};
while ($ln = pop(@ssh_array)) {
	($username, $uid, $ssh_key) = split(":", $ln);

	$ssh_key =~ s/\#\#\#/\n/g;
	$username =~ tr/[A-Z]/[a-z]/;
	$uid += $uid_add;

	push @user_authorized_keys, $ssh_key . "\n";
	push @user_authorized_keys, "\n# This file is automatically generated from your account settings.\n";

	$ssh_dir = "$homedir_prefix/$username/.ssh";

	if($verbose){print ("Processing $username\n")};

	if (-d "$homedir_prefix/$username"){
		if (! -d $ssh_dir) {
			mkdir $ssh_dir, 0755;
                        chown $uid, $uid, $ssh_dir;
		}
	
		if($verbose){print("Writing authorized_keys for $username: ")};
	
		SudoEffectiveUser($username, sub {
		    if (write_array_file("$ssh_dir/authorized_keys", @user_authorized_keys)) {
                        warn "Problem writing authorized_keys for $username\n";
                        next;
		    }
				  });

		chown $uid, $uid, ("$homedir_prefix/$username", $ssh_dir, "$ssh_dir/authorized_keys");
		chmod 0644, "$ssh_dir/authorized_keys";

		if($verbose){print ("Done\n")};
	} else {
		if($verbose){print ("Not yet done, waiting for home creation\n")};
	}

	undef @user_authorized_keys;
}
undef @ssh_array;

### Phase 2: remove the files when needed

# Dump the Table information
$query = "SELECT user_name,unix_uid FROM users WHERE authorized_keys = '' OR authorized_keys IS NULL OR status = 'D'";
$c = $dbh->prepare($query);
$c->execute();
while(my ($username, $unix_uid, $ssh_key) = $c->fetchrow()) {
	$new_list = "$username:$unix_uid\n";
	push @ssh_array, $new_list;
}

if($verbose){print("\n\n	Processing Users keys deletion\n\n")};
while ($ln = pop(@ssh_array)) {
	($username, $uid) = split(":", $ln);

	$username =~ tr/[A-Z]/[a-z]/;
	$uid += $uid_add;

	$ssh_dir = "$homedir_prefix/$username/.ssh";

	if($verbose){print ("Processing $username\n")};

	if (-d $ssh_dir) {
	    if($verbose){print("Resetting authorized_keys for $username: ")};

	    if (-l "$ssh_dir") {
		warn("$ssh_dir is a symlink, possible symlink attack!");
	    } else {
		unlink("$ssh_dir/authorized_keys");
	    }
	    system("chown $uid:$uid $homedir_prefix/$username");
	    system("chown $uid:$uid $ssh_dir");

	    if($verbose){print ("Done\n")};
	}
}
