#  -*- perl -*-

use Fcntl 	qw(:flock :seek :mode);
use IO::Handle;
use Encode;
use Digest::MD5 qw(md5_hex);

# set and untaint ENV if not in CLI (fexsrv provides clean ENV)
unless (-t) {
  foreach my $v (keys %ENV) {
    ($ENV{$v}) = ($ENV{$v} =~ /(.*)/);
  }
  $ENV{PATH} = '/usr/local/bin:/usr/bin:/bin';
}

umask 077;

our $debuglog;

$sendmail = '/usr/lib/sendmail';
$sendmail = '/usr/sbin/sendmail' unless -x $sendmail;
$sendmail = '/no/sendmail'       unless -x $sendmail;

$FEXLIB =~ s:/+$::;

# local config
require "$FEXLIB/fex.ph";

# $FEXHOME is top-level directory of F*EX installation
# $ENV{HOME} is login-directory of user fex
# in default-installation both are equal, but they may differ
if ($ENV{FEXHOME}) {
  $FEXHOME = $ENV{FEXHOME};
} else {
  $FEXHOME = $FEXLIB;
  $FEXHOME =~ s:/[^/]+$::;
  $ENV{FEXHOME} = $FEXHOME;
}

$ENV{PROTO} = 'http'			unless $ENV{PROTO};

$fra = $ENV{REMOTE_ADDR}||'?';

# set default values if not defined in fex.ph
$hostname = gethostname()		unless $hostname;
$tmpdir = $ENV{TMPDIR} || '/var/tmp'    unless $tmpdir;
$spooldir = $ENV{HOME}.'/spool'         unless $spooldir;
$docdir = $FEXHOME.'/htdocs'		unless $docdir;
$logdir = $spooldir                     unless $logdir;
$keep_default = 5			unless $keep_default;	# days
$timeout = 30				unless $timeout;	# seconds
$bs = 65536				unless $bs;		# I/O blocksize
  
$dkeydir = "$spooldir/.dkeys"; mkdirp($dkeydir); # download keys
$ukeydir = "$spooldir/.ukeys"; mkdirp($ukeydir); # upload keys
$akeydir = "$spooldir/.akeys"; mkdirp($akeydir); # authentification keys

http_die("cannot determine the server hostname") unless $hostname;

unless ($admin) {
  if ($ENV{SERVER_ADMIN}) {
    $admin = $ENV{SERVER_ADMIN};
  } else {
    $admin = 'fex@'.$hostname;
  }
}

# $ENV{SERVER_ADMIN} may be set empty in fex.ph!
$ENV{SERVER_ADMIN} = $admin unless defined $ENV{SERVER_ADMIN};

unless ($mdomain) {
  $mdomain = $hostname;
  $mdomain =~ s/.*?\.// 
    or die "cannot determine domain, define \$mdomain in fex.ph\n";
}

unless ($durl) {
  my $host = '';
  my $port = 0;
  
  if ($ENV{HTTP_HOST}) {
    ($host,$port) = split(':',$ENV{HTTP_HOST});
  }
  
  unless ($port) {
    $port = 80;
    if (open my $xinetd,'<',"/etc/xinetd.d/fex") {
      while (<$xinetd>) {
        if (/^\s*port\s*=\s*(\d+)/) {
          $port = $1;
          last;
        }
      }
      close $xinetd;
    }
  }
  
  $host = $hostname if $host !~ /\./;
  
  if ($ENV{PROTO} eq 'https' and $port == 443 or $port == 80) {
    $durl = "$ENV{PROTO}://$host/fop";
  } else {
    $durl = "$ENV{PROTO}://$host:$port/fop";
  }
}

sub debug {
  print header(),"<pre>\n";
  print "file = $file\n";
    foreach $v (keys %ENV) {
      print $v,' = "',$ENV{$v},"\"\n";
    }
  print "</pre><p>\n";
}

sub nvt_print {
  foreach (@_) { print $_,"\r\n" }
}

sub http_header {
  my $status = shift;
  my $msg = $status;

  return if $HTTP_HEADER;
  $HTTP_HEADER = $status;
  
  $msg =~ s/^\d+\s*//;

  nvt_print("HTTP/1.1 $status");
  nvt_print("X-Message: $msg");
  nvt_print("Server: fexsrv");
  nvt_print("Expires: 0");
  nvt_print("Cache-Control: no-cache");
  nvt_print("Connection: close");
  unless (grep /^Content-Type:/i,@_) {
    # nvt_print("Content-Type: text/html; charset=ISO-8859-1");
    nvt_print("Content-Type: text/html; charset=UTF-8");
  }

  nvt_print(@_,'');
}

sub html_header {
  my $title = shift;
  my $extra = shift || '';
  my $head;

  $head = qqq(qq(
    '<html>'
    '<head>'
    '  <meta http-equiv="expires" content="0">'
    '  <title>$title</title>'
    '</head>'
  ));
  if ($0 =~ /fexdev/) { $head .= "<body bgcolor=\"pink\">\n" } 
  else                { $head .= "<body>\n" }
  $title =~ s:F\*EX:<a href="/">F*EX</a>:;
  $head .= "<h1>$extra$title</h1>\n";

  return $head;
}

sub html_error {
  my $error = shift;
  my $msg = "@_";
  my $isodate = isodate(time);
  
  $msg =~ s/[\s\n]+/ /g;
  
  # cannot send standard HTTP Status-Code 400, because stupid 
  # Internet Explorer then refuses to display HTML body!
  http_header("666 Bad Request - $msg");
  print html_header($error),
        'ERROR: ',join("<p>\n",@_),"\n",
        "<p><hr><p>\n",
        "<address>$ENV{HTTP_HOST} $isodate</address>\n",
        "</body></html>\n";
  exit;
}

sub http_die {
  debuglog(@_);
  errorlog(@_);
  
  # create special error file on upload
  if ($uid) {
    my $ukey = "$spooldir/.ukeys/$uid";
    $ukey .= "/error" if -d $ukey;
    unlink $ukey;
    if (open $ukey,'>',$ukey) {
      print {$ukey} join("\n",@_),"\n";
      close $ukey;
    }
  }
  
  html_error($error,@_);
}

sub isodate {
  my @d = localtime shift;
  return sprintf('%d-%02d-%02d %02d:%02d:%02d',
                 $d[5]+1900,$d[4]+1,$d[3],$d[2],$d[1],$d[0]);
}

sub encode_Q {
  my $s = shift;
  $s =~ s{([\=\x00-\x20\x7F-\xA0])}{sprintf("=%02X",ord($1))}eog;
  return $s;
}  

# from MIME::Base64::Perl
sub decode_b64 {
  local $_ = shift;
  my $uu = '';
  my ($i,$l);

  tr|A-Za-z0-9+=/||cd;
  return '' if (length) % 4;
  s/=+$//;
  tr|A-Za-z0-9+/| -_|;
  return '' unless length;
  $l = (length)-60;
  for ($i = 0; $i <= $l; $i += 60) {
    $uu .= "M" . substr($_,$i,60);
  }
  $_ = substr($_,$i);
  $uu .= chr(32+(length)*3/4) . $_ if $_;
  return unpack ("u",$uu);
}

# simulate a "rm -rf", but never removes '..'
# return number of removed files
sub rmrf {
  my @files = @_;
  my $dels = 0;
  my ($file,$dir);
  local *D;
  local $_;
  
  foreach (@files) {
    next if /(^|\/)\.\.$/;
    /(.*)/; $file = $1;
    if (-d $file and not -l $file) {
      $dir = $file;
      opendir D,$dir or next;
      while ($file = readdir D) {
        next if $file eq '.' or $file eq '..';
        $dels += rmrf("$dir/$file");
      }
      closedir D;
      rmdir $dir and $dels++;
    } else {
      unlink $file and $dels++;
    }
  }
  return $dels;
}

sub notify {
  my ($status,$dkey,$filename,$keep,$warn,$comment,$autodelete) = @_;
  my ($to,$from,$file,$mimefilename);
  my ($mfrom,$mto,$size,$bytes,$days,$header,$server,$download);
  my $fua = $ENV{HTTP_USER_AGENT}||'?';
  my $warning = '';

  $warn = 2 unless $warn;
  $autodelete = 'YES' unless $autodelete;

  (undef,$to,$from,$file) = split('/',untaint(readlink("$dkeydir/$dkey")));
  $filename = strip_path($filename);
  $server = $hostname || $mdomain;
  $mfrom = $from;
  $mto = $to;
  $mfrom .= '@'.$mdomain if $mfrom !~ /@/;
  $mto .=   '@'.$mdomain if $mto   !~ /@/;
  $to = '' if $to eq $from;
  $header = "From: $mfrom ($mfrom via F*EX service $server)\n".
            "To: $mto\n";
  $size = $bytes = -s "$dkeydir/$dkey/data";
  if ($size >= 4*1024**3) {
    $warning = "
WARNING: File is greater than 4 GB. Internet Explorer cannot deal with such big
         files. You have to use another program for downloading, eg firefox.
";
  }
  if ($size < 2048) {
    $size = "$size Bytes";
  } elsif ($size/1024 < 2048) {
    $size = int($size/1024)." kB";
  } else {
    $size = int($size/1024/1024)." MB";
  }
  if ($autodelete eq 'YES') {
    $autodelete = 'WARNING: After download (or view with a web browser!), '
                . 'the file will be deleted!';
  } else {
    $autodelete = 'WARNING: You cannot download the file more than once!';
  }
  $mimefilename = $filename;
  if ($mimefilename =~ s{([_\?\=\x00-\x1F\x7F-\xFF])}{sprintf("=%02X",ord($1))}eog) {
    $mimefilename =~ s/ /_/g;
    $mimefilename = '=?UTF-8?Q?'.$mimefilename.'?=';
  }

  # use same protocal as uploader
  $download = "$durl/$dkey/".normalize_filename($filename);
  $download =~ s/^(https?:)/$ENV{PROTO}:/i;
  

  if ($status eq 'new') {
    $days = $keep;
    $header .= "Subject: F*EX-upload: $mimefilename\n";
  } else {
    $days = $warn;
    $header .= "Subject: reminder F*EX-upload: $mimefilename\n";
  }
  $header .= "X-FEX-Client-Address: $fra\n".
             "X-FEX-Client-Agent: $fua\n".
             "X-FEX-URL: $download\n".
             "X-FEX-Filesize: $bytes\n".
             "X-Mailer: F*EX\n".
             "MIME-Version: 1.0\n".
             "Content-Type: text/plain; charset=UTF-8\n".
             "Content-Transfer-Encoding: 8bit\n";
  if ($comment) { $comment = "Comment: $comment\n" }
  else          { $comment = "" }
  if ($days == 1) { $days .= " day" }
  else            { $days .= " days" }
  open P,"|$sendmail -f '$mfrom' $mto,fex" or http_die("cannot start sendmail - $!\n");
  print P $header,"\n";
# binmode(P,':utf8');
  pq(P,qq(
    '$from has uploaded the file'
    '  "$filename"'
    '($size) for you. Use the link'
    ''
    '$download'
    ''
    'to download this file within $days.'
    ''
    '$comment'
    '$autodelete'
    '$warning'
    ''
    'Remember: F*EX is not an archive, it is a transfer system for personal files.'
    ''
    ''
    'Questions? ==> F*EX admin: $admin'
  ));
  close P or http_die("cannot send notification e-mail (sendmail error $!)\n");
}

sub gethostname {
  my $hostname;
  local $_;
  
  $_ = `hostname 2>/dev/null`;
  $hostname = /(.+)/ ? $1 : '';
  if ($hostname !~ /\./ and open my $rc,'/etc/resolv.conf') {
    while (<$rc>) {
      if (/^\s*(domain|search)\s+([\w.-]+)/) {
        $hostname .= ".$2";
        last;
      }
    }
  }
  if ($hostname !~ /\./ and $admin =~ /\@([\w.-]+)/) {
    $hostname .= '.'.$1;
  }
  
  return $hostname;
}

# strip off path names (Windows or UNIX)
sub strip_path {
  local $_ = shift;
  
  if (/^([A-Z]:)?\\/) {
    s/.*\\//;
  }
  s:.*/::;
  
  return $_;
}

# substitute all critcal chars
sub normalize {
  local $_ = shift;
  
  # we need native utf8 (see perldoc utf8)
  $_ = decode_utf8($_) unless utf8::is_utf8($_);

  s/[\r\n\x09]+/ /g;
  s/[\x00-\x1F\x80-\x9F]/_/g;
  s/^\s+//;
  s/\s+$//;
  
  return encode_utf8($_);
}

# substitute all critcal chars with underscore
sub normalize_filename {
  local $_ = shift;

  return $_ unless $_;

  # we need native utf8
  $_ = decode_utf8($_) unless utf8::is_utf8($_);
 
  $_ = strip_path($_);
  
  # substitute all critcal chars with underscore
  s/[^a-zA-Z0-9_=.+-]/_/g;
  s/^\./_/;
  
  return encode_utf8($_);
}

sub untaint {
  local $_ = shift;
  /(.*)/;
  return $1;
}

sub checkaddress {
  my $a = shift;
  my $re;
  local $_;
  local ($domain,$dns);
  
  $re = '^[.@]|@.*@|local(host|domain)$|["\'\`\|\s()<>/;,]';
  if ($a =~ /$re/i) {
    debuglog("$a has illegal syntax ($re)");
    return '';
  }
  $re = '^[!^&=~#_:.+*${}\w\-\[\]]+\@(\w[.\w\-]*\.[a-z]+)$';
  if ($a =~ /$re/i) {
    $domain = $dns = $1;
    { 
      local $SIG{__DIE__} = sub { die "\n" };
      eval q{
        use Net::DNS;
        $dns = Net::DNS::Resolver->new->query($domain)||mx($domain);
      } 
    };
    if ($dns) {
      return untaint($a);
    } else {
      debuglog("no A or MX DNS-record found for $domain");
      return '';
    }
  } else {
    debuglog("$a does not match e-mail regexp ($re)");
    return '';
  }
}

sub randstring {
  my $n = shift;
  my @rc = ('A'..'Z','a'..'z',0..9 ); 
  my $rn = @rc; 
  my $rs;
  
  for (1..$n) { $rs .= $rc[int(rand($rn))] };
  return $rs;
}

# emulate mkdir -p
sub mkdirp {
  my $dir = shift;
  my $pdir;
  
  return if -d $dir;
  $dir =~ s:/+$::;
  http_die("cannot mkdir /\n") unless $dir;
  $pdir = $dir;
  if ($pdir =~ s:/[^/]+$::) {
    mkdirp($pdir) unless -d $pdir;
  }
  unless (-d $dir) {
    mkdir $dir,0770 or http_die("mkdir $dir - $!\n");
  }
}

# hash with SID
sub sidhash {
  my ($rid,$id) = @_;

  if ($rid and $ENV{SID} and $id =~ /^MD5H:/) {
    $rid = 'MD5H:'.md5_hex($rid.$ENV{SID});
  }
  return $rid;
}

# test if ip is in iplist
# iplist is an array with ips and ip-ranges
sub ipin {
  my ($ip,@list) = @_;
  my $ipn = ipn($ip);
  my ($x,$xn);
  
  foreach $x (@list) {
    if ($xn = ipn($x) and $ipn == $xn) {
      return 1;
    }
    if ($x =~ /([\d\.]+)-([\d\.]+)/ and 
        $xn1 = ipn($1) and $xn2 = ipn($2) and
        $ipn >= $xn1 and $ipn <= $xn2) {
      return 1;
    }
  }
  
}

# doted ip to ip integer
sub ipn {
  local $_ = shift;

  if (/^(\d+)\.(\d+)\.(\d+)\.(\d+)$/) {
    return $1*256**3+$2*256**2+$3*256+$4;
  } else {
    return undef;
  }
}

sub filename {
  my $file = shift;
  my $filename;

  if (open $file,'<',"$file/filename") {
    $filename = <$file>;
    close $file;
  }
  $filename = '???' unless defined $filename;
  
  return $filename;
}

sub urlencode {
  local $_ = shift;
  s/(^\.|[^\w.,=~^+-])/sprintf "%%%X",ord($1)/ge;
  return $_;
}

# file and document log
sub fdlog {
  my ($log,$file,$s,$size) = @_;
  my $ra;
  
  if (open $log,'>>',$log) {
    flock $log,LOCK_EX;
    seek $log,0,SEEK_END;
    $ra = $ENV{REMOTE_ADDR}||'-';
    $ra .= '/'.$ENV{HTTP_X_FORWARDED_FOR} if $ENV{HTTP_X_FORWARDED_FOR};
    $ra =~ s/\s//g;
    $file =~ s:/data$::;
    printf {$log} 
           "%s %s %s %s/%s\n",
           isodate(time),$ra,encode_Q($file),$s,$size;
    close $log;
  }
}

# extra debug log
sub debuglog {
  my $line;
  my $prg = $0;
  
  return unless $debug and @_;
  unless ($debuglog and fileno $debuglog) {
    mkdir "$logdir/.debug",0770 unless -d "$logdir/.debug";
    $prg =~ s:.*/::;
    $prg = untaint($prg);
    $debuglog = "$logdir/.debug/".isodate(time).".$prg";
    $debuglog =~ s/\s/_/g;
    open $debuglog,'>>',$debuglog or return;
    autoflush $debuglog 1;
    # printf {$debuglog} "\n### %s ###\n",isodate(time);
  }
  $line = "@_";
  $line =~ s/\n*$/\n/;
  print {$debuglog} $line;
  print "DEBUG: ",  $line if -t;
}

# extra debug log
sub errorlog {
  my $prg = $0;
  my $log = "$logdir/error.log";
  
  $prg =~ s:.*/::;
  
  if (open $log,'>>',$log) {
    flock $log,LOCK_EX;
    seek $log,0,SEEK_END;
    $ra = $ENV{REMOTE_ADDR}||'-';
    $ra .= '/'.$ENV{HTTP_X_FORWARDED_FOR} if $ENV{HTTP_X_FORWARDED_FOR};
    $ra =~ s/\s//g;
    printf {$log} "%s %s %s %s\n",isodate(time),$prg,$ra,"@_";
    close $log;
  }
}

# superquoting
sub qqq {
  local $_ = shift;
  my ($s,$i,@s);
  my $q = "[\'\"]"; # quote delimiter chars " and '

  # remove first newline and look for default indention
  s/^(\(\d+)?)?\n//;
  $i = ' ' x ($2||0);

  # remove trailing spaces at end
  s/[ \t]*?$//;

  @s = split "\n";

  # first line have a quote delimiter char?
  if (/^\s+$q/) {
    # remove heading spaces and delimiter chars
    foreach (@s) {
      s/^\s*$q//;
      s/$q\s*$//;
    }
  } else {
    # find the line with the fewest heading spaces (and count them)
    # (beware of tabs!)
    $s = length;
    foreach (@s) {
      if (/^( *)\S/ and length($1) < $s) { $s = length($1) };
    }
    # adjust indention
    foreach (@s) {
      s/^ {$s}/$i/;
    }
  }

  return join("\n",@s)."\n";
}

# print superquoted
sub pq {
  my $H = STDOUT;
  if (@_ > 1 and defined fileno $_[0]) { $H = shift }
  print $H qqq(@_);
}

1;
