/*
 * $Id: sig_opt_rgb.h,v 1.7 2009-05-21 16:38:08 vrsieh Exp $
 *
 * Video signal (only the video component of the VGA cable).
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_OPT_RGB_H_INCLUDED
#define __SIG_OPT_RGB_H_INCLUDED

#include <inttypes.h>
#include "sig_gen.h"

#define MAX_WIDTH	2048
#define MAX_WIDTH_MASK	(MAX_WIDTH-1)
#define MAX_HEIGHT	2048
#define MAX_HEIGHT_MASK	(MAX_HEIGHT-1)
#define MAX_DEPTH	32

struct sig_opt_rgb_funcs {
	void (*pixel_set)(void *s,
			unsigned int x, unsigned int y,
			uint8_t r, uint8_t g, uint8_t b);
	void (*size_set)(void *s,
			unsigned int width, unsigned int height);
	void (*sync)(void *s);
};

struct sig_opt_rgb {
	enum sig_gen_type type;
	struct {
		const struct sig_opt_rgb_funcs *f;
		void *s;
	} member[20];
	unsigned int member_count;
};

struct sig_opt_rgb_merge {
	struct sig_opt_rgb *s0;
	struct sig_opt_rgb *s1;
};

extern void
sig_opt_rgb_pixel_set(struct sig_opt_rgb *b, void *s,
		unsigned int x, unsigned int y,
		uint8_t red, uint8_t green, uint8_t blue);
extern void
sig_opt_rgb_size_set(struct sig_opt_rgb *b, void *s,
		unsigned int width, unsigned int height);
extern void
sig_opt_rgb_sync(struct sig_opt_rgb *b, void *s);

extern void
sig_opt_rgb_connect(struct sig_opt_rgb *b, void *s, 
	const struct sig_opt_rgb_funcs *f);

extern struct sig_opt_rgb_merge *
sig_opt_rgb_merge(struct sig_opt_rgb *s0, struct sig_opt_rgb *s1);
extern void
sig_opt_rgb_split(struct sig_opt_rgb_merge *m);

extern struct sig_opt_rgb *
sig_opt_rgb_create(const char *name);
extern void
sig_opt_rgb_destroy(struct sig_opt_rgb *sig);

#endif /* __SIG_OPT_RGB_H_INCLUDED */
