#!/usr/bin/env python

# $Id: gen_tests_list.py,v 1.2 2009-11-19 13:05:58 potyra Exp $
# 
# Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.

from random import choice, randint
import sys

# generate a random number of entries for tests.list
# usage: gen_tests_list.py <number>


def block_params():
	min_block = 1
	# disk size: 499 MiB, one block = 512 B
	max_block = 499 * 1024 * 1024 / 512
	length = randint(20,30)

	ret = ["%d" % randint(min_block, max_block) for i in range(1, length)]

	return " ".join(ret)

def gen_random_test():
	disk = "hdb"
	# 10 minutes to 60 minutes
	delay = randint(10*60*1000, 60*60*1000)
	
	selected_fault = ("block-fault", block_params)
	return "%d %s %s %s" % (delay, selected_fault[0], disk, \
		selected_fault[1]())
	

def main():
	print_golden = False
	if len(sys.argv) > 1:
		num = int(sys.argv[1])
		print_golden = True
	else:
		num = 1

	if print_golden:
		print "1000 golden hdb"
	for i in range(0, num):
		print gen_random_test()

if __name__ == '__main__':
	main()
