--
-- $Id: test_bench.vhdl,v 1.4 2009-10-15 16:03:26 vrsieh Exp $
--
-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

library expect;
use expect.types.all;
use expect.procedures.all;
library ieee;
use ieee.std_logic_1164.ALL;

entity test_bench is
end test_bench;

architecture structural of test_bench is
	signal ext_eth0: eth;
	signal ext_eth1: eth;

	signal floppy_conn : floppy_array(1 to 20);
	signal cddvd_conn : magneto_optical_array(1 to 20);

	signal pc1_power_button: boolean;
	signal pc1_cdrom: cstring;
	signal pc1_key: boolean_array(0 to 127);
	signal pc1_opt_screen: opt_rgb;
	signal pc1_screen_shot: boolean;
	signal pc1_rec : boolean;
	signal pc1_usb0 : usb_bus;
	signal pc1_usb1 : usb_bus;
	signal pc1_par : parallel;
	signal pc1_ser0 : serial;
	signal pc1_ser1 : serial;
	signal pc1_power_switch : boolean;
	signal pc1_reset_button : boolean;
	signal pc1_floppy : cstring;
	signal pc1_mouse_dx : integer;
	signal pc1_mouse_dy : integer;
	signal pc1_mouse_dz : integer;
	signal pc1_mouse_button1 : boolean;
	signal pc1_mouse_button2 : boolean;
	signal pc1_mouse_button3 : boolean;
	signal pc1_mouse_button4 : boolean;
	signal pc1_mouse_button5 : boolean;

	signal pc2_power_button: boolean;
	signal pc2_cdrom: cstring;
	signal pc2_key: boolean_array(0 to 127);
	signal pc2_opt_screen: opt_rgb;
	signal pc2_screen_shot: boolean;
	signal pc2_rec : boolean;
	signal pc2_usb0 : usb_bus;
	signal pc2_usb1 : usb_bus;
	signal pc2_par : parallel;
	signal pc2_ser0 : serial;
	signal pc2_ser1 : serial;
	signal pc2_power_switch : boolean;
	signal pc2_reset_button : boolean;
	signal pc2_floppy : cstring;
	signal pc2_mouse_dx : integer;
	signal pc2_mouse_dy : integer;
	signal pc2_mouse_dz : integer;
	signal pc2_mouse_button1 : boolean;
	signal pc2_mouse_button2 : boolean;
	signal pc2_mouse_button3 : boolean;
	signal pc2_mouse_button4 : boolean;
	signal pc2_mouse_button5 : boolean;

	signal fault: integer;
begin
	pc1 : pc_standard
		generic map(
			memsize => 128,
			disksize => 32
		)
		port map (
			ext_eth0 => ext_eth0,
			ext_usb0 => pc1_usb0,
			ext_usb1 => pc1_usb1,
			ext_par => pc1_par,
			ext_ser0 => pc1_ser0,
			ext_ser1 => pc1_ser1,
			power_switch => pc1_power_switch,
			power_button => pc1_power_button,
			reset_button => pc1_reset_button,
			floppy => pc1_floppy,
			cdrom => pc1_cdrom,
			key => pc1_key,
			opt_screen => pc1_opt_screen,
			screen_shot => pc1_screen_shot,
			rec => pc1_rec,
			mouse_dx => pc1_mouse_dx,
			mouse_dy => pc1_mouse_dy,
			mouse_dz => pc1_mouse_dz,
			mouse_button1 => pc1_mouse_button1,
			mouse_button2 => pc1_mouse_button2,
			mouse_button3 => pc1_mouse_button3,
			mouse_button4 => pc1_mouse_button4,
			mouse_button5 => pc1_mouse_button5
		);
	pc2 : pc_standard
		generic map (
			memsize => 128,
			disksize => 32
		)
		port map (
			ext_eth0 => ext_eth1,
			ext_usb0 => pc2_usb0,
			ext_usb1 => pc2_usb1,
			ext_par => pc2_par,
			ext_ser0 => pc2_ser0,
			ext_ser1 => pc2_ser1,
			power_switch => pc2_power_switch,
			power_button => pc2_power_button,
			reset_button => pc2_reset_button,
			floppy => pc2_floppy,
			cdrom => pc2_cdrom,
			key => pc2_key,
			opt_screen => pc2_opt_screen,
			screen_shot => pc2_screen_shot,
			rec => pc2_rec,
			mouse_dx => pc2_mouse_dx,
			mouse_dy => pc2_mouse_dy,
			mouse_dz => pc2_mouse_dz,
			mouse_button1 => pc2_mouse_button1,
			mouse_button2 => pc2_mouse_button2,
			mouse_button3 => pc2_mouse_button3,
			mouse_button4 => pc2_mouse_button4,
			mouse_button5 => pc2_mouse_button5
		);
	cable : network_cable
		port map(
			end0 => ext_eth0,
			end1 => ext_eth1
		);
	dhcp_server : dhcp_server
		port map(
			eth => ext_eth0
		);
	user : user
		port map(
			pc1_power_button => pc1_power_button,
			pc1_cdrom => pc1_cdrom,
			pc1_key => pc1_key,
			pc1_opt_screen => pc1_opt_screen,
			pc1_screen_shot => pc1_screen_shot,
			pc1_rec => pc1_rec,
			pc2_power_button => pc2_power_button,
			pc2_cdrom => pc2_cdrom,
			pc2_key => pc2_key,
			pc2_opt_screen => pc2_opt_screen,
			pc2_screen_shot => pc2_screen_shot,
			pc2_rec => pc2_rec
		);

	-- generated media image components will be inserted here
	-- @MEDIA_IMAGE_COMPS@
end structural;
