/*
 * $Id: pci_intel_eepro100_gui_gtk.c,v 1.27 2009-06-16 07:34:27 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "system.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-led.h"
#include "glue-gui-gtk-fi.h"
#include "sig_integer.h"

#include "pci_intel_eepro100_gui_gtk.h"

#define COMP "pci_intel_eepro100"

struct cpssp {
	GtkWidget *busy_led;
};

/*
 * Simulator Callbacks
 */
static void
gui_network_opt_busy_led_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_led_set(GUI_GTK_LED(cpssp->busy_led), val);
	gui_gtk_flush();
}

/*
 * GUI Callbacks
 */
void *
pci_intel_eepro100_gui_gtk_create(
	unsigned int page,
	const char *name,
	const char *mac,
	struct sig_manage *manage,
	struct sig_pci_bus *port_pci,
	struct sig_eth *port_eth,
	struct sig_boolean *port_opt_busy_led
)
{
	static const struct sig_boolean_funcs opt_busy_led_funcs = {
		.set = gui_network_opt_busy_led_set,
	};
	struct cpssp *cpssp;
	GtkWidget *vbox;
	GtkWidget *hbox;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	vbox = gtk_vbox_new(FALSE, 1);

	hbox = gtk_hbox_new(FALSE, 1);

	cpssp->busy_led = gui_gtk_led_new("Busy");
	gtk_widget_show(cpssp->busy_led);
	gtk_box_pack_start(GTK_BOX(hbox), cpssp->busy_led, FALSE, FALSE, 1);

	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 1);

	gui_gtk_comp_add(page, COMP, name, vbox, FALSE, FALSE, NULL);

	/* In */
	sig_boolean_connect_in(port_opt_busy_led, cpssp, &opt_busy_led_funcs);

	return cpssp;
}

void
pci_intel_eepro100_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
