/*
 * $Id: ide_gen_cdrom.c,v 1.212 2009-10-01 06:42:55 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* This will turn on packet command debug output. */
#define DEBUGPCOM	0

/*
 * Config Options
 */
#define CD_AUDIO_SUPPORT		0
#define CD_WRITER_SUPPORT		1
#define CD_CHANGER_SUPPORT		0

/* CD_WRITER_SUPPORT */
#define CD_WRITER_RW_SUPPORT		0
#define CD_WRITER_DAO_SUPPORT		1

#define CD_FORMAT_UNIT_SUPPORT		0
#define CD_READ_BUFFER_CAPACITY_SUPPORT	0
#define CD_READ_MASTER_CUE_SUPPORT	0
#define CD_SEND_CUE_SHEET_SUPPORT	0
#define CD_SEND_OPC_INFORMATION_SUPPORT	0

#define CD_PLAY_CD_SUPPORT		0
#define CD_READ_CD_SUPPORT		0
#define CD_SCAN_CD_SUPPORT		0

#define COMP	ide_gen_cdrom
#define SCOMP	"ide_gen_cdrom"

#include "config.h"

#include <assert.h>
#include <fcntl.h>
#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "fixme.h"
#include "glue-log.h"
#include "glue-main.h"
#include "system.h"

#include "sig_ide.h"

#include "ide_gen_cdrom.h"

struct cpssp {
	/* Config */
	char name[1024];

	/* Ports */
	struct sig_boolean *port_power_power_5V;
	struct sig_boolean *port_power_power_12V;
	struct sig_magneto_optical *port_media;
	struct sig_ide_bus *cable;

	/* State */
	unsigned char buf[0x10000];
	unsigned int head;
	unsigned int tail;
	unsigned int count;

	unsigned long m2t_count;
	unsigned long long m2t_pos;

	unsigned char error;	/* error reg (ro) */

#define STATE

#define ATAPI		1
#define NAME		cdrom
#define NAME_(x)	cdrom_ ## x
#define SNAME		"cdrom"
#include "arch_scsi_gen_cdrom.c"
#undef SNAME
#undef NAME_
#undef NAME
#undef ATAPI

#define NAME		atapi
#define NAME_(x)	atapi_ ## x
#define SNAME		"atapi"
#include "arch_gen_atapi.c"
#undef SNAME
#undef NAME_
#undef NAME

#undef STATE
};

/*forward*/ static void
atapi_phase_free(struct cpssp *cpssp);
/*forward*/ static void
atapi_phase_cmd(struct cpssp *cpssp);
/*forward*/ static void
atapi_phase_status(struct cpssp *cpssp);
/*forward*/ static void
atapi_phase_data_in(struct cpssp *cpssp);
/*forward*/ static void
atapi_phase_data_out(struct cpssp *cpssp);
/*forward*/ static void
atapi_phase_msg_in(struct cpssp *cpssp);
/*forward*/ static void
atapi_phase_msg_out(struct cpssp *cpssp);
/*forward*/ static void
atapi_should_recv(struct cpssp *cpssp, unsigned long count);
/*forward*/ static void
atapi_should_send(struct cpssp *cpssp, unsigned long count);

/*forward*/ static void
cdrom_atn_set(struct cpssp *cpssp, unsigned int val);
/*forward*/ static int
cdrom_phase_select(struct cpssp *cpssp, uint32_t id);
/*forward*/ static int
cdrom_recv(struct cpssp *cpssp, uint8_t *buf, unsigned int bufsize);
/*forward*/ static int
cdrom_send(struct cpssp *cpssp, const uint8_t *buf, unsigned int bufsize);

static void
atapi_phase_select(struct cpssp *cpssp)
{
	cdrom_atn_set(cpssp, 0);
	(void) cdrom_phase_select(cpssp, 0);
}

static int
atapi_send(struct cpssp *cpssp, const void *buf, unsigned int bufsize)
{
	return cdrom_send(cpssp, (const uint8_t *) buf, bufsize);
}

static int
atapi_recv(struct cpssp *cpssp, void *buf, unsigned int bufsize)
{
	return cdrom_recv(cpssp, (uint8_t *) buf, bufsize);
}

static void
cdrom_want_recv(struct cpssp *cpssp, unsigned int count)
{
	atapi_should_send(cpssp, count);
}

static void
cdrom_want_send(struct cpssp *cpssp, unsigned int count)
{
	atapi_should_recv(cpssp, count);
}

static void
cdrom_phase_free(struct cpssp *cpssp)
{
	atapi_phase_free(cpssp);
}

static void
cdrom_phase_cmd(struct cpssp *cpssp)
{
	atapi_phase_cmd(cpssp);
}

static void
cdrom_phase_status(struct cpssp *cpssp)
{
	atapi_phase_status(cpssp);
}

static void
cdrom_phase_data_in(struct cpssp *cpssp)
{
	atapi_phase_data_in(cpssp);
}

static void
cdrom_phase_data_out(struct cpssp *cpssp)
{
	atapi_phase_data_out(cpssp);
}

static void
cdrom_phase_msg_in(struct cpssp *cpssp)
{
	atapi_phase_msg_in(cpssp);
}

static void
cdrom_phase_msg_out(struct cpssp *cpssp)
{
	atapi_phase_msg_out(cpssp);
}

#define BEHAVIOR

#define ATAPI		1
#define NAME		cdrom
#define NAME_(x)	cdrom_ ## x
#define SNAME		"cdrom"
#include "arch_scsi_gen_cdrom.c"
#undef SNAME
#undef NAME_
#undef NAME
#undef ATAPI

#define NAME		atapi
#define NAME_(x)	atapi_ ## x
#define SNAME		"atapi"
#include "arch_gen_atapi.c"
#undef SNAME
#undef NAME_
#undef NAME

#undef BEHAVIOR

static void
ide_gen_cdrom_power_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	atapi_power_set(cpssp, val);
	cdrom_power_set(cpssp, val);
}

static int
ide_gen_cdrom_inw(void *_cpssp, unsigned short port, uint16_t *valp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	return atapi_inw(cpssp, port, valp);
}

static void
ide_gen_cdrom_outw(void *_cpssp, unsigned short port, uint16_t value)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	atapi_outw(cpssp, port, value);
}

static void
ide_gen_cdrom_change(void *_cpssp, const char *path)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cdrom_change(cpssp, path);
}

void *
ide_gen_cdrom_create(
	const char *name,
	const char *unit_str,
	struct sig_manage *port_manage,
	struct sig_power_device *port_power,
	struct sig_ide_bus *port_ide,
	struct sig_magneto_optical *port_media,
	struct sig_string *port_change
)
{
	static const struct sig_boolean_funcs power_funcs = {
		.set = ide_gen_cdrom_power_set,
	};
	static const struct sig_ide_bus_device_funcs funcs = {
		.inw = ide_gen_cdrom_inw,
		.outw = ide_gen_cdrom_outw,
	};
	static const struct sig_string_funcs change_funcs = {
		.set = ide_gen_cdrom_change,
	};
	struct cpssp *cpssp;
	unsigned int unit;
	char path[1024];

	if (! unit_str) unit_str = "0";

	system_name_push(name);

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	assert(strlen(system_path()) < sizeof(cpssp->name));
	strcpy(cpssp->name, system_path());

	unit = strtoul(unit_str, NULL, 0);

	atapi_create(cpssp, unit);

	assert(strlen(system_path()) + strlen(".media") + 1 <= sizeof(path));
	sprintf(path, "%s.media", system_path());

	cdrom_create(cpssp, path, 0);

	cpssp->port_power_power_5V = port_power->power_5V;
	cpssp->port_power_power_12V = port_power->power_12V;
	sig_boolean_connect_in(cpssp->port_power_power_5V, cpssp, &power_funcs);

	cpssp->cable = port_ide;
	sig_ide_bus_connect_device(port_ide, cpssp, &funcs);

	cpssp->port_media = port_media;

	sig_string_connect(port_change, cpssp, &change_funcs);

	cdrom_init(cpssp);

	system_name_pop();

	return cpssp;
}

void
ide_gen_cdrom_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	atapi_destroy(cpssp);
	cdrom_destroy(cpssp);

	free(cpssp);
}
