/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: pixmap.h
 */

typedef enum {
	INFO_PIXMAP = 0,
	WARNING_PIXMAP,
	ERROR_PIXMAP,
	QUESTION_PIXMAP
} dialog_pixmap_type_t;

void create_standard_pixmaps(GtkWidget * widget);

void get_checkmark_box_pixmap(gboolean critical, gboolean checked, GdkPixmap ** pixmap,
			      GdkBitmap ** mask);

void get_open_volume_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_refresh_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_pixmap_for_object_type(object_type_t type, GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_dialog_pixmap(dialog_pixmap_type_t type, GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_topmost_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_ok_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_exit_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_exit_16_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_cancel_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_commit_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_commit_16_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_help_16_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_clear_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_exec_16_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void get_search_16_pixmap(GdkPixmap ** pixmap, GdkBitmap ** mask);

void set_clist_row_pixmap(GtkCList * clist, gint row, object_type_t type);

GtkWidget *create_pixmap_widget(const gchar * name);
