# (C) Copyright IBM Corp. 2004
#
# This program is free software;  you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY;  without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
# the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program;  if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# Perl module with common subroutines for logging messages.

package Evms::Log;

use strict;
use warnings;

my $debug = 1;

BEGIN {
	use Exporter();
	our (@ISA, @EXPORT);
        @ISA = qw(Exporter);
        @EXPORT = qw(&log_info
		     &log_error
		     &log_debug
		     &log_result);
}

sub whoami {
	(caller(1))[3];
}

sub whowasi {
	(caller(2))[3];
}

sub log_info($)
{
	my $line = $_[0];
	my $caller = whowasi() || "";

	if ($caller =~ s/^.+::(.+)$/$1/ &&
	    $caller =~ /^(Test)|(Setup)/i) {
		$caller .= ": ";
	} else {
		$caller = "";
	}

	print $caller . $line;
}

sub log_error($)
{
	my $line = $_[0];
	my $caller = whowasi() || "";

	if (defined($caller) &&
	    $caller =~ s/^.+::(.+)$/$1/ &&
	    $caller =~ /^(Test)|(Setup)/i) {
		$caller .= ": ";
	} else {
		$caller = "";
	}

	print STDERR $caller . $line;
}

sub log_debug($)
{
	my $line = $_[0];
	$ENV{"EVMS_DEBUG"} && print "DEBUG: " . $line;
}

sub log_result($)
{
	my $rc = $_[0];
	my $caller = whowasi() || "";

	if (defined($caller) &&
	    $caller =~ s/^.+::(.+)$/$1/ &&
	    $caller =~ /^(Test)|(Setup)/i) {
		$caller .= ": ";
	} else {
		$caller = "";
	}

	print $caller . ($rc ? "Failed" : "Success") . "\n\n";
}

1;

