/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libs390.so
 *
 *   File: options.h
 */

#ifndef   S390_OPTIONS_HEADER
#define   S390_OPTIONS_HEADER 1

#define MAX_TYPENAME_SIZE                           128


//
// Create Option Info
//
#define SEG_CREATE_OPTION_COUNT                     2

#define SEG_CREATE_OPTION_SIZE_INDEX                0
#define SEG_CREATE_OPTION_SIZE_NAME                 "Size"
#define SEG_CREATE_OPTION_OFFSET_INDEX              1
#define SEG_CREATE_OPTION_OFFSET_NAME               "Offset"


//
// Assign Option Info
//
#define SEG_ASSIGN_OPTION_COUNT                     0


//
// Private Plugin Functions
// 
//
#define EVMS_Task_Format_Disk   (EVMS_Task_Plugin_Function+1)
#define EVMS_Task_Move_Segment  (EVMS_Task_Plugin_Function+2)

#define SEG_FORMAT_OPTION_COUNT                     2
#define SEG_FORMAT_OPTION_TYPENAME_INDEX            0
#define SEG_FORMAT_OPTION_TYPENAME_NAME             "DiskType"
#define SEG_FORMAT_OPTION_BLKSIZE_INDEX             1
#define SEG_FORMAT_OPTION_BLKSIZE_NAME              "BlockSize"

#define SEG_MOVE_OPTION_COUNT                       1
#define SEG_MOVE_OPTION_INDEX                       0
#define SEG_MOVE_OPTION_NAME                        "Move"





//
// Expand Option Info
//
#define SEG_EXPAND_OPTION_COUNT                     1
#define SEG_EXPAND_OPTION_SIZE_INDEX                0
#define SEG_EXPAND_OPTION_SIZE_NAME                 "Size"


//
// Shrink Option Info
//
#define SEG_SHRINK_OPTION_COUNT                     1
#define SEG_SHRINK_OPTION_SIZE_INDEX                0
#define SEG_SHRINK_OPTION_SIZE_NAME                 "Size"



int         S390_GetOptionCount(task_context_t * task);

int         S390_InitTask(task_context_t * context);

int         S390_SetOption( task_context_t * context, u_int32_t index, value_t * value, u_int32_t * info );

int         S390_SetObjects( task_context_t * context,
                             list_anchor_t    declined_objects,
                             task_effect_t  * effect );

int         S390_GetInfo( storage_object_t  * object, char * name, extended_info_array_t * * info);

int         S390_GetPluginInfo( char * descriptor_name, extended_info_array_t * * info );


#endif

