#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>


#include "entity.h"


/* This tag is responsible for renderering a toplevel <system/> tag * with
 * various properties from the system */

static void
system_info_render (ENode * node)
{
    char *dir;

    enode_attrib_str (node, "name", "info");
    enode_attrib_str (node, "version", ENTITY_VERSION);
    enode_attrib_str (node, "operating-system", CANONICAL_HOST_OS);
    enode_attrib_str (node, "cpu-type", CANONICAL_HOST_CPU);

    dir = econfig_get_attr ("entity-startup-dir");
    enode_attrib_str (node, "startup-directory", dir);
}

void
system_info_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);
    element->tag = "system-info";
    element->description = "Get various bits of system information.";
    element->render_func = system_info_render;
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "cpu-type";
    e_attr->description = "CPU Type";
    e_attr->value_desc = "string";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "operating-system";
    e_attr->description = "Operating system Entity was compiled under.";
    e_attr->value_desc = "string";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "version";
    e_attr->description = "Entity version.";
    e_attr->value_desc = "string";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "startup-directory";
    e_attr->description = "A string representing the current directory.";
    e_attr->value_desc = "string";
    element_register_attrib (element, e_attr);

}
