#include <gtk/gtk.h>
#include "entity.h"
#include "toggle-renderer.h"


static gint
rendgtk_toggle_selected_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *toggle;

    EDEBUG (("toggle-renderer", "in rendgtk_toggle_selected_attr_set"));
    toggle = enode_get_kv (node, "top-widget");
    if (!toggle)
	return FALSE;

    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle),
				  erend_value_is_true (value));
    return TRUE;
}


void
rendgtk_toggle_ontoggle_callback (GtkWidget * toggle, ENode * node)
{
    gchar *function = NULL;
    int isset;

    function = enode_attrib_str (node, "ontoggle", NULL);
    if (!function && ebuf_equal_str (enode_type (node), "radio")) {
	ENode *parent;
	parent = enode_parent (node, "radio-group");
	if (parent)
	    function = enode_attrib_str (parent, "ontoggle", NULL);
    }

    /* Retrieve the state of the widget and set it to the state of the node. */
    isset = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggle));
    if (isset) {
	enode_attrib_quiet (node, "selected", ebuf_new_with_true ());
    } else {
	enode_attrib_quiet (node, "selected", ebuf_new_with_false ());
    }

    EDEBUG (("toggle-renderer", "selected = %s\n",
	     enode_attrib_str (node, "selected", NULL), NULL));

    if (function) {
	enode_call_ignore_return (node, function, "");
    }
}

void
rendgtk_toggle_onselect_callback (GtkWidget * toggle, ENode * node)
{
    gchar *function = NULL;
    int isset;

    function = enode_attrib_str (node, "onselect", NULL);

    if (!function && ebuf_equal_str (enode_type (node), "radio")) {
	ENode *parent;
	parent = enode_parent (node, "radio-group");
	function = enode_attrib_str (parent, "onselect", NULL);
    }

    /* Retrieve the state of the widget and set it to the state of the node. */
    isset = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggle));
    if (isset) {
	enode_attrib_str (node, "selected", "true");
    } else {
	enode_attrib_str (node, "selected", "false");
	return;			/* Don't tell them about the toggle OFF
				 * signal. */
    }

    if (function) {
	enode_call_ignore_return (node, function, "");
    }
}


void
rendgtk_toggle_attr_register (Element * element)
{
    ElementAttr *e_attr;

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "selected";
    e_attr->description = "Toggles the button on or off.";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "false,true";
    e_attr->set_attr_func = rendgtk_toggle_selected_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onselect";
    e_attr->description =
	"Function to call when the toggle button is clicked to the 'selected' position.";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(toggle_button)";
    element_register_attrib (element, e_attr);
}
