/*
 * Eee Applet 
 * Copyright (C) 2004-2007 Olivier Rolland <billl@users.sf.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"

#include "eee-pref.h"
#include "eee-gconf.h"

#include <glib/gi18n.h>
#include <glade/glade.h>
#include <gconf/gconf-client.h>

#define EEE_GLADE_FILE "eee-applet/eee-pref.glade"
#define EEE_GLADE_ROOT "root"

#define EEE_PREF_DIALOG_GET_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE ((o), EEE_TYPE_PREF_DIALOG, EeePrefDialogPriv))

struct _EeePrefDialogPriv
{
  GtkWidget *profile_combo;
};

static GObject * eee_pref_dialog_constructor (GType type, guint n,
    GObjectConstructParam *construct_properties);

extern GConfClient *client;

static void
eee_pref_dialog_widget_toggle (GtkWidget *check, const gchar *key)
{
  gconf_client_set_bool (client, key,
      gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check)), NULL);
}

G_DEFINE_TYPE (EeePrefDialog, eee_pref_dialog, GTK_TYPE_DIALOG);

static void
eee_pref_dialog_class_init (EeePrefDialogClass *klass)
{
  GObjectClass *gobject_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->constructor = eee_pref_dialog_constructor;

  g_type_class_add_private (klass, sizeof (EeePrefDialogPriv));
}

static void
eee_pref_dialog_init (EeePrefDialog *dialog)
{
  GtkWidget *widget;
  GladeXML *xml;

  dialog->priv = EEE_PREF_DIALOG_GET_PRIVATE (dialog);

  xml = glade_xml_new (DATADIR "/" EEE_GLADE_FILE, EEE_GLADE_ROOT, NULL);
  if (!xml)
  {
    g_warning ("Could not find " EEE_GLADE_FILE);
    return;
  }

  gtk_dialog_add_buttons (GTK_DIALOG (dialog),
      GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL);
  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_CLOSE);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Preferences"));

  gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 6);

  widget = glade_xml_get_widget (xml, EEE_GLADE_ROOT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), widget, TRUE, TRUE, 0);
  gtk_widget_show (widget);

  widget = glade_xml_get_widget (xml, "can-disable-wlan-check");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
      gconf_client_get_bool (client, EEE_GCONF_CAN_DISABLE_WLAN, NULL));
  g_signal_connect (widget, "toggled",
      G_CALLBACK (eee_pref_dialog_widget_toggle), EEE_GCONF_CAN_DISABLE_WLAN);

  widget = glade_xml_get_widget (xml, "can-disable-cardr-check");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
      gconf_client_get_bool (client, EEE_GCONF_CAN_DISABLE_CARDR, NULL));
  g_signal_connect (widget, "toggled",
      G_CALLBACK (eee_pref_dialog_widget_toggle), EEE_GCONF_CAN_DISABLE_CARDR);

  widget = glade_xml_get_widget (xml, "can-disable-camera-check");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
      gconf_client_get_bool (client, EEE_GCONF_CAN_DISABLE_CAMERA, NULL));
  g_signal_connect (widget, "toggled",
      G_CALLBACK (eee_pref_dialog_widget_toggle), EEE_GCONF_CAN_DISABLE_CAMERA);

  widget = glade_xml_get_widget (xml, "can-overclock-check");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
      gconf_client_get_bool (client, EEE_GCONF_CAN_OVERCLOCK, NULL));
  g_signal_connect (widget, "toggled",
      G_CALLBACK (eee_pref_dialog_widget_toggle), EEE_GCONF_CAN_OVERCLOCK);

  widget = glade_xml_get_widget (xml, "can-change-fan-speed-check");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
      gconf_client_get_bool (client, EEE_GCONF_CAN_CHANGE_FAN_SPEED, NULL));
  g_signal_connect (widget, "toggled",
      G_CALLBACK (eee_pref_dialog_widget_toggle), EEE_GCONF_CAN_CHANGE_FAN_SPEED);

  widget = glade_xml_get_widget (xml, "hotkeys-check");

#ifdef HAVE_HOTKEYS
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
      gconf_client_get_bool (client, EEE_GCONF_HOTKEYS, NULL));
  g_signal_connect (widget, "toggled",
      G_CALLBACK (eee_pref_dialog_widget_toggle), EEE_GCONF_HOTKEYS);
  gtk_widget_show (widget);
#else
  gtk_widget_hide (widget);
#endif

  g_object_unref (xml);
}

static GObject *
eee_pref_dialog_constructor (GType type, guint n,
    GObjectConstructParam *construct_properties)
{
  return G_OBJECT_CLASS (eee_pref_dialog_parent_class)->constructor (type, n, construct_properties);
}

GtkWidget *
eee_pref_dialog_new (void)
{
  return g_object_new (EEE_TYPE_PREF_DIALOG, NULL);
}

