/*
 * Eee Applet 
 * Copyright (C) 2008 Olivier Rolland <billl@users.sourceforge.net>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __EEE_MONITOR_H__
#define __EEE_MONITOR_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define EEE_TYPE_MONITOR            (eee_monitor_get_type ())
#define EEE_MONITOR(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), EEE_TYPE_MONITOR, EeeMonitor))
#define EEE_MONITOR_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), EEE_TYPE_MONITOR, EeeMonitorClass))
#define EEE_IS_MONITOR(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EEE_TYPE_MONITOR))
#define EEE_IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EEE_TYPE_MONITOR))
#define EEE_MONITOR_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), EEE_TYPE_MONITOR, EeeMonitorClass))

typedef struct _EeeMonitor        EeeMonitor;
typedef struct _EeeMonitorClass   EeeMonitorClass;

struct _EeeMonitor
{
  GObject parent;
};

struct _EeeMonitorClass
{
  GObjectClass parent_class;

  gboolean  (* run)     (EeeMonitor *monitor);

  /*< signals >*/
  void      (* changed) (EeeMonitor *monitor);
};

GType    eee_monitor_get_type (void) G_GNUC_CONST;

gboolean eee_monitor_run      (EeeMonitor *monitor);

G_END_DECLS

#endif /* __EEE_MONITOR_H__ */

