/*
 * Decompiled with CFR 0.152.
 */
package dumphd.core;

import dumphd.core.KeyData;
import dumphd.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class KeyDataFile {
    private static final int LINEBUFFER_SIZE = 16384;
    private static final Pattern linePattern = Pattern.compile("(.*)\r?\n");
    private static final String dataIdPatternString = "\\|[ \\t]*([DMIBVPTU])[ \\t]*";
    private static final String dPatternString = "\\|[ \\t]*(?:(([0-9]{4})[ \\t]*-[ \\t]*([0-9]{2})[ \\t]*-[ \\t]*([0-9]{2}))|(([0-9M]{2})[ \\t]*/[ \\t]*([0-9D]{2})[ \\t]*/[ \\t]*([0-9Y]{2})))[ \\t]*";
    private static final String ivPatternString = "\\|[ \\t]*([0-9ABCDEF]{32})[ \\t]*";
    private static final String tuPatternString = "\\|[ \\t]*([0-9]{1,5})[ \\t]*-[ \\t]*([0-9ABCDEF]{32})[ \\t]*";
    private static final Pattern datasetIdPattern = Pattern.compile("[ \\t]*([0-9ABCDEF]{40})[ \\t]*=[ \\t]*([^|]*)\\|[ \\t]*([DMIBVPTU])[ \\t]*(\\|[ \\t]*(?:(([0-9]{4})[ \\t]*-[ \\t]*([0-9]{2})[ \\t]*-[ \\t]*([0-9]{2}))|(([0-9M]{2})[ \\t]*/[ \\t]*([0-9D]{2})[ \\t]*/[ \\t]*([0-9Y]{2})))[ \\t]*)?", 66);
    private static final Pattern dataIdPattern = Pattern.compile("(?:;(.*))|(?:\\|[ \\t]*([DMIBVPTU])[ \\t]*)", 66);
    private static final Pattern dataPattern = Pattern.compile("(?:\\|[ \\t]*(?:(([0-9]{4})[ \\t]*-[ \\t]*([0-9]{2})[ \\t]*-[ \\t]*([0-9]{2}))|(([0-9M]{2})[ \\t]*/[ \\t]*([0-9D]{2})[ \\t]*/[ \\t]*([0-9Y]{2})))[ \\t]*)|(?:\\|[ \\t]*([0-9ABCDEF]{32})[ \\t]*)|(?:\\|[ \\t]*([0-9]{1,5})[ \\t]*-[ \\t]*([0-9ABCDEF]{32})[ \\t]*)", 66);
    private RandomAccessFile raf = null;
    private FileChannel fc = null;
    private ByteBuffer bb = null;
    private ByteBuffer bbh = null;
    private CharBuffer cb = null;
    private CharsetDecoder decoder = null;
    private CharsetEncoder encoder = null;

    public KeyDataFile(File src) throws IOException {
        this.raf = new RandomAccessFile(src, "rw");
        this.fc = this.raf.getChannel();
        this.bb = ByteBuffer.allocateDirect(16384);
        this.bbh = ByteBuffer.allocate(16384);
        this.cb = CharBuffer.allocate(16384);
        this.decoder = Charset.forName("UTF-8").newDecoder();
        this.encoder = Charset.forName("UTF-8").newEncoder();
    }

    public int getSmartMode(KeyData kd) {
        int mode = 0;
        mode |= 2;
        mode |= 4;
        mode |= 0x100;
        mode = kd.getVuk() != null || kd.pakCount() > 0 ? (mode |= 0x20) : (kd.getMek() != null && (kd.getVid() != null || kd.bnCount() > 0) ? (mode |= 0x18) : (mode |= 0x40));
        return mode;
    }

    public String buildEntry(KeyData kd, boolean bluRay, boolean recordable, int mode) {
        String comment;
        StringBuffer sb = new StringBuffer(8192);
        byte[] temp = kd.getDiscId();
        sb.append(Utils.toHexString(temp, 0, temp.length));
        sb.append(" = ");
        String title = null;
        if ((mode & 2) != 0 && (title = kd.getTitle()) != null) {
            title = title.replaceAll("(?:\\|)|(?:\r?\n)", "");
            title = title.trim();
        }
        if (title == null) {
            title = "";
        }
        if (title.length() < 48) {
            title = String.format("%1$-48s", title);
        }
        sb.append(title);
        if ((mode & 4) != 0) {
            sb.append(" | D | ");
            Date date = kd.getDate();
            if (date != null) {
                sb.append(String.format("%1$tY-%1$tm-%1$td", date));
            } else {
                sb.append("0000-00-00");
            }
        }
        if ((mode & 8) != 0 && (temp = kd.getMek()) != null) {
            sb.append(" | M | ");
            sb.append(Utils.toHexString(temp, 0, temp.length));
        }
        if ((mode & 0x10) != 0) {
            if (recordable) {
                if (kd.bnCount() > 0) {
                    sb.append(" | B");
                    for (int bnIndex : kd.bnIdx()) {
                        temp = kd.getBn(bnIndex);
                        sb.append(" | ");
                        sb.append(bnIndex);
                        sb.append("-");
                        sb.append(Utils.toHexString(temp, 0, temp.length));
                    }
                }
            } else {
                temp = kd.getVid();
                if (temp != null) {
                    sb.append(" | I | ");
                    sb.append(Utils.toHexString(temp, 0, temp.length));
                }
            }
        }
        if ((mode & 0x20) != 0) {
            if (recordable) {
                if (kd.pakCount() > 0) {
                    sb.append(" | P");
                    for (int pakIndex : kd.pakIdx()) {
                        temp = kd.getPak(pakIndex);
                        sb.append(" | ");
                        sb.append(pakIndex);
                        sb.append("-");
                        sb.append(Utils.toHexString(temp, 0, temp.length));
                    }
                }
            } else {
                temp = kd.getVuk();
                if (temp != null) {
                    sb.append(" | V | ");
                    sb.append(Utils.toHexString(temp, 0, temp.length));
                }
            }
        }
        if ((mode & 0x40) != 0 && kd.tukCount() > 0) {
            if (bluRay) {
                sb.append(" | U");
            } else {
                sb.append(" | T");
            }
            for (int tukIndex : kd.tukIdx()) {
                temp = kd.getTuk(tukIndex);
                sb.append(" | ");
                sb.append(tukIndex);
                sb.append("-");
                sb.append(Utils.toHexString(temp, 0, temp.length));
            }
        }
        if ((mode & 0x100) != 0 && (comment = kd.getComment()) != null) {
            sb.append(" ;");
            sb.append(comment);
        }
        sb.append("\r\n");
        return sb.toString();
    }

    public KeyData getKeyData(byte[] discId, int offset) throws IOException {
        return this.getSetKeyData(discId, offset, null, false, false, false, 0);
    }

    public KeyData setKeyData(KeyData kd, boolean bluRay, boolean recordable, boolean keepDataTypes) throws IOException {
        return this.getSetKeyData(kd.getDiscId(), 0, kd, bluRay, recordable, keepDataTypes, this.getSmartMode(kd));
    }

    public KeyData setKeyData(KeyData kd, boolean bluRay, boolean recordable, boolean keepDataTypes, int mode) throws IOException {
        return this.getSetKeyData(kd.getDiscId(), 0, kd, bluRay, recordable, keepDataTypes, mode);
    }

    public KeyData appendKeyData(KeyData kd, boolean bluRay, boolean recordable) throws IOException {
        return this.appendKeyDataImpl(kd, bluRay, recordable, this.getSmartMode(kd));
    }

    public KeyData appendKeyData(KeyData kd, boolean bluRay, boolean recordable, int mode) throws IOException {
        return this.appendKeyDataImpl(kd, bluRay, recordable, mode);
    }

    public void close() throws IOException {
        this.raf.close();
    }

    private KeyData appendKeyDataImpl(KeyData kd, boolean bluRay, boolean recordable, int mode) throws IOException {
        this.cb.clear();
        try {
            this.cb.put(this.buildEntry(kd, bluRay, recordable, mode));
        }
        catch (BufferOverflowException e) {
            Utils.getMessagePrinter().println("Keyentry exceeds linebuffer size");
            return null;
        }
        this.cb.flip();
        this.fc.position(this.fc.size());
        this.writeCb();
        this.fc.force(true);
        return kd;
    }

    /*
     * Unable to fully structure code
     */
    private KeyData getSetKeyData(byte[] discId, int offset, KeyData replacement, boolean bluRay, boolean recordable, boolean keepDataTypes, int mode) throws IOException {
        bufferOffset = 0L;
        bufferBytes = 0L;
        eofReached = false;
        eofProcessed = false;
        flushed = false;
        coderResult = null;
        lineMatcher = KeyDataFile.linePattern.matcher(this.cb);
        datasetIdMatcher = KeyDataFile.datasetIdPattern.matcher(this.cb);
        dataIdMatcher = KeyDataFile.dataIdPattern.matcher(this.cb);
        dataMatcher = KeyDataFile.dataPattern.matcher(this.cb);
        lineCounter = 0;
        lineStart = -1;
        lineEnd = 0;
        ignoreNextLine = false;
        positionBackup = 0;
        limitBackup = 0;
        date = null;
        dateParser = new SimpleDateFormat("yyyyMMdd");
        dateParser.setLenient(false);
        temp = new byte[20];
        this.decoder.reset();
        this.bb.clear();
        this.cb.clear();
        this.fc.position(0L);
        ** GOTO lbl390
        {
            block90: {
                if (this.fc.read(this.bb) != -1) break block90;
                eofReached = true;
                ** GOTO lbl36
            }
            do {
                if (!eofReached && this.bb.hasRemaining()) continue block6;
lbl36:
                // 2 sources

                this.bb.flip();
                if (eofReached) {
                    if (!eofProcessed && (coderResult = this.decoder.decode(this.bb, this.cb, true)).isUnderflow()) {
                        eofProcessed = true;
                    }
                    if (eofProcessed && (coderResult = this.decoder.flush(this.cb)).isUnderflow()) {
                        flushed = true;
                    }
                } else {
                    coderResult = this.decoder.decode(this.bb, this.cb, false);
                }
                if (coderResult.isError()) {
                    coderResult.throwException();
                }
                bufferBytes += (long)this.bb.position();
                this.cb.flip();
                lineStart = -1;
                lineEnd = 0;
                lineMatcher.reset();
                positionBackup = this.cb.position();
                limitBackup = this.cb.limit();
                while (lineMatcher.find()) {
                    block89: {
                        ++lineCounter;
                        lineStart = lineMatcher.start();
                        lineEnd = lineMatcher.end();
                        lineContentEnd = lineMatcher.end(1);
                        if (ignoreNextLine) {
                            ignoreNextLine = false;
                            continue;
                        }
                        if (this.cb.charAt(lineStart) == ';' || lineStart == lineContentEnd) continue;
                        this.cb.limit(lineContentEnd);
                        this.cb.position(lineStart);
                        lineContentEnd -= lineStart;
                        datasetIdMatcher.reset();
                        dataIdMatcher.reset();
                        dataMatcher.reset();
                        if (datasetIdMatcher.lookingAt()) {
                            Utils.decodeHexString(datasetIdMatcher.group(1), temp, 0);
                            discIdMatch = true;
                            i = 0;
                            while (i < 20) {
                                if (temp[i] != discId[offset + i]) {
                                    discIdMatch = false;
                                    break;
                                }
                                ++i;
                            }
                            if (discIdMatch) {
                                kd = new KeyData(discId, offset);
                                kd.setTitle(datasetIdMatcher.group(2).trim());
                                currentDataId = datasetIdMatcher.group(3).toUpperCase();
                                if (datasetIdMatcher.group(4) != null) {
                                    if (!currentDataId.equals("D")) {
                                        date = null;
                                        try {
                                            date = datasetIdMatcher.group(5) != null ? dateParser.parse(String.valueOf(datasetIdMatcher.group(6)) + datasetIdMatcher.group(7) + datasetIdMatcher.group(8)) : dateParser.parse("20" + datasetIdMatcher.group(12) + datasetIdMatcher.group(10) + datasetIdMatcher.group(11));
                                        }
                                        catch (ParseException var33_33) {
                                            // empty catch block
                                        }
                                        if (date != null) {
                                            kd.setDate(date);
                                        }
                                        dataMatcher.region(datasetIdMatcher.end(), lineContentEnd);
                                    } else {
                                        dataMatcher.region(datasetIdMatcher.start(4), lineContentEnd);
                                    }
                                } else {
                                    dataMatcher.region(datasetIdMatcher.end(), lineContentEnd);
                                }
                                while (dataMatcher.lookingAt()) {
                                    dataEnd = dataMatcher.end();
                                    if (currentDataId.equals("D")) {
                                        date = null;
                                        try {
                                            if (dataMatcher.group(1) != null) {
                                                date = dateParser.parse(String.valueOf(dataMatcher.group(2)) + dataMatcher.group(3) + dataMatcher.group(4));
                                            } else if (dataMatcher.group(5) != null) {
                                                date = dateParser.parse("20" + dataMatcher.group(8) + dataMatcher.group(6) + dataMatcher.group(7));
                                            } else {
                                                Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.start() + 1) + ": Invalid DATE data");
                                                kd = null;
                                            }
                                        }
                                        catch (ParseException var34_36) {
                                            // empty catch block
                                        }
                                        if (date != null) {
                                            kd.setDate(date);
                                        }
                                    } else if (currentDataId.equals("M")) {
                                        if (dataMatcher.group(9) != null) {
                                            Utils.decodeHexString(dataMatcher.group(9), temp, 0);
                                            kd.setMek(temp, 0);
                                        } else {
                                            Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.start() + 1) + ": Invalid MEK data");
                                            kd = null;
                                        }
                                    } else if (currentDataId.equals("I")) {
                                        if (dataMatcher.group(9) != null) {
                                            Utils.decodeHexString(dataMatcher.group(9), temp, 0);
                                            kd.setVid(temp, 0);
                                        } else {
                                            Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.start() + 1) + ": Invalid VID data");
                                            kd = null;
                                        }
                                    } else if (currentDataId.equals("B")) {
                                        do {
                                            dataEnd = dataMatcher.end();
                                            if (dataMatcher.group(10) != null) {
                                                keyNumber = Integer.parseInt(dataMatcher.group(10));
                                                if (keyNumber < 0) {
                                                    Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.start(10) + 1) + ": Invalid BN number");
                                                    kd = null;
                                                    break;
                                                }
                                                Utils.decodeHexString(dataMatcher.group(11), temp, 0);
                                                kd.setBn(keyNumber, temp, 0);
                                            } else {
                                                Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.start() + 1) + ": Invalid BN data");
                                                kd = null;
                                                break;
                                            }
                                            dataMatcher.region(dataMatcher.end(), lineContentEnd);
                                        } while (dataMatcher.lookingAt());
                                    } else if (currentDataId.equals("V")) {
                                        if (dataMatcher.group(9) != null) {
                                            Utils.decodeHexString(dataMatcher.group(9), temp, 0);
                                            kd.setVuk(temp, 0);
                                        } else {
                                            Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.start() + 1) + ": Invalid VUK data");
                                            kd = null;
                                        }
                                    } else if (currentDataId.equals("P")) {
                                        do {
                                            dataEnd = dataMatcher.end();
                                            if (dataMatcher.group(10) != null) {
                                                keyNumber = Integer.parseInt(dataMatcher.group(10));
                                                if (keyNumber < 0) {
                                                    Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.start(10) + 1) + ": Invalid PAK number");
                                                    kd = null;
                                                    break;
                                                }
                                                Utils.decodeHexString(dataMatcher.group(11), temp, 0);
                                                kd.setPak(keyNumber, temp, 0);
                                            } else {
                                                Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.start() + 1) + ": Invalid PAK data");
                                                kd = null;
                                                break;
                                            }
                                            dataMatcher.region(dataMatcher.end(), lineContentEnd);
                                        } while (dataMatcher.lookingAt());
                                    } else if (currentDataId.equals("T")) {
                                        do {
                                            dataEnd = dataMatcher.end();
                                            if (dataMatcher.group(10) != null) {
                                                keyNumber = Integer.parseInt(dataMatcher.group(10));
                                                if (keyNumber <= 0) {
                                                    Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.start(10) + 1) + ": Invalid TK number");
                                                    kd = null;
                                                    break;
                                                }
                                                Utils.decodeHexString(dataMatcher.group(11), temp, 0);
                                                kd.setTuk(keyNumber, temp, 0);
                                            } else {
                                                Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.start() + 1) + ": Invalid TK data");
                                                kd = null;
                                                break;
                                            }
                                            dataMatcher.region(dataMatcher.end(), lineContentEnd);
                                        } while (dataMatcher.lookingAt());
                                    } else if (currentDataId.equals("U")) {
                                        do {
                                            dataEnd = dataMatcher.end();
                                            if (dataMatcher.group(10) != null) {
                                                keyNumber = Integer.parseInt(dataMatcher.group(10));
                                                if (keyNumber <= 0) {
                                                    Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.start(10) + 1) + ": Invalid UK number");
                                                    kd = null;
                                                    break;
                                                }
                                                Utils.decodeHexString(dataMatcher.group(11), temp, 0);
                                                kd.setTuk(keyNumber, temp, 0);
                                            } else {
                                                Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.start() + 1) + ": Invalid UK data");
                                                kd = null;
                                                break;
                                            }
                                            dataMatcher.region(dataMatcher.end(), lineContentEnd);
                                        } while (dataMatcher.lookingAt());
                                    }
                                    if (kd == null) break block89;
                                    if (dataEnd != lineContentEnd) {
                                        dataIdMatcher.region(dataEnd, lineContentEnd);
                                        if (dataIdMatcher.lookingAt()) {
                                            comment = dataIdMatcher.group(1);
                                            if (comment == null) {
                                                currentDataId = dataIdMatcher.group(2).toUpperCase();
                                                dataMatcher.region(dataIdMatcher.end(), lineContentEnd);
                                                continue;
                                            }
                                            kd.setComment(comment);
                                        } else {
                                            Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataIdMatcher.regionStart() + 1) + ": Invalid ENTRY ID");
                                            kd = null;
                                            break block89;
                                        }
                                    }
                                    if (replacement != null) {
                                        this.cb.position(0);
                                        this.cb.limit(lineStart);
                                        writeOffset = bufferOffset + (long)this.getRemainingCbBytes();
                                        this.cb.position(lineStart);
                                        this.cb.limit(lineEnd);
                                        entrySize = this.getRemainingCbBytes();
                                        if (keepDataTypes) {
                                            mode |= kd.dataMask();
                                        }
                                        this.cb.position(0);
                                        this.cb.limit(this.cb.capacity());
                                        try {
                                            this.cb.put(this.buildEntry(replacement, bluRay, recordable, mode));
                                        }
                                        catch (BufferOverflowException e) {
                                            Utils.getMessagePrinter().println("Keyentry exceeds linebuffer size");
                                            return null;
                                        }
                                        this.cb.flip();
                                        replacementSize = this.getRemainingCbBytes();
                                        this.cb.position(0);
                                        if (replacementSize == entrySize) {
                                            this.fc.position(writeOffset);
                                            this.writeCb();
                                        } else if (replacementSize < entrySize) {
                                            this.fc.position(writeOffset);
                                            this.writeCb();
                                            readPos = writeOffset + (long)entrySize;
                                            writePos = this.fc.position();
                                            this.fc.position(readPos);
                                            this.bb.clear();
                                            while (this.fc.read(this.bb) != -1) {
                                                readPos = this.fc.position();
                                                this.bb.flip();
                                                this.fc.position(writePos);
                                                this.fc.write(this.bb);
                                                writePos = this.fc.position();
                                                this.bb.compact();
                                                this.fc.position(readPos);
                                            }
                                            this.fc.truncate(writePos);
                                        } else {
                                            this.bb.clear();
                                            fileSize = this.fc.size();
                                            entryEnd = writeOffset + (long)entrySize;
                                            if (fileSize < entryEnd) {
                                                Utils.getMessagePrinter().println("Fatal error: Key database has been illegally truncated from outside beyond the entry to update");
                                                return null;
                                            }
                                            readPos = fileSize - (long)this.bb.capacity();
                                            if (readPos < entryEnd) {
                                                this.bb.limit(this.bb.capacity() - (int)(entryEnd - readPos));
                                                readPos = entryEnd;
                                            }
                                            writePos = fileSize + (long)(replacementSize - entrySize) - (long)this.bb.limit();
                                            while (this.bb.limit() > 0) {
                                                this.fc.position(readPos);
                                                while (this.bb.hasRemaining()) {
                                                    this.fc.read(this.bb);
                                                }
                                                this.bb.flip();
                                                this.fc.position(writePos);
                                                while (this.bb.hasRemaining()) {
                                                    this.fc.write(this.bb);
                                                }
                                                this.bb.clear();
                                                if ((readPos -= (long)this.bb.capacity()) < entryEnd) {
                                                    this.bb.limit(this.bb.capacity() - (int)(entryEnd - readPos));
                                                    readPos = entryEnd;
                                                }
                                                writePos -= (long)this.bb.limit();
                                            }
                                            this.fc.position(writeOffset);
                                            this.writeCb();
                                        }
                                        this.fc.force(true);
                                        return kd;
                                    }
                                    return kd;
                                }
                                Utils.getMessagePrinter().println("Error at line " + lineCounter + ", position " + (dataMatcher.regionStart() + 1) + ": Invalid ENTRY DATA");
                                kd = null;
                            }
                        } else {
                            Utils.getMessagePrinter().println("Error at line " + lineCounter + ": Line is not a key entry");
                        }
                    }
                    this.cb.position(positionBackup);
                    this.cb.limit(limitBackup);
                }
                if (!flushed) {
                    if (lineStart == -1) {
                        if (this.cb.limit() == this.cb.capacity()) {
                            Utils.getMessagePrinter().println("Error at line " + (lineCounter + 1) + ": Linebuffer overflow, ignoring line");
                            bufferOffset += bufferBytes;
                            bufferBytes = 0L;
                            this.cb.clear();
                            this.bb.compact();
                            ignoreNextLine = true;
                            continue;
                        }
                        this.cb.position(this.cb.limit());
                        this.cb.limit(this.cb.capacity());
                        this.bb.compact();
                        continue;
                    }
                    this.cb.position(lineEnd);
                    remainingBytes = this.getRemainingCbBytes();
                    this.cb.position(lineEnd);
                    bufferOffset += bufferBytes - remainingBytes;
                    bufferBytes = remainingBytes;
                    this.cb.compact();
                    this.bb.compact();
                    continue;
                }
                if (lineEnd == this.cb.limit()) continue;
                Utils.getMessagePrinter().println("Error behind line " + lineCounter + ": Invalid data at end");
lbl390:
                // 6 sources

            } while (!flushed);
        }
        return null;
    }

    private int getRemainingCbBytes() throws IOException {
        int encodedSize = 0;
        boolean encoded = false;
        boolean flushed = false;
        CoderResult coderResult = null;
        this.encoder.reset();
        this.bbh.clear();
        while (!flushed) {
            if (!encoded) {
                coderResult = this.encoder.encode(this.cb, this.bbh, true);
                if (coderResult.isUnderflow()) {
                    encoded = true;
                }
            } else {
                coderResult = this.encoder.flush(this.bbh);
                if (coderResult.isUnderflow()) {
                    flushed = true;
                }
            }
            if (coderResult.isError()) {
                coderResult.throwException();
            }
            encodedSize += this.bbh.position();
            this.bbh.clear();
        }
        return encodedSize;
    }

    private void writeCb() throws IOException {
        boolean encoded = false;
        boolean flushed = false;
        CoderResult coderResult = null;
        this.encoder.reset();
        this.bb.clear();
        while (!flushed) {
            if (!encoded) {
                coderResult = this.encoder.encode(this.cb, this.bb, true);
                if (coderResult.isUnderflow()) {
                    encoded = true;
                }
            } else {
                coderResult = this.encoder.flush(this.bb);
                if (coderResult.isUnderflow()) {
                    flushed = true;
                }
            }
            if (coderResult.isError()) {
                coderResult.throwException();
            }
            this.bb.flip();
            while (this.bb.hasRemaining()) {
                this.fc.write(this.bb);
            }
            this.bb.clear();
        }
    }
}

