<?php

function drawAdminTools_AdminStats($admin){
	global $adm_login;
	global $conf_mysql_db;
	global $pro_mysql_domain_table;
	global $pro_mysql_acc_http_table;
	global $pro_mysql_acc_ftp_table;

	global $lang;

	global $txt_total_transfered_bytes_this_month;
	global $txt_total_trafic;
	global $txt_disk_usage;
	global $txt_domain_name;
	global $txt_domain_name_trafic_du;
	global $txt_disk_usage;
	global $txt_database_name;
	global $txt_databases_disk_usage;
	global $txt_total_disk_usage;
	global $txt_database_files;
	global $txt_domain_name_files;
	global $txt_are_disk_usage;
	global $txt_total_transfered_bytes_this_month;

	$out = "";
	$nowrap = " style=\"white-space:nowrap\" nowrap";

	$stats = fetchAdminStats($admin);
// ["domains"][]["name"]
//              ["du"]
//              ["ftp"]
//              ["http"]
//              ["smtp"]
//              ["pop"]
//              ["total_transfer"]
// ["total_http"]
// ["total_ftp"]
// ["total_email"]
// ["total_transfer"]
// ["total_du_domains"]
// ["db"][]["name"]
//         ["du"]
// ["total_db_du"]
// ["total_du"]
	$id_client = $admin["info"]["id_client"];

	// Print the transfer overall total for this month
	$out .= "<h3>".$txt_total_transfered_bytes_this_month[$lang]."</h3>";
	if (!isset($stats["total_http"]))
	{
		$stats["total_http"] = 0;
	}
	$out .= "<br>HTTP: ".smartByte($stats["total_http"])." ".$stats["total_hit"]." hits";
	if (!isset($stats["total_ftp"]))
	{
		$stats["total_ftp"] = 0;
	}
	$out .= "<br>FTP: ".smartByte($stats["total_ftp"]);
	if (!isset($stats["total_email"]))
	{
		$stats["total_email"] = 0;
	}
	$out .= "<br>Email: ".smartByte($stats["total_email"]);
	if (!isset($stats["total_transfer"]))
	{
		$stats["total_transfer"] = 0;
	}
	$out .= "<br>Total: ". smartByte($stats["total_transfer"]);

	if($id_client != 0){
		$bw_quota = $admin["info"]["bandwidth_per_month_mb"]*1024*1024;
		$out .= " / ".smartByte($bw_quota)."<br>";
		$out .= drawPercentBar($stats["total_transfer"],$bw_quota);
	}

	// Print disk usage
	$out .= "<br><h3>".$txt_are_disk_usage[$lang]."</h3>";
	if (!isset($stats["total_du_domains"]))
	{
		$stats["total_du_domains"] = 0;
	}
	$out .= "<br>".$txt_domain_name_files[$lang]." ".smartByte($stats["total_du_domains"]);
	if(isset($stats["total_du_db"])){
		$out .= "<br>".$txt_database_files[$lang]." ".smartByte($stats["total_du_db"]);
	}else{
		$out .= "<br>".$txt_database_files[$lang]." ".smartByte(0);
	}
	$out .= "<br>".$txt_total_disk_usage[$lang]." ".smartByte($stats["total_du"]);

	if($id_client != 0){
		$du_quota = $admin["info"]["quota"]*1024*1024;
		$out .= " / ".smartByte($du_quota)."<br>";
		$out .= drawPercentBar($stats["total_du"],$du_quota);
	}

	$out .= "<br><br><h3>".$txt_databases_disk_usage[$lang]."</h3>";
	$out .= '<br><table border="1" width="100%" height="1" cellpadding="0" cellspacing="1">';
	$out .= "<tr><td$nowrap><b>".$txt_database_name[$lang]."</b></td><td$nowrap><b>".$txt_disk_usage[$lang]."</b></tr>";
	if(isset($stats["db"])){
		$n = sizeof($stats["db"]);
	}else{
		$n = 0;
	}
	for($i=0;$i<$n;$i++){
		if($i % 2){
			$bgcolor = "$nowrap nowrap bgcolor=\"#000000\" style=\"color:#FFFFFF\" ";
		}else{
			$bgcolor = $nowrap;
		}
		$out .= "<tr>";
		$out .= "<td$bgcolor>".$stats["db"][$i]["name"]."</td>";
		$out .= "<td$bgcolor>".smartByte($stats["db"][$i]["du"])."</td>";
		$out .= "</tr>";
	}
	$out .= '</table>';

	$out .= "<br><br><h3>".$txt_domain_name_trafic_du[$lang]."</h3>";
	$out .= '<br><table border="1" width="100%" height="1" cellpadding="0" cellspacing="1">';
	$out .= "<tr><td><b>".$txt_domain_name[$lang]."</b></td><td$nowrap><b>".$txt_disk_usage[$lang]."</b></td>
	<td><b>POP3</b></td><td><b>IMAP</b></td><td><b>SMTP</b></td><td><b>FTP</b></td><td><b>HTTP</b></td>
	<td$nowrap><b>HTTP HITS</b></td>
	<td$nowrap><b>".$txt_total_trafic[$lang]."</b></td></tr>";
	if (isset($stats["domains"]))
	{
		for($ad=0;$ad<sizeof($stats["domains"]);$ad++){
			if($ad % 2){
				$bgcolor = "$nowrap nowrap bgcolor=\"#000000\" ";
				$fnt1 = "<font color=\"#FFFFFF\">";
				$fnt2 = "</font>";
			}else{
				$bgcolor = $nowrap;
				$fnt1 = "";
				$fnt2 = "";
			}
			$out .= "<tr>";
			$out .= "<td$bgcolor>$fnt1".$stats["domains"][$ad]["name"]."$fnt2</td>";
			$out .= "<td$bgcolor>$fnt1".smartByte($stats["domains"][$ad]["du"])."$fnt2</td>";
			$out .= "<td$bgcolor>$fnt1".smartByte($stats["domains"][$ad]["pop"])."$fnt2</td>";
			$out .= "<td$bgcolor>$fnt1".smartByte($stats["domains"][$ad]["imap"])."$fnt2</td>";
			$out .= "<td$bgcolor>$fnt1".smartByte($stats["domains"][$ad]["smtp"])."$fnt2</td>";
			$out .= "<td$bgcolor>$fnt1".smartByte($stats["domains"][$ad]["ftp"])."$fnt2</td>";
			$out .= "<td$bgcolor>$fnt1".smartByte($stats["domains"][$ad]["http"])."$fnt2</td>";
			$out .= "<td$bgcolor>$fnt1".$stats["domains"][$ad]["hit"]."$fnt2</td>";
			$out .= "<td$bgcolor>$fnt1".smartByte($stats["domains"][$ad]["total_transfer"])."$fnt2</td>";
			$out .= "</tr>";
		}
	}
	$out .= '</table>';
	return $out;
}

?>
