"""This module defines Python-specific global parameters for DOLFIN by
adding to the global parameter set defined in C++."""

__author__ = "Anders Logg (logg@simula.no)"
__date__ = "2009-09-21"
__copyright__ = "Copyright (C) 2009-2010 " + __author__
__license__  = "GNU LGPL Version 2.1"

# Last changed: 2010-02-01

__all__ = ["parameters"]

import ufl
from dolfin.cpp import parameters, Parameters, MPI

# Set default form compiler
form_compiler_name = "ffc"

# Import form compiler
try:
    form_compiler = __import__(form_compiler_name)
except ImportError, message:
    print message
    raise RuntimeError, "Could not import %s form compiler." % form_compiler_name

# Initialize form compiler parameters
form_compiler_parameters = Parameters("form_compiler")
for key, value in form_compiler.default_parameters().iteritems():
    form_compiler_parameters.add(key, value)
form_compiler_parameters.add("name", form_compiler_name)

# Increase log level for form compiler to hide output
form_compiler_parameters["log_level"] = ufl.INFO + 5

# Set prefix when running in parallel
if MPI.num_processes() > 1:
    form_compiler_parameters["log_prefix"] = "Process %d: " % MPI.process_number()

# Add form compiler parameters to global parameter set
parameters.add(form_compiler_parameters)
