"This module provides uniform and local mesh refinement."

__author__ = "Anders Logg (logg@simula.no)"
__date__ = "2010-02-26"
__copyright__ = "Copyright (C) 2009 Anders Logg"
__license__  = "GNU LGPL Version 2.1"

__all__ = ["refine"]

# Import C++ interface
import dolfin.cpp as cpp

def refine(mesh, cell_markers=None):
    """Refine given mesh and return the refined mesh. An optional
    argument (a boolean MeshFunction over cells) may be given to
    specify which cells should be refined. If no cell markers are
    given, then the mesh is refined uniformly."""

    # This function is necessary to avoid copying in the wrapped
    # versions of the return-by-value refine functions in C++.

    # Create empty mesh
    refined_mesh = cpp.Mesh()

    # Call C++ refinement
    if cell_markers is None:
        cpp.refine(refined_mesh, mesh)
    else:
        cpp.refine(refined_mesh, mesh, cell_markers)

    return refined_mesh
