/*   mp3db.h -- header file for mp3db.c
 *
 * Copyright (c) 1998-2002  Mike Oliphant <oliphant@gtk.org>
 *
 *   http://www.nostatic.org/grip
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software

 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <mysql.h>
#include <glib.h>

MYSQL *ConnectSQL(void);
void DisconnectSQL(MYSQL *mysql);
gboolean SQLQuery(MYSQL *mysql,char *query);
gboolean SingleIntQuery(MYSQL *mysql,char *query,int *result);
gboolean GetDBInfo(MYSQL *mysql,int *db_version);
gboolean ExecuteDBSchema(char *schemafile,MYSQL *mysql,char *rootpswd);
gboolean ReloadSQL(MYSQL *mysql,char *rootpswd);
gboolean MakeSQLUser(MYSQL *mysql,char *user,char *host,char *pswd,
		     char *rootpswd);
gboolean DeleteSQLUser(MYSQL *mysql,char *user,char *host,char *rootpswd);
void EscapeQuote(char *in,char *out,int maxlen);
int AddSQLArtist(MYSQL *mysql,char *artist);
int AddSQLDisc(MYSQL *mysql,char *disc,int artistid,char *genre,int year);
int AddSQLEntry(MYSQL *mysql,
		char *filename,char *artist,char *sartist,char *title,
		char *disc_name,char *genre,int year,
		int track_num,int start_frame,int num_frames,int mins,
		int secs,int bpm,int gain);
gboolean DeleteSongByID(MYSQL *mysql,int id);
int DBNum(char *str);
void DBString(char *dest,char *src,int len);
