/* Shamelessly stolen from the gnome mixer applet, who shamelessly stole
   it from others. Go open source, go! */

#include <glib.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include "mixer.h"

gint OpenMixer(gchar *device_name) 
{
  gint res,ver;
  gint mixerfd;

#ifdef OSS_API
  mixerfd=open(device_name,O_RDWR,0);
#endif
#ifdef SUN_API
  mixerfd=open(device_name,AUDIO_GETINFO,O_WRONLY);
#endif

  if(mixerfd<0) {
    return -1;
  }
  
  /* check driver-version */
#ifdef OSS_GETVERSION
  res=ioctl(mixerfd,OSS_GETVERSION,&ver);
  if((res==0) && (ver!=SOUND_VERSION)) {
    printf("warning: this software was compiled "
	   "with a different version of\nsoundcard.h.\n");
  }
#endif

  return mixerfd;
}

/* only works with master vol currently */
gint ReadMixer(int mixerfd)
{
  gint vol, r, l;
#ifdef SUN_API
  audio_info_t ainfo;
#endif

#ifdef OSS_API
  /* if we couldn't open the mixer */
  if(mixerfd<0) return 0;
  
  ioctl(mixerfd,MIXER_READ(SOUND_MIXER_VOLUME),&vol);
  
  l=vol & 0xff;
  r=(vol & 0xff00) >> 8;
  
  return (r+l)/2;
#endif
#ifdef SUN_API
  AUDIO_INITINFO(&ainfo);	
  ioctl(mixerfd,AUDIO_GETINFO,&ainfo);

  return(ainfo.play.gain);
#endif
}

gboolean SetMixer(gint mixerfd,gint vol)
{
  gint tvol;
#ifdef SUN_API
  audio_info_t ainfo;
#endif

  if(vol>VOLUME_MAX) return FALSE;
  if(vol<0) return FALSE;

  /* if we couldn't open the mixer */
  if(mixerfd<0) return FALSE;

#ifdef OSS_API
  
  tvol=(vol << 8) + vol;

  ioctl(mixerfd,MIXER_WRITE(SOUND_MIXER_VOLUME),&tvol);
#endif
#ifdef SUN_API
  AUDIO_INITINFO(&ainfo);
  ainfo.play.gain=vol;
  ioctl(mixerfd,AUDIO_SETINFO,&ainfo);
#endif

  return TRUE;
}

void CloseMixer(gint mixerfd)
{
  close(mixerfd);
}
