#!/bin/sh
#
# $Id: mklink.sh,v 1.1 2010-07-23 15:57:57-07 bll Exp $
#
# Copyright 2010 Brad Lanam Walnut Creek, CA USA
#

# this is a workaround for ksh93 on solaris
if [ "$1" = "-d" ]; then
  cd $2
  shift
  shift
fi
mypath=`echo $0 | sed -e 's,/[^/]*$,,'`
_MKCONFIG_DIR=`(cd $mypath;pwd)`
export _MKCONFIG_DIR
. ${_MKCONFIG_DIR}/shellfuncs.sh

doshelltest $0 $@
setechovars

doecho=F
if [ "$1" = "-e" ]; then
  doecho=T
  shift
fi
outfile=$1
shift

objects=""
libs=""
libpath=""
islib=0
ispath=0

grc=0
for f in $@; do
  case $f in
    "-L")
      ispath=1
      ;;
    "-L"*)
      tf=$f
      dosubst tf '-L' ''
      if [ ! -d "$tf" ]; then
        echo "## unable to locate dir $tf"
        grc=1
      else
        doappend libpath ":$tf"
      fi
      ;;
    "-l")
      islib=1
      ;;
    "-l"*)
      tf=$f
      dosubst tf '-l' ''
      doappend libs " -l$tf"
      ;;
    *${OBJ_EXT})
      if [ ! -f "$f" ]; then
        echo "## unable to locate $f"
        grc=1
      else
        doappend objects " $f"
      fi
      ;;
    *)
      if [ $islib -eq 1 ]; then
        doappend libs " -l$f"
      fi
      if [ $ispath -eq 1 ]; then
        if [ ! -d "$f" ]; then
          echo "## unable to locate dir $f"
          grc=1
        fi
        doappend libpath ":$f"
      fi
      islib=0
      ispath=0
      ;;
  esac
done

libpath=`echo $libpath | sed 's/^://'`
shrunpath=""
if [ "${libs}" != "" -a "${SHRUNPATH}" != "" ]; then
  shrunpath="${SHRUNPATH}${libpath}"
  dosubst shrunpath '^:' ''
fi
shlibpath=""
if [ "${libs}" != "" -a "${libpath}" != "" ]; then
  shlibpath="-L${libpath}"
  dosubst shlibpath '^:' ''
fi
shexeclink=""
if [ "${SHEXECLINK}" != "" ]; then
  shexeclink="${SHEXECLINK}"
fi
cmd="${CC} ${LDFLAGS} ${shexeclink} -o $outfile $objects \
    ${shrunpath} ${shlibpath} $libs"
if [ $doecho = "T" ]; then
  echo $cmd
fi
eval $cmd
rc=$?
if [ $rc -ne 0 ]; then grc=$rc; fi

exit $grc
