/* ConfigLocation.c generated by valac 0.12.0, the Vala compiler
 * generated from ConfigLocation.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <common.h>
#include <whacks.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define DEJA_DUP_TYPE_CONFIG_WIDGET (deja_dup_config_widget_get_type ())
#define DEJA_DUP_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidget))
#define DEJA_DUP_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))
#define DEJA_DUP_IS_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_IS_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_CONFIG_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))

typedef struct _DejaDupConfigWidget DejaDupConfigWidget;
typedef struct _DejaDupConfigWidgetClass DejaDupConfigWidgetClass;
typedef struct _DejaDupConfigWidgetPrivate DejaDupConfigWidgetPrivate;

#define DEJA_DUP_TYPE_CONFIG_LOCATION (deja_dup_config_location_get_type ())
#define DEJA_DUP_CONFIG_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION, DejaDupConfigLocation))
#define DEJA_DUP_CONFIG_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION, DejaDupConfigLocationClass))
#define DEJA_DUP_IS_CONFIG_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION))
#define DEJA_DUP_IS_CONFIG_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION))
#define DEJA_DUP_CONFIG_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION, DejaDupConfigLocationClass))

typedef struct _DejaDupConfigLocation DejaDupConfigLocation;
typedef struct _DejaDupConfigLocationClass DejaDupConfigLocationClass;
typedef struct _DejaDupConfigLocationPrivate DejaDupConfigLocationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DEJA_DUP_TYPE_CONFIG_LOCATION_TABLE (deja_dup_config_location_table_get_type ())
#define DEJA_DUP_CONFIG_LOCATION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_TABLE, DejaDupConfigLocationTable))
#define DEJA_DUP_CONFIG_LOCATION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_TABLE, DejaDupConfigLocationTableClass))
#define DEJA_DUP_IS_CONFIG_LOCATION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_TABLE))
#define DEJA_DUP_IS_CONFIG_LOCATION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_TABLE))
#define DEJA_DUP_CONFIG_LOCATION_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_TABLE, DejaDupConfigLocationTableClass))

typedef struct _DejaDupConfigLocationTable DejaDupConfigLocationTable;
typedef struct _DejaDupConfigLocationTableClass DejaDupConfigLocationTableClass;

#define DEJA_DUP_TYPE_CONFIG_LOCATION_VOLUME (deja_dup_config_location_volume_get_type ())
#define DEJA_DUP_CONFIG_LOCATION_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_VOLUME, DejaDupConfigLocationVolume))
#define DEJA_DUP_CONFIG_LOCATION_VOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_VOLUME, DejaDupConfigLocationVolumeClass))
#define DEJA_DUP_IS_CONFIG_LOCATION_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_VOLUME))
#define DEJA_DUP_IS_CONFIG_LOCATION_VOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_VOLUME))
#define DEJA_DUP_CONFIG_LOCATION_VOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_VOLUME, DejaDupConfigLocationVolumeClass))

typedef struct _DejaDupConfigLocationVolume DejaDupConfigLocationVolume;
typedef struct _DejaDupConfigLocationVolumeClass DejaDupConfigLocationVolumeClass;

#define DEJA_DUP_CONFIG_URL_PART_TYPE_PART (deja_dup_config_url_part_part_get_type ())
typedef struct _DejaDupConfigLocationSetFromConfigData DejaDupConfigLocationSetFromConfigData;
typedef struct _DejaDupConfigLocationSetLocationInfoData DejaDupConfigLocationSetLocationInfoData;
typedef struct _DejaDupConfigLocationSetVolumeInfoData DejaDupConfigLocationSetVolumeInfoData;

#define DEJA_DUP_TYPE_CONFIG_LOCATION_S3 (deja_dup_config_location_s3_get_type ())
#define DEJA_DUP_CONFIG_LOCATION_S3(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_S3, DejaDupConfigLocationS3))
#define DEJA_DUP_CONFIG_LOCATION_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_S3, DejaDupConfigLocationS3Class))
#define DEJA_DUP_IS_CONFIG_LOCATION_S3(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_S3))
#define DEJA_DUP_IS_CONFIG_LOCATION_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_S3))
#define DEJA_DUP_CONFIG_LOCATION_S3_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_S3, DejaDupConfigLocationS3Class))

typedef struct _DejaDupConfigLocationS3 DejaDupConfigLocationS3;
typedef struct _DejaDupConfigLocationS3Class DejaDupConfigLocationS3Class;

#define DEJA_DUP_TYPE_CONFIG_LOCATION_RACKSPACE (deja_dup_config_location_rackspace_get_type ())
#define DEJA_DUP_CONFIG_LOCATION_RACKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_RACKSPACE, DejaDupConfigLocationRackspace))
#define DEJA_DUP_CONFIG_LOCATION_RACKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_RACKSPACE, DejaDupConfigLocationRackspaceClass))
#define DEJA_DUP_IS_CONFIG_LOCATION_RACKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_RACKSPACE))
#define DEJA_DUP_IS_CONFIG_LOCATION_RACKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_RACKSPACE))
#define DEJA_DUP_CONFIG_LOCATION_RACKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_RACKSPACE, DejaDupConfigLocationRackspaceClass))

typedef struct _DejaDupConfigLocationRackspace DejaDupConfigLocationRackspace;
typedef struct _DejaDupConfigLocationRackspaceClass DejaDupConfigLocationRackspaceClass;

#define DEJA_DUP_TYPE_CONFIG_LOCATION_U1 (deja_dup_config_location_u1_get_type ())
#define DEJA_DUP_CONFIG_LOCATION_U1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_U1, DejaDupConfigLocationU1))
#define DEJA_DUP_CONFIG_LOCATION_U1_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_U1, DejaDupConfigLocationU1Class))
#define DEJA_DUP_IS_CONFIG_LOCATION_U1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_U1))
#define DEJA_DUP_IS_CONFIG_LOCATION_U1_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_U1))
#define DEJA_DUP_CONFIG_LOCATION_U1_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_U1, DejaDupConfigLocationU1Class))

typedef struct _DejaDupConfigLocationU1 DejaDupConfigLocationU1;
typedef struct _DejaDupConfigLocationU1Class DejaDupConfigLocationU1Class;

#define DEJA_DUP_TYPE_CONFIG_LOCATION_SSH (deja_dup_config_location_ssh_get_type ())
#define DEJA_DUP_CONFIG_LOCATION_SSH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_SSH, DejaDupConfigLocationSSH))
#define DEJA_DUP_CONFIG_LOCATION_SSH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_SSH, DejaDupConfigLocationSSHClass))
#define DEJA_DUP_IS_CONFIG_LOCATION_SSH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_SSH))
#define DEJA_DUP_IS_CONFIG_LOCATION_SSH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_SSH))
#define DEJA_DUP_CONFIG_LOCATION_SSH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_SSH, DejaDupConfigLocationSSHClass))

typedef struct _DejaDupConfigLocationSSH DejaDupConfigLocationSSH;
typedef struct _DejaDupConfigLocationSSHClass DejaDupConfigLocationSSHClass;

#define DEJA_DUP_TYPE_CONFIG_LOCATION_SMB (deja_dup_config_location_smb_get_type ())
#define DEJA_DUP_CONFIG_LOCATION_SMB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_SMB, DejaDupConfigLocationSMB))
#define DEJA_DUP_CONFIG_LOCATION_SMB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_SMB, DejaDupConfigLocationSMBClass))
#define DEJA_DUP_IS_CONFIG_LOCATION_SMB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_SMB))
#define DEJA_DUP_IS_CONFIG_LOCATION_SMB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_SMB))
#define DEJA_DUP_CONFIG_LOCATION_SMB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_SMB, DejaDupConfigLocationSMBClass))

typedef struct _DejaDupConfigLocationSMB DejaDupConfigLocationSMB;
typedef struct _DejaDupConfigLocationSMBClass DejaDupConfigLocationSMBClass;

#define DEJA_DUP_TYPE_CONFIG_LOCATION_FTP (deja_dup_config_location_ftp_get_type ())
#define DEJA_DUP_CONFIG_LOCATION_FTP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_FTP, DejaDupConfigLocationFTP))
#define DEJA_DUP_CONFIG_LOCATION_FTP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_FTP, DejaDupConfigLocationFTPClass))
#define DEJA_DUP_IS_CONFIG_LOCATION_FTP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_FTP))
#define DEJA_DUP_IS_CONFIG_LOCATION_FTP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_FTP))
#define DEJA_DUP_CONFIG_LOCATION_FTP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_FTP, DejaDupConfigLocationFTPClass))

typedef struct _DejaDupConfigLocationFTP DejaDupConfigLocationFTP;
typedef struct _DejaDupConfigLocationFTPClass DejaDupConfigLocationFTPClass;

#define DEJA_DUP_TYPE_CONFIG_LOCATION_DAV (deja_dup_config_location_dav_get_type ())
#define DEJA_DUP_CONFIG_LOCATION_DAV(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_DAV, DejaDupConfigLocationDAV))
#define DEJA_DUP_CONFIG_LOCATION_DAV_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_DAV, DejaDupConfigLocationDAVClass))
#define DEJA_DUP_IS_CONFIG_LOCATION_DAV(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_DAV))
#define DEJA_DUP_IS_CONFIG_LOCATION_DAV_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_DAV))
#define DEJA_DUP_CONFIG_LOCATION_DAV_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_DAV, DejaDupConfigLocationDAVClass))

typedef struct _DejaDupConfigLocationDAV DejaDupConfigLocationDAV;
typedef struct _DejaDupConfigLocationDAVClass DejaDupConfigLocationDAVClass;

#define DEJA_DUP_TYPE_CONFIG_LOCATION_CUSTOM (deja_dup_config_location_custom_get_type ())
#define DEJA_DUP_CONFIG_LOCATION_CUSTOM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_CUSTOM, DejaDupConfigLocationCustom))
#define DEJA_DUP_CONFIG_LOCATION_CUSTOM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_CUSTOM, DejaDupConfigLocationCustomClass))
#define DEJA_DUP_IS_CONFIG_LOCATION_CUSTOM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_CUSTOM))
#define DEJA_DUP_IS_CONFIG_LOCATION_CUSTOM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_CUSTOM))
#define DEJA_DUP_CONFIG_LOCATION_CUSTOM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_CUSTOM, DejaDupConfigLocationCustomClass))

typedef struct _DejaDupConfigLocationCustom DejaDupConfigLocationCustom;
typedef struct _DejaDupConfigLocationCustomClass DejaDupConfigLocationCustomClass;

#define DEJA_DUP_TYPE_CONFIG_LOCATION_FILE (deja_dup_config_location_file_get_type ())
#define DEJA_DUP_CONFIG_LOCATION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_FILE, DejaDupConfigLocationFile))
#define DEJA_DUP_CONFIG_LOCATION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_FILE, DejaDupConfigLocationFileClass))
#define DEJA_DUP_IS_CONFIG_LOCATION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_FILE))
#define DEJA_DUP_IS_CONFIG_LOCATION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LOCATION_FILE))
#define DEJA_DUP_CONFIG_LOCATION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LOCATION_FILE, DejaDupConfigLocationFileClass))

typedef struct _DejaDupConfigLocationFile DejaDupConfigLocationFile;
typedef struct _DejaDupConfigLocationFileClass DejaDupConfigLocationFileClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _DejaDupConfigWidget {
	GtkEventBox parent_instance;
	DejaDupConfigWidgetPrivate * priv;
	DejaDupSimpleSettings* settings;
};

struct _DejaDupConfigWidgetClass {
	GtkEventBoxClass parent_class;
	void (*set_from_config) (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_from_config_finish) (DejaDupConfigWidget* self, GAsyncResult* _res_);
};

struct _DejaDupConfigLocation {
	DejaDupConfigWidget parent_instance;
	DejaDupConfigLocationPrivate * priv;
};

struct _DejaDupConfigLocationClass {
	DejaDupConfigWidgetClass parent_class;
};

struct _DejaDupConfigLocationPrivate {
	GtkEventBox* _extras;
	GtkSizeGroup* _label_sizes;
	gint index_ftp;
	gint index_dav;
	gint index_s3;
	gint index_rackspace;
	gint index_u1;
	gint index_ssh;
	gint index_smb;
	gint index_vol_base;
	gint index_vol_end;
	gint index_vol_saved;
	gint index_custom;
	gint index_local;
	gint extras_max_width;
	gint extras_max_height;
	gboolean internal_set;
	GtkComboBox* button;
	GtkListStore* store;
	GtkTreeModelSort* sort_model;
};

typedef enum  {
	DEJA_DUP_CONFIG_URL_PART_PART_SCHEME,
	DEJA_DUP_CONFIG_URL_PART_PART_SERVER,
	DEJA_DUP_CONFIG_URL_PART_PART_PORT,
	DEJA_DUP_CONFIG_URL_PART_PART_USER,
	DEJA_DUP_CONFIG_URL_PART_PART_FOLDER,
	DEJA_DUP_CONFIG_URL_PART_PART_DOMAIN
} DejaDupConfigURLPartPart;

struct _DejaDupConfigLocationSetFromConfigData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupConfigLocation* self;
	gint index;
	gchar* _tmp0_;
	gchar* backend;
	DejaDupSimpleSettings* _tmp1_;
	DejaDupSimpleSettings* fsettings;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gchar* _tmp6_;
	gchar* scheme;
	const gchar* _tmp7_;
	GQuark _tmp8_;
	GtkTreeIter iter;
	GtkTreeIter iter0;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkTreeIter _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GtkTreeIter _tmp14_;
};

struct _DejaDupConfigLocationSetLocationInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupConfigLocation* self;
	GtkTreeIter iter0;
	GtkTreeIter iter;
	GtkTreeIter _tmp0_;
	gboolean _tmp1_;
	GtkTreeIter _tmp2_;
	GValue index_var;
	GValue _tmp3_;
	gint _tmp4_;
	gint index;
	gboolean prev;
	DejaDupSimpleSettings* _tmp5_;
	DejaDupSimpleSettings* fsettings;
	gchar* _tmp6_;
	gchar* scheme;
	gboolean _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
};

struct _DejaDupConfigLocationSetVolumeInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupConfigLocation* self;
	GtkTreeIter iter;
	GValue vol_var;
	GValue _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* uuid;
	gchar* _tmp3_;
	gchar* _tmp4_;
	DejaDupSimpleSettings* _tmp5_;
	DejaDupSimpleSettings* fsettings;
	GVolume* _tmp6_;
	GVolume* vol;
};


static gpointer deja_dup_config_location_parent_class = NULL;

GType deja_dup_config_widget_get_type (void) G_GNUC_CONST;
GType deja_dup_config_location_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_CONFIG_LOCATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_CONFIG_LOCATION, DejaDupConfigLocationPrivate))
enum  {
	DEJA_DUP_CONFIG_LOCATION_DUMMY_PROPERTY,
	DEJA_DUP_CONFIG_LOCATION_EXTRAS,
	DEJA_DUP_CONFIG_LOCATION_LABEL_SIZES
};
#define DEJA_DUP_CONFIG_LOCATION_COL_ICON 0
#define DEJA_DUP_CONFIG_LOCATION_COL_TEXT 1
#define DEJA_DUP_CONFIG_LOCATION_COL_SORT 2
#define DEJA_DUP_CONFIG_LOCATION_COL_UUID 3
#define DEJA_DUP_CONFIG_LOCATION_COL_PAGE 4
#define DEJA_DUP_CONFIG_LOCATION_COL_INDEX 5
void deja_dup_config_location_hidden_size (DejaDupConfigLocation* self, GtkRequisition* result);
GtkEventBox* deja_dup_config_location_get_extras (DejaDupConfigLocation* self);
DejaDupConfigLocation* deja_dup_config_location_new (GtkSizeGroup* sg);
DejaDupConfigLocation* deja_dup_config_location_construct (GType object_type, GtkSizeGroup* sg);
static gboolean deja_dup_config_location_is_separator (DejaDupConfigLocation* self, GtkTreeModel* model, GtkTreeIter* iter);
static gint deja_dup_config_location_add_entry (DejaDupConfigLocation* self, gint index, GIcon* icon, const gchar* label, gint category, GtkWidget* page, const gchar* uuid);
static gint deja_dup_config_location_add_separator (DejaDupConfigLocation* self, gint index, gint category);
static gboolean deja_dup_config_location_update_saved_volume (DejaDupConfigLocation* self);
GtkSizeGroup* deja_dup_config_location_get_label_sizes (DejaDupConfigLocation* self);
DejaDupConfigLocationVolume* deja_dup_config_location_volume_new (GtkSizeGroup* sg);
DejaDupConfigLocationVolume* deja_dup_config_location_volume_construct (GType object_type, GtkSizeGroup* sg);
GType deja_dup_config_location_table_get_type (void) G_GNUC_CONST;
GType deja_dup_config_location_volume_get_type (void) G_GNUC_CONST;
static void deja_dup_config_location_real_set_from_config_data_free (gpointer _data);
static void deja_dup_config_location_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_config_location_real_set_from_config_co (DejaDupConfigLocationSetFromConfigData* data);
GType deja_dup_config_url_part_part_get_type (void) G_GNUC_CONST;
gchar* deja_dup_config_url_part_read_uri_part (GSettings* settings, const gchar* key, DejaDupConfigURLPartPart part);
static void deja_dup_config_location_handle_changed (DejaDupConfigLocation* self);
static void deja_dup_config_location_set_location_info (DejaDupConfigLocation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_config_location_set_location_info_finish (DejaDupConfigLocation* self, GAsyncResult* _res_);
static void deja_dup_config_location_set_location_info_data_free (gpointer _data);
static gboolean deja_dup_config_location_set_location_info_co (DejaDupConfigLocationSetLocationInfoData* data);
static void deja_dup_config_location_set_remote_info (DejaDupConfigLocation* self, const gchar* scheme);
static void deja_dup_config_location_set_volume_info (DejaDupConfigLocation* self, GtkTreeIter* iter, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_config_location_set_volume_info_finish (DejaDupConfigLocation* self, GAsyncResult* _res_);
static void deja_dup_config_location_set_location_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_config_location_set_volume_info_data_free (gpointer _data);
static gboolean deja_dup_config_location_set_volume_info_co (DejaDupConfigLocationSetVolumeInfoData* data);
static void deja_dup_config_location_set_volume_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void deja_dup_config_url_part_write_uri_part (GSettings* settings, const gchar* key, DejaDupConfigURLPartPart part, const gchar* userval);
static void deja_dup_config_location_set_extras (DejaDupConfigLocation* self, GtkEventBox* value);
static void deja_dup_config_location_set_label_sizes (DejaDupConfigLocation* self, GtkSizeGroup* value);
static GObject * deja_dup_config_location_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _deja_dup_config_location_is_separator_gtk_tree_view_row_separator_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
DejaDupConfigLocationS3* deja_dup_config_location_s3_new (GtkSizeGroup* sg);
DejaDupConfigLocationS3* deja_dup_config_location_s3_construct (GType object_type, GtkSizeGroup* sg);
GType deja_dup_config_location_s3_get_type (void) G_GNUC_CONST;
DejaDupConfigLocationRackspace* deja_dup_config_location_rackspace_new (GtkSizeGroup* sg);
DejaDupConfigLocationRackspace* deja_dup_config_location_rackspace_construct (GType object_type, GtkSizeGroup* sg);
GType deja_dup_config_location_rackspace_get_type (void) G_GNUC_CONST;
DejaDupConfigLocationU1* deja_dup_config_location_u1_new (GtkSizeGroup* sg);
DejaDupConfigLocationU1* deja_dup_config_location_u1_construct (GType object_type, GtkSizeGroup* sg);
GType deja_dup_config_location_u1_get_type (void) G_GNUC_CONST;
DejaDupConfigLocationSSH* deja_dup_config_location_ssh_new (GtkSizeGroup* sg);
DejaDupConfigLocationSSH* deja_dup_config_location_ssh_construct (GType object_type, GtkSizeGroup* sg);
GType deja_dup_config_location_ssh_get_type (void) G_GNUC_CONST;
DejaDupConfigLocationSMB* deja_dup_config_location_smb_new (GtkSizeGroup* sg);
DejaDupConfigLocationSMB* deja_dup_config_location_smb_construct (GType object_type, GtkSizeGroup* sg);
GType deja_dup_config_location_smb_get_type (void) G_GNUC_CONST;
DejaDupConfigLocationFTP* deja_dup_config_location_ftp_new (GtkSizeGroup* sg);
DejaDupConfigLocationFTP* deja_dup_config_location_ftp_construct (GType object_type, GtkSizeGroup* sg);
GType deja_dup_config_location_ftp_get_type (void) G_GNUC_CONST;
DejaDupConfigLocationDAV* deja_dup_config_location_dav_new (GtkSizeGroup* sg);
DejaDupConfigLocationDAV* deja_dup_config_location_dav_construct (GType object_type, GtkSizeGroup* sg);
GType deja_dup_config_location_dav_get_type (void) G_GNUC_CONST;
DejaDupConfigLocationCustom* deja_dup_config_location_custom_new (GtkSizeGroup* sg);
DejaDupConfigLocationCustom* deja_dup_config_location_custom_construct (GType object_type, GtkSizeGroup* sg);
GType deja_dup_config_location_custom_get_type (void) G_GNUC_CONST;
DejaDupConfigLocationFile* deja_dup_config_location_file_new (GtkSizeGroup* sg);
DejaDupConfigLocationFile* deja_dup_config_location_file_construct (GType object_type, GtkSizeGroup* sg);
GType deja_dup_config_location_file_get_type (void) G_GNUC_CONST;
void deja_dup_config_widget_set_mnemonic_widget (DejaDupConfigWidget* self, GtkWidget* value);
void deja_dup_config_widget_set_from_config (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_config_widget_set_from_config_finish (DejaDupConfigWidget* self, GAsyncResult* _res_);
static void _deja_dup_config_location_handle_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
void deja_dup_config_widget_watch_key (DejaDupConfigWidget* self, const gchar* key, GSettings* s);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void deja_dup_config_location_finalize (GObject* obj);
static void _vala_deja_dup_config_location_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_deja_dup_config_location_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void deja_dup_config_location_hidden_size (DejaDupConfigLocation* self, GtkRequisition* result) {
	GtkRequisition pagereq = {0};
	GtkRequisition _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	hacks_get_natural_size ((GtkWidget*) self->priv->_extras, &_tmp0_);
	pagereq = _tmp0_;
	pagereq.width = (self->priv->extras_max_width - pagereq.width) + 20;
	pagereq.height = (self->priv->extras_max_height - pagereq.height) + 20;
	*result = pagereq;
	return;
}


DejaDupConfigLocation* deja_dup_config_location_construct (GType object_type, GtkSizeGroup* sg) {
	DejaDupConfigLocation * self = NULL;
	self = (DejaDupConfigLocation*) g_object_new (object_type, "label-sizes", sg, NULL);
	return self;
}


DejaDupConfigLocation* deja_dup_config_location_new (GtkSizeGroup* sg) {
	return deja_dup_config_location_construct (DEJA_DUP_TYPE_CONFIG_LOCATION, sg);
}


static gboolean deja_dup_config_location_is_separator (DejaDupConfigLocation* self, GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	GValue text_var = {0};
	GValue _tmp0_ = {0};
	const gchar* _tmp1_ = NULL;
	const gchar* text;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	gtk_tree_model_get_value (model, iter, DEJA_DUP_CONFIG_LOCATION_COL_TEXT, &_tmp0_);
	G_IS_VALUE (&text_var) ? (g_value_unset (&text_var), NULL) : NULL;
	text_var = _tmp0_;
	_tmp1_ = g_value_get_string (&text_var);
	text = _tmp1_;
	result = text == NULL;
	G_IS_VALUE (&text_var) ? (g_value_unset (&text_var), NULL) : NULL;
	return result;
}


static gint deja_dup_config_location_add_entry (DejaDupConfigLocation* self, gint index, GIcon* icon, const gchar* label, gint category, GtkWidget* page, const gchar* uuid) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (label != NULL, 0);
	_tmp0_ = g_strdup_printf ("%d%s", category, label);
	_tmp1_ = _tmp0_;
	gtk_list_store_insert_with_values (self->priv->store, &_tmp2_, index, DEJA_DUP_CONFIG_LOCATION_COL_ICON, icon, DEJA_DUP_CONFIG_LOCATION_COL_TEXT, label, DEJA_DUP_CONFIG_LOCATION_COL_SORT, _tmp1_, DEJA_DUP_CONFIG_LOCATION_COL_UUID, uuid, DEJA_DUP_CONFIG_LOCATION_COL_PAGE, page, DEJA_DUP_CONFIG_LOCATION_COL_INDEX, index, -1);
	iter = _tmp2_;
	_g_free0 (_tmp1_);
	if (page != NULL) {
		GtkRequisition pagereq = {0};
		GtkRequisition _tmp3_ = {0};
		gint _tmp4_;
		gint _tmp5_;
		gtk_widget_show_all (page);
		hacks_get_natural_size (page, &_tmp3_);
		pagereq = _tmp3_;
		_tmp4_ = MAX (self->priv->extras_max_width, pagereq.width);
		self->priv->extras_max_width = _tmp4_;
		_tmp5_ = MAX (self->priv->extras_max_height, pagereq.height);
		self->priv->extras_max_height = _tmp5_;
	}
	result = index;
	return result;
}


static gint deja_dup_config_location_add_separator (DejaDupConfigLocation* self, gint index, gint category) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_strdup_printf ("%d", category);
	_tmp1_ = _tmp0_;
	gtk_list_store_insert_with_values (self->priv->store, &_tmp2_, index, DEJA_DUP_CONFIG_LOCATION_COL_SORT, _tmp1_, DEJA_DUP_CONFIG_LOCATION_COL_TEXT, NULL, DEJA_DUP_CONFIG_LOCATION_COL_INDEX, index, -1);
	iter = _tmp2_;
	_g_free0 (_tmp1_);
	result = index;
	return result;
}


static gboolean deja_dup_config_location_update_saved_volume (DejaDupConfigLocation* self) {
	gboolean result = FALSE;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* fsettings;
	gchar* _tmp1_ = NULL;
	gchar* vol_uuid;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	fsettings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) fsettings, DEJA_DUP_FILE_UUID_KEY);
	vol_uuid = _tmp1_;
	if (g_strcmp0 (vol_uuid, "") != 0) {
		GtkTreeIter iter = {0};
		GIcon* vol_icon;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GIcon* _tmp10_ = NULL;
		GIcon* _tmp11_;
		GIcon* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* vol_name;
		if (self->priv->index_vol_saved == (-2)) {
			{
				gint i;
				i = self->priv->index_vol_base;
				{
					gboolean _tmp2_;
					_tmp2_ = TRUE;
					while (TRUE) {
						gchar* _tmp3_ = NULL;
						gchar* _tmp4_;
						GtkTreeIter _tmp5_ = {0};
						gboolean _tmp6_;
						gboolean _tmp7_;
						gchar* uuid = NULL;
						if (!_tmp2_) {
							i++;
						}
						_tmp2_ = FALSE;
						if (!(i < self->priv->index_vol_end)) {
							break;
						}
						_tmp3_ = g_strdup_printf ("%i", i);
						_tmp4_ = _tmp3_;
						_tmp6_ = gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->store, &_tmp5_, _tmp4_);
						iter = _tmp5_;
						_tmp7_ = !_tmp6_;
						_g_free0 (_tmp4_);
						if (_tmp7_) {
							continue;
						}
						gtk_tree_model_get ((GtkTreeModel*) self->priv->store, &iter, DEJA_DUP_CONFIG_LOCATION_COL_UUID, &uuid, -1);
						if (g_strcmp0 (vol_uuid, uuid) == 0) {
							result = FALSE;
							_g_free0 (uuid);
							_g_free0 (vol_uuid);
							_g_object_unref0 (fsettings);
							return result;
						}
						_g_free0 (uuid);
					}
				}
			}
		}
		vol_icon = NULL;
		_tmp8_ = g_settings_get_string ((GSettings*) fsettings, DEJA_DUP_FILE_ICON_KEY);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_icon_new_for_string (_tmp9_, &_inner_error_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_tmp12_ = _tmp11_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_g_object_unref0 (vol_icon);
		vol_icon = _tmp12_;
		goto __finally3;
		__catch3_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("ConfigLocation.vala:230: %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (vol_icon);
			_g_free0 (vol_uuid);
			_g_object_unref0 (fsettings);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp13_ = g_settings_get_string ((GSettings*) fsettings, DEJA_DUP_FILE_SHORT_NAME_KEY);
		vol_name = _tmp13_;
		if (self->priv->index_vol_saved == (-2)) {
			DejaDupConfigLocationVolume* _tmp14_ = NULL;
			DejaDupConfigLocationVolume* _tmp15_;
			gint _tmp16_;
			if (self->priv->index_vol_base == self->priv->index_vol_end) {
				deja_dup_config_location_add_separator (self, self->priv->index_vol_end + 2, 4);
			}
			_tmp14_ = deja_dup_config_location_volume_new (self->priv->_label_sizes);
			_tmp15_ = g_object_ref_sink (_tmp14_);
			_tmp16_ = deja_dup_config_location_add_entry (self, self->priv->index_vol_end + 1, vol_icon, vol_name, 3, (GtkWidget*) _tmp15_, vol_uuid);
			self->priv->index_vol_saved = _tmp16_;
			_g_object_unref0 (_tmp15_);
		} else {
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			GtkTreeIter _tmp19_ = {0};
			gboolean _tmp20_;
			gboolean _tmp21_;
			_tmp17_ = g_strdup_printf ("%i", self->priv->index_vol_saved);
			_tmp18_ = _tmp17_;
			_tmp20_ = gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->store, &_tmp19_, _tmp18_);
			iter = _tmp19_;
			_tmp21_ = _tmp20_;
			_g_free0 (_tmp18_);
			if (_tmp21_) {
				gtk_list_store_set (self->priv->store, &iter, DEJA_DUP_CONFIG_LOCATION_COL_ICON, vol_icon, DEJA_DUP_CONFIG_LOCATION_COL_TEXT, vol_name, DEJA_DUP_CONFIG_LOCATION_COL_UUID, vol_uuid, -1);
			}
		}
		result = TRUE;
		_g_free0 (vol_name);
		_g_object_unref0 (vol_icon);
		_g_free0 (vol_uuid);
		_g_object_unref0 (fsettings);
		return result;
	} else {
		result = FALSE;
		_g_free0 (vol_uuid);
		_g_object_unref0 (fsettings);
		return result;
	}
	_g_free0 (vol_uuid);
	_g_object_unref0 (fsettings);
}


static void deja_dup_config_location_real_set_from_config_data_free (gpointer _data) {
	DejaDupConfigLocationSetFromConfigData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupConfigLocationSetFromConfigData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_config_location_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupConfigLocation * self;
	DejaDupConfigLocationSetFromConfigData* _data_;
	self = (DejaDupConfigLocation*) base;
	_data_ = g_slice_new0 (DejaDupConfigLocationSetFromConfigData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_config_location_real_set_from_config);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_config_location_real_set_from_config_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_config_location_real_set_from_config_co (_data_);
}


static void deja_dup_config_location_real_set_from_config_finish (DejaDupConfigWidget* base, GAsyncResult* _res_) {
	DejaDupConfigLocationSetFromConfigData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean deja_dup_config_location_real_set_from_config_co (DejaDupConfigLocationSetFromConfigData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->self->priv->internal_set) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->index = -1;
	data->_tmp0_ = NULL;
	data->_tmp0_ = deja_dup_backend_get_default_type ();
	data->backend = data->_tmp0_;
	if (g_strcmp0 (data->backend, "s3") == 0) {
		data->index = data->self->priv->index_s3;
	} else {
		if (g_strcmp0 (data->backend, "rackspace") == 0) {
			data->index = data->self->priv->index_rackspace;
		} else {
			if (g_strcmp0 (data->backend, "u1") == 0) {
				data->index = data->self->priv->index_u1;
			} else {
				if (g_strcmp0 (data->backend, "file") == 0) {
					data->_tmp1_ = NULL;
					data->_tmp1_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
					data->fsettings = data->_tmp1_;
					data->_tmp2_ = NULL;
					data->_tmp2_ = g_settings_get_string ((GSettings*) data->fsettings, DEJA_DUP_FILE_TYPE_KEY);
					data->_tmp3_ = data->_tmp2_;
					data->_tmp4_ = g_strcmp0 (data->_tmp3_, "volume") == 0;
					_g_free0 (data->_tmp3_);
					if (data->_tmp4_) {
						data->_tmp5_ = deja_dup_config_location_update_saved_volume (data->self);
						if (data->_tmp5_) {
							data->index = data->self->priv->index_vol_saved;
						}
					} else {
						static GQuark _tmp8__label0 = 0;
						static GQuark _tmp8__label1 = 0;
						static GQuark _tmp8__label2 = 0;
						static GQuark _tmp8__label3 = 0;
						static GQuark _tmp8__label4 = 0;
						static GQuark _tmp8__label5 = 0;
						static GQuark _tmp8__label6 = 0;
						data->_tmp6_ = NULL;
						data->_tmp6_ = deja_dup_config_url_part_read_uri_part ((GSettings*) data->fsettings, DEJA_DUP_FILE_PATH_KEY, DEJA_DUP_CONFIG_URL_PART_PART_SCHEME);
						data->scheme = data->_tmp6_;
						data->_tmp7_ = data->scheme;
						data->_tmp8_ = (NULL == data->_tmp7_) ? 0 : g_quark_from_string (data->_tmp7_);
						if ((data->_tmp8_ == ((0 != _tmp8__label0) ? _tmp8__label0 : (_tmp8__label0 = g_quark_from_static_string ("dav")))) || (data->_tmp8_ == ((0 != _tmp8__label1) ? _tmp8__label1 : (_tmp8__label1 = g_quark_from_static_string ("davs"))))) {
							switch (0) {
								default:
								{
									data->index = data->self->priv->index_dav;
									break;
								}
							}
						} else if ((data->_tmp8_ == ((0 != _tmp8__label2) ? _tmp8__label2 : (_tmp8__label2 = g_quark_from_static_string ("sftp")))) || (data->_tmp8_ == ((0 != _tmp8__label3) ? _tmp8__label3 : (_tmp8__label3 = g_quark_from_static_string ("ssh"))))) {
							switch (0) {
								default:
								{
									data->index = data->self->priv->index_ssh;
									break;
								}
							}
						} else if (data->_tmp8_ == ((0 != _tmp8__label4) ? _tmp8__label4 : (_tmp8__label4 = g_quark_from_static_string ("ftp")))) {
							switch (0) {
								default:
								{
									data->index = data->self->priv->index_ftp;
									break;
								}
							}
						} else if (data->_tmp8_ == ((0 != _tmp8__label5) ? _tmp8__label5 : (_tmp8__label5 = g_quark_from_static_string ("smb")))) {
							switch (0) {
								default:
								{
									data->index = data->self->priv->index_smb;
									break;
								}
							}
						} else if (data->_tmp8_ == ((0 != _tmp8__label6) ? _tmp8__label6 : (_tmp8__label6 = g_quark_from_static_string ("file")))) {
							switch (0) {
								default:
								{
									data->index = data->self->priv->index_local;
									break;
								}
							}
						} else {
							switch (0) {
								default:
								{
									data->index = data->self->priv->index_custom;
									break;
								}
							}
						}
						_g_free0 (data->scheme);
					}
					_g_object_unref0 (data->fsettings);
				}
			}
		}
	}
	if (data->index >= 0) {
		data->_tmp9_ = NULL;
		data->_tmp9_ = g_strdup_printf ("%i", data->index);
		data->_tmp10_ = data->_tmp9_;
		memset (&data->_tmp11_, 0, sizeof (GtkTreeIter));
		data->_tmp12_ = gtk_tree_model_get_iter_from_string ((GtkTreeModel*) data->self->priv->store, &data->_tmp11_, data->_tmp10_);
		data->iter = data->_tmp11_;
		data->_tmp13_ = data->_tmp12_;
		_g_free0 (data->_tmp10_);
		if (data->_tmp13_) {
			memset (&data->_tmp14_, 0, sizeof (GtkTreeIter));
			gtk_tree_model_sort_convert_child_iter_to_iter (data->self->priv->sort_model, &data->_tmp14_, &data->iter);
			data->iter0 = data->_tmp14_;
			gtk_combo_box_set_active_iter (data->self->priv->button, &data->iter0);
		}
	}
	_g_free0 (data->backend);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_config_location_handle_changed (DejaDupConfigLocation* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* current;
	GtkTreeIter iter0 = {0};
	GtkTreeIter iter = {0};
	GValue page_var = {0};
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	deja_dup_config_location_set_location_info (self, NULL, NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) self->priv->_extras);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	current = _tmp1_;
	if (current != NULL) {
		gtk_container_remove ((GtkContainer*) self->priv->_extras, current);
	}
	_tmp3_ = gtk_combo_box_get_active_iter (self->priv->button, &_tmp2_);
	iter0 = _tmp2_;
	if (_tmp3_) {
		GtkTreeIter _tmp4_ = {0};
		GValue _tmp5_ = {0};
		GObject* _tmp6_ = NULL;
		GObject* _tmp7_;
		DejaDupConfigLocationTable* _tmp8_;
		DejaDupConfigLocationTable* page;
		gtk_tree_model_sort_convert_iter_to_child_iter (self->priv->sort_model, &_tmp4_, &iter0);
		iter = _tmp4_;
		gtk_tree_model_get_value ((GtkTreeModel*) self->priv->store, &iter, DEJA_DUP_CONFIG_LOCATION_COL_PAGE, &_tmp5_);
		G_IS_VALUE (&page_var) ? (g_value_unset (&page_var), NULL) : NULL;
		page_var = _tmp5_;
		_tmp6_ = g_value_get_object (&page_var);
		_tmp7_ = _tmp6_;
		_tmp8_ = _g_object_ref0 (DEJA_DUP_IS_CONFIG_LOCATION_TABLE (_tmp7_) ? ((DejaDupConfigLocationTable*) _tmp7_) : NULL);
		page = _tmp8_;
		if (page != NULL) {
			gtk_container_add ((GtkContainer*) self->priv->_extras, (GtkWidget*) page);
		}
		_g_object_unref0 (page);
	}
	G_IS_VALUE (&page_var) ? (g_value_unset (&page_var), NULL) : NULL;
	_g_object_unref0 (current);
}


static void deja_dup_config_location_set_location_info_data_free (gpointer _data) {
	DejaDupConfigLocationSetLocationInfoData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupConfigLocationSetLocationInfoData, data);
}


static void deja_dup_config_location_set_location_info (DejaDupConfigLocation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupConfigLocationSetLocationInfoData* _data_;
	_data_ = g_slice_new0 (DejaDupConfigLocationSetLocationInfoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_config_location_set_location_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_config_location_set_location_info_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_config_location_set_location_info_co (_data_);
}


static void deja_dup_config_location_set_location_info_finish (DejaDupConfigLocation* self, GAsyncResult* _res_) {
	DejaDupConfigLocationSetLocationInfoData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_config_location_set_location_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupConfigLocationSetLocationInfoData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_config_location_set_location_info_co (data);
}


static gboolean deja_dup_config_location_set_location_info_co (DejaDupConfigLocationSetLocationInfoData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&data->_tmp0_, 0, sizeof (GtkTreeIter));
	data->_tmp1_ = gtk_combo_box_get_active_iter (data->self->priv->button, &data->_tmp0_);
	data->iter0 = data->_tmp0_;
	if (!data->_tmp1_) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	memset (&data->_tmp2_, 0, sizeof (GtkTreeIter));
	gtk_tree_model_sort_convert_iter_to_child_iter (data->self->priv->sort_model, &data->_tmp2_, &data->iter0);
	data->iter = data->_tmp2_;
	memset (&data->_tmp3_, 0, sizeof (GValue));
	gtk_tree_model_get_value ((GtkTreeModel*) data->self->priv->store, &data->iter, DEJA_DUP_CONFIG_LOCATION_COL_INDEX, &data->_tmp3_);
	G_IS_VALUE (&data->index_var) ? (g_value_unset (&data->index_var), NULL) : NULL;
	data->index_var = data->_tmp3_;
	data->_tmp4_ = g_value_get_int (&data->index_var);
	data->index = data->_tmp4_;
	data->prev = data->self->priv->internal_set;
	data->self->priv->internal_set = TRUE;
	if (data->index == data->self->priv->index_s3) {
		deja_dup_simple_settings_set_string (((DejaDupConfigWidget*) data->self)->settings, DEJA_DUP_BACKEND_KEY, "s3");
	} else {
		if (data->index == data->self->priv->index_rackspace) {
			deja_dup_simple_settings_set_string (((DejaDupConfigWidget*) data->self)->settings, DEJA_DUP_BACKEND_KEY, "rackspace");
		} else {
			if (data->index == data->self->priv->index_u1) {
				deja_dup_simple_settings_set_string (((DejaDupConfigWidget*) data->self)->settings, DEJA_DUP_BACKEND_KEY, "u1");
			} else {
				if (data->index == data->self->priv->index_ssh) {
					deja_dup_config_location_set_remote_info (data->self, "sftp");
				} else {
					if (data->index == data->self->priv->index_ftp) {
						deja_dup_config_location_set_remote_info (data->self, "ftp");
					} else {
						if (data->index == data->self->priv->index_dav) {
							data->_tmp5_ = NULL;
							data->_tmp5_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
							data->fsettings = data->_tmp5_;
							data->_tmp6_ = NULL;
							data->_tmp6_ = deja_dup_config_url_part_read_uri_part ((GSettings*) data->fsettings, DEJA_DUP_FILE_PATH_KEY, DEJA_DUP_CONFIG_URL_PART_PART_SCHEME);
							data->scheme = data->_tmp6_;
							if (g_strcmp0 (data->scheme, "dav") != 0) {
								data->_tmp7_ = g_strcmp0 (data->scheme, "davs") != 0;
							} else {
								data->_tmp7_ = FALSE;
							}
							if (data->_tmp7_) {
								data->_tmp8_ = g_strdup ("dav");
								_g_free0 (data->scheme);
								data->scheme = data->_tmp8_;
							}
							deja_dup_config_location_set_remote_info (data->self, data->scheme);
							_g_free0 (data->scheme);
							_g_object_unref0 (data->fsettings);
						} else {
							if (data->index == data->self->priv->index_smb) {
								deja_dup_config_location_set_remote_info (data->self, "smb");
							} else {
								if (data->index >= data->self->priv->index_vol_base) {
									data->_tmp10_ = data->index < data->self->priv->index_vol_end;
								} else {
									data->_tmp10_ = FALSE;
								}
								if (data->_tmp10_) {
									data->_tmp9_ = TRUE;
								} else {
									data->_tmp9_ = data->index == data->self->priv->index_vol_saved;
								}
								if (data->_tmp9_) {
									data->_state_ = 1;
									deja_dup_config_location_set_volume_info (data->self, &data->iter, deja_dup_config_location_set_location_info_ready, data);
									return FALSE;
									_state_1:
									deja_dup_config_location_set_volume_info_finish (data->self, data->_res_);
								} else {
									if (data->index == data->self->priv->index_local) {
										data->_tmp11_ = TRUE;
									} else {
										data->_tmp11_ = data->index == data->self->priv->index_custom;
									}
									if (data->_tmp11_) {
										deja_dup_config_location_set_remote_info (data->self, "file");
									} else {
										g_warning ("ConfigLocation.vala:359: Unknown location index %i\n", data->index);
									}
								}
							}
						}
					}
				}
			}
		}
	}
	g_signal_emit_by_name ((DejaDupConfigWidget*) data->self, "changed");
	data->self->priv->internal_set = data->prev;
	G_IS_VALUE (&data->index_var) ? (g_value_unset (&data->index_var), NULL) : NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_config_location_set_volume_info_data_free (gpointer _data) {
	DejaDupConfigLocationSetVolumeInfoData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupConfigLocationSetVolumeInfoData, data);
}


static void deja_dup_config_location_set_volume_info (DejaDupConfigLocation* self, GtkTreeIter* iter, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupConfigLocationSetVolumeInfoData* _data_;
	_data_ = g_slice_new0 (DejaDupConfigLocationSetVolumeInfoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_config_location_set_volume_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_config_location_set_volume_info_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->iter = *iter;
	deja_dup_config_location_set_volume_info_co (_data_);
}


static void deja_dup_config_location_set_volume_info_finish (DejaDupConfigLocation* self, GAsyncResult* _res_) {
	DejaDupConfigLocationSetVolumeInfoData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_config_location_set_volume_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupConfigLocationSetVolumeInfoData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_config_location_set_volume_info_co (data);
}


static gboolean deja_dup_config_location_set_volume_info_co (DejaDupConfigLocationSetVolumeInfoData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&data->_tmp0_, 0, sizeof (GValue));
	gtk_tree_model_get_value ((GtkTreeModel*) data->self->priv->store, &data->iter, DEJA_DUP_CONFIG_LOCATION_COL_UUID, &data->_tmp0_);
	G_IS_VALUE (&data->vol_var) ? (g_value_unset (&data->vol_var), NULL) : NULL;
	data->vol_var = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_value_get_string (&data->vol_var);
	data->_tmp2_ = g_strdup (data->_tmp1_);
	data->uuid = data->_tmp2_;
	if (data->uuid == NULL) {
		data->_tmp3_ = NULL;
		data->_tmp3_ = gtk_tree_model_get_string_from_iter ((GtkTreeModel*) data->self->priv->store, &data->iter);
		data->_tmp4_ = data->_tmp3_;
		g_warning ("ConfigLocation.vala:374: Invalid volume location at iter %s\n", data->_tmp4_);
		_g_free0 (data->_tmp4_);
		_g_free0 (data->uuid);
		G_IS_VALUE (&data->vol_var) ? (g_value_unset (&data->vol_var), NULL) : NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	data->fsettings = data->_tmp5_;
	deja_dup_simple_settings_set_string (data->fsettings, DEJA_DUP_FILE_TYPE_KEY, "volume");
	deja_dup_simple_settings_set_string (((DejaDupConfigWidget*) data->self)->settings, DEJA_DUP_BACKEND_KEY, "file");
	data->_tmp6_ = NULL;
	data->_tmp6_ = deja_dup_backend_file_find_volume_by_uuid (data->uuid);
	data->vol = data->_tmp6_;
	if (data->vol == NULL) {
		_g_object_unref0 (data->vol);
		_g_object_unref0 (data->fsettings);
		_g_free0 (data->uuid);
		G_IS_VALUE (&data->vol_var) ? (g_value_unset (&data->vol_var), NULL) : NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 1;
	deja_dup_backend_file_set_volume_info (data->vol, NULL, deja_dup_config_location_set_volume_info_ready, data);
	return FALSE;
	_state_1:
	deja_dup_backend_file_set_volume_info_finish (data->_res_);
	_g_object_unref0 (data->vol);
	_g_object_unref0 (data->fsettings);
	_g_free0 (data->uuid);
	G_IS_VALUE (&data->vol_var) ? (g_value_unset (&data->vol_var), NULL) : NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_config_location_set_remote_info (DejaDupConfigLocation* self, const gchar* scheme) {
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* fsettings;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scheme != NULL);
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	fsettings = _tmp0_;
	deja_dup_simple_settings_set_string (fsettings, DEJA_DUP_FILE_TYPE_KEY, "normal");
	deja_dup_config_url_part_write_uri_part ((GSettings*) fsettings, DEJA_DUP_FILE_PATH_KEY, DEJA_DUP_CONFIG_URL_PART_PART_SCHEME, scheme);
	deja_dup_simple_settings_set_string (((DejaDupConfigWidget*) self)->settings, DEJA_DUP_BACKEND_KEY, "file");
	_g_object_unref0 (fsettings);
}


GtkEventBox* deja_dup_config_location_get_extras (DejaDupConfigLocation* self) {
	GtkEventBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_extras;
	return result;
}


static void deja_dup_config_location_set_extras (DejaDupConfigLocation* self, GtkEventBox* value) {
	GtkEventBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_extras);
	self->priv->_extras = _tmp0_;
	g_object_notify ((GObject *) self, "extras");
}


GtkSizeGroup* deja_dup_config_location_get_label_sizes (DejaDupConfigLocation* self) {
	GtkSizeGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_label_sizes;
	return result;
}


static void deja_dup_config_location_set_label_sizes (DejaDupConfigLocation* self, GtkSizeGroup* value) {
	GtkSizeGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_label_sizes);
	self->priv->_label_sizes = _tmp0_;
	g_object_notify ((GObject *) self, "label-sizes");
}


static gboolean _deja_dup_config_location_is_separator_gtk_tree_view_row_separator_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = deja_dup_config_location_is_separator (self, model, iter);
	return result;
}


static void _deja_dup_config_location_handle_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	deja_dup_config_location_handle_changed (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GObject * deja_dup_config_location_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupConfigLocation * self;
	GtkVBox* _tmp0_ = NULL;
	GtkVBox* vbox;
	GtkListStore* _tmp1_ = NULL;
	GtkTreeModelSort* _tmp2_ = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	gint i;
	GtkEventBox* _tmp6_ = NULL;
	GtkEventBox* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* backend;
	gint _tmp9_;
	GThemedIcon* _tmp10_ = NULL;
	GThemedIcon* _tmp11_;
	const gchar* _tmp12_ = NULL;
	DejaDupConfigLocationS3* _tmp13_ = NULL;
	DejaDupConfigLocationS3* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GThemedIcon* _tmp17_ = NULL;
	GThemedIcon* _tmp18_;
	const gchar* _tmp19_ = NULL;
	DejaDupConfigLocationRackspace* _tmp20_ = NULL;
	DejaDupConfigLocationRackspace* _tmp21_;
	gint _tmp22_;
	gboolean _tmp23_ = FALSE;
	gint _tmp32_;
	gint _tmp33_;
	GThemedIcon* _tmp34_ = NULL;
	GThemedIcon* _tmp35_;
	const gchar* _tmp36_ = NULL;
	DejaDupConfigLocationSSH* _tmp37_ = NULL;
	DejaDupConfigLocationSSH* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	GThemedIcon* _tmp41_ = NULL;
	GThemedIcon* _tmp42_;
	const gchar* _tmp43_ = NULL;
	DejaDupConfigLocationSMB* _tmp44_ = NULL;
	DejaDupConfigLocationSMB* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	GThemedIcon* _tmp48_ = NULL;
	GThemedIcon* _tmp49_;
	const gchar* _tmp50_ = NULL;
	DejaDupConfigLocationFTP* _tmp51_ = NULL;
	DejaDupConfigLocationFTP* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	GThemedIcon* _tmp55_ = NULL;
	GThemedIcon* _tmp56_;
	const gchar* _tmp57_ = NULL;
	DejaDupConfigLocationDAV* _tmp58_ = NULL;
	DejaDupConfigLocationDAV* _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	GThemedIcon* _tmp62_ = NULL;
	GThemedIcon* _tmp63_;
	const gchar* _tmp64_ = NULL;
	DejaDupConfigLocationCustom* _tmp65_ = NULL;
	DejaDupConfigLocationCustom* _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	GThemedIcon* _tmp70_ = NULL;
	GThemedIcon* _tmp71_;
	const gchar* _tmp72_ = NULL;
	DejaDupConfigLocationFile* _tmp73_ = NULL;
	DejaDupConfigLocationFile* _tmp74_;
	gint _tmp75_;
	GVolumeMonitor* _tmp76_ = NULL;
	GVolumeMonitor* mon;
	GList* _tmp77_ = NULL;
	GList* vols;
	GtkCellRendererPixbuf* _tmp86_ = NULL;
	GtkCellRendererPixbuf* pixrenderer;
	GtkCellRendererText* _tmp87_ = NULL;
	GtkCellRendererText* textrenderer;
	DejaDupSimpleSettings* _tmp88_ = NULL;
	DejaDupSimpleSettings* _tmp89_;
	parent_class = G_OBJECT_CLASS (deja_dup_config_location_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_CONFIG_LOCATION (obj);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	vbox = g_object_ref_sink (_tmp0_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) vbox);
	_tmp1_ = gtk_list_store_new (6, G_TYPE_ICON, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, DEJA_DUP_TYPE_CONFIG_LOCATION_TABLE, G_TYPE_INT);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp1_;
	_tmp2_ = (GtkTreeModelSort*) gtk_tree_model_sort_new_with_model ((GtkTreeModel*) self->priv->store);
	_g_object_unref0 (self->priv->sort_model);
	self->priv->sort_model = _tmp2_;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self->priv->sort_model, DEJA_DUP_CONFIG_LOCATION_COL_SORT, GTK_SORT_ASCENDING);
	_tmp3_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) self->priv->sort_model);
	_g_object_unref0 (self->priv->button);
	self->priv->button = g_object_ref_sink (_tmp3_);
	gtk_combo_box_set_row_separator_func (self->priv->button, _deja_dup_config_location_is_separator_gtk_tree_view_row_separator_func, g_object_ref (self), g_object_unref);
	gtk_container_add ((GtkContainer*) vbox, (GtkWidget*) self->priv->button);
	i = 0;
	if (self->priv->_label_sizes == NULL) {
		GtkSizeGroup* _tmp4_ = NULL;
		GtkSizeGroup* _tmp5_;
		_tmp4_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
		_tmp5_ = _tmp4_;
		deja_dup_config_location_set_label_sizes (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp6_ = (GtkEventBox*) gtk_event_box_new ();
	_tmp7_ = g_object_ref_sink (_tmp6_);
	deja_dup_config_location_set_extras (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	gtk_container_set_border_width ((GtkContainer*) self->priv->_extras, (guint) 0);
	gtk_widget_show ((GtkWidget*) self->priv->_extras);
	_tmp8_ = deja_dup_backend_get_default_type ();
	backend = _tmp8_;
	_tmp9_ = i;
	i = _tmp9_ + 1;
	_tmp10_ = (GThemedIcon*) g_themed_icon_new ("deja-dup-cloud");
	_tmp11_ = _tmp10_;
	_tmp12_ = _ ("Amazon S3");
	_tmp13_ = deja_dup_config_location_s3_new (self->priv->_label_sizes);
	_tmp14_ = g_object_ref_sink (_tmp13_);
	_tmp15_ = deja_dup_config_location_add_entry (self, _tmp9_, (GIcon*) _tmp11_, _tmp12_, 0, (GtkWidget*) _tmp14_, NULL);
	self->priv->index_s3 = _tmp15_;
	_g_object_unref0 (_tmp14_);
	_g_object_unref0 (_tmp11_);
	_tmp16_ = i;
	i = _tmp16_ + 1;
	_tmp17_ = (GThemedIcon*) g_themed_icon_new ("deja-dup-cloud");
	_tmp18_ = _tmp17_;
	_tmp19_ = _ ("Rackspace Cloud Files");
	_tmp20_ = deja_dup_config_location_rackspace_new (self->priv->_label_sizes);
	_tmp21_ = g_object_ref_sink (_tmp20_);
	_tmp22_ = deja_dup_config_location_add_entry (self, _tmp16_, (GIcon*) _tmp18_, _tmp19_, 0, (GtkWidget*) _tmp21_, NULL);
	self->priv->index_rackspace = _tmp22_;
	_g_object_unref0 (_tmp21_);
	_g_object_unref0 (_tmp18_);
	if (g_strcmp0 (backend, "u1") == 0) {
		_tmp23_ = TRUE;
	} else {
		gboolean _tmp24_;
		_tmp24_ = deja_dup_backend_u1_is_available ();
		_tmp23_ = _tmp24_;
	}
	if (_tmp23_) {
		gint _tmp25_;
		GThemedIcon* _tmp26_ = NULL;
		GThemedIcon* _tmp27_;
		const gchar* _tmp28_ = NULL;
		DejaDupConfigLocationU1* _tmp29_ = NULL;
		DejaDupConfigLocationU1* _tmp30_;
		gint _tmp31_;
		_tmp25_ = i;
		i = _tmp25_ + 1;
		_tmp26_ = (GThemedIcon*) g_themed_icon_new ("ubuntuone");
		_tmp27_ = _tmp26_;
		_tmp28_ = _ ("Ubuntu One");
		_tmp29_ = deja_dup_config_location_u1_new (self->priv->_label_sizes);
		_tmp30_ = g_object_ref_sink (_tmp29_);
		_tmp31_ = deja_dup_config_location_add_entry (self, _tmp25_, (GIcon*) _tmp27_, _tmp28_, 0, (GtkWidget*) _tmp30_, NULL);
		self->priv->index_u1 = _tmp31_;
		_g_object_unref0 (_tmp30_);
		_g_object_unref0 (_tmp27_);
	}
	_tmp32_ = i;
	i = _tmp32_ + 1;
	deja_dup_config_location_add_separator (self, _tmp32_, 1);
	_tmp33_ = i;
	i = _tmp33_ + 1;
	_tmp34_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("folder-remote");
	_tmp35_ = _tmp34_;
	_tmp36_ = _ ("SSH");
	_tmp37_ = deja_dup_config_location_ssh_new (self->priv->_label_sizes);
	_tmp38_ = g_object_ref_sink (_tmp37_);
	_tmp39_ = deja_dup_config_location_add_entry (self, _tmp33_, (GIcon*) _tmp35_, _tmp36_, 1, (GtkWidget*) _tmp38_, NULL);
	self->priv->index_ssh = _tmp39_;
	_g_object_unref0 (_tmp38_);
	_g_object_unref0 (_tmp35_);
	_tmp40_ = i;
	i = _tmp40_ + 1;
	_tmp41_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("folder-remote");
	_tmp42_ = _tmp41_;
	_tmp43_ = _ ("Windows Share");
	_tmp44_ = deja_dup_config_location_smb_new (self->priv->_label_sizes);
	_tmp45_ = g_object_ref_sink (_tmp44_);
	_tmp46_ = deja_dup_config_location_add_entry (self, _tmp40_, (GIcon*) _tmp42_, _tmp43_, 1, (GtkWidget*) _tmp45_, NULL);
	self->priv->index_smb = _tmp46_;
	_g_object_unref0 (_tmp45_);
	_g_object_unref0 (_tmp42_);
	_tmp47_ = i;
	i = _tmp47_ + 1;
	_tmp48_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("folder-remote");
	_tmp49_ = _tmp48_;
	_tmp50_ = _ ("FTP");
	_tmp51_ = deja_dup_config_location_ftp_new (self->priv->_label_sizes);
	_tmp52_ = g_object_ref_sink (_tmp51_);
	_tmp53_ = deja_dup_config_location_add_entry (self, _tmp47_, (GIcon*) _tmp49_, _tmp50_, 1, (GtkWidget*) _tmp52_, NULL);
	self->priv->index_ftp = _tmp53_;
	_g_object_unref0 (_tmp52_);
	_g_object_unref0 (_tmp49_);
	_tmp54_ = i;
	i = _tmp54_ + 1;
	_tmp55_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("folder-remote");
	_tmp56_ = _tmp55_;
	_tmp57_ = _ ("WebDAV");
	_tmp58_ = deja_dup_config_location_dav_new (self->priv->_label_sizes);
	_tmp59_ = g_object_ref_sink (_tmp58_);
	_tmp60_ = deja_dup_config_location_add_entry (self, _tmp54_, (GIcon*) _tmp56_, _tmp57_, 1, (GtkWidget*) _tmp59_, NULL);
	self->priv->index_dav = _tmp60_;
	_g_object_unref0 (_tmp59_);
	_g_object_unref0 (_tmp56_);
	_tmp61_ = i;
	i = _tmp61_ + 1;
	_tmp62_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("folder-remote");
	_tmp63_ = _tmp62_;
	_tmp64_ = _ ("Custom Location");
	_tmp65_ = deja_dup_config_location_custom_new (self->priv->_label_sizes);
	_tmp66_ = g_object_ref_sink (_tmp65_);
	_tmp67_ = deja_dup_config_location_add_entry (self, _tmp61_, (GIcon*) _tmp63_, _tmp64_, 2, (GtkWidget*) _tmp66_, NULL);
	self->priv->index_custom = _tmp67_;
	_g_object_unref0 (_tmp66_);
	_g_object_unref0 (_tmp63_);
	_tmp68_ = i;
	i = _tmp68_ + 1;
	deja_dup_config_location_add_separator (self, _tmp68_, 3);
	_tmp69_ = i;
	i = _tmp69_ + 1;
	_tmp70_ = (GThemedIcon*) g_themed_icon_new ("folder");
	_tmp71_ = _tmp70_;
	_tmp72_ = _ ("Local Folder");
	_tmp73_ = deja_dup_config_location_file_new (self->priv->_label_sizes);
	_tmp74_ = g_object_ref_sink (_tmp73_);
	_tmp75_ = deja_dup_config_location_add_entry (self, _tmp69_, (GIcon*) _tmp71_, _tmp72_, 4, (GtkWidget*) _tmp74_, NULL);
	self->priv->index_local = _tmp75_;
	_g_object_unref0 (_tmp74_);
	_g_object_unref0 (_tmp71_);
	self->priv->index_vol_base = i;
	_tmp76_ = g_volume_monitor_get ();
	mon = _tmp76_;
	g_object_ref ((GObject*) mon);
	_tmp77_ = g_volume_monitor_get_volumes (mon);
	vols = _tmp77_;
	{
		GList* v_collection;
		GList* v_it;
		v_collection = vols;
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
			GVolume* _tmp78_;
			GVolume* v;
			_tmp78_ = _g_object_ref0 ((GVolume*) v_it->data);
			v = _tmp78_;
			{
				gint _tmp79_;
				GIcon* _tmp80_ = NULL;
				const gchar* _tmp81_ = NULL;
				DejaDupConfigLocationVolume* _tmp82_ = NULL;
				DejaDupConfigLocationVolume* _tmp83_;
				const gchar* _tmp84_ = NULL;
				_tmp79_ = i;
				i = _tmp79_ + 1;
				_tmp80_ = g_volume_get_icon (v);
				_tmp81_ = g_volume_get_name (v);
				_tmp82_ = deja_dup_config_location_volume_new (self->priv->_label_sizes);
				_tmp83_ = g_object_ref_sink (_tmp82_);
				_tmp84_ = g_volume_get_identifier (v, G_VOLUME_IDENTIFIER_KIND_UUID);
				deja_dup_config_location_add_entry (self, _tmp79_, _tmp80_, _tmp81_, 3, (GtkWidget*) _tmp83_, _tmp84_);
				_g_object_unref0 (_tmp83_);
				_g_object_unref0 (v);
			}
		}
	}
	self->priv->index_vol_end = i;
	if (self->priv->index_vol_base != self->priv->index_vol_end) {
		gint _tmp85_;
		_tmp85_ = i;
		i = _tmp85_ + 1;
		deja_dup_config_location_add_separator (self, _tmp85_, 4);
	}
	deja_dup_config_location_update_saved_volume (self);
	_tmp86_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	pixrenderer = g_object_ref_sink (_tmp86_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->button, (GtkCellRenderer*) pixrenderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->button, (GtkCellRenderer*) pixrenderer, "gicon", DEJA_DUP_CONFIG_LOCATION_COL_ICON);
	_tmp87_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	textrenderer = g_object_ref_sink (_tmp87_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->button, (GtkCellRenderer*) textrenderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->button, (GtkCellRenderer*) textrenderer, "text", DEJA_DUP_CONFIG_LOCATION_COL_TEXT);
	deja_dup_config_widget_set_mnemonic_widget ((DejaDupConfigWidget*) self, (GtkWidget*) self->priv->button);
	gtk_combo_box_set_active (self->priv->button, 0);
	deja_dup_config_widget_set_from_config ((DejaDupConfigWidget*) self, NULL, NULL);
	deja_dup_config_location_handle_changed (self);
	g_signal_connect_object (self->priv->button, "changed", (GCallback) _deja_dup_config_location_handle_changed_gtk_combo_box_changed, self, 0);
	deja_dup_config_widget_watch_key ((DejaDupConfigWidget*) self, DEJA_DUP_BACKEND_KEY, NULL);
	_tmp88_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	_tmp89_ = _tmp88_;
	deja_dup_config_widget_watch_key ((DejaDupConfigWidget*) self, DEJA_DUP_FILE_PATH_KEY, (GSettings*) _tmp89_);
	_g_object_unref0 (_tmp89_);
	_g_object_unref0 (textrenderer);
	_g_object_unref0 (pixrenderer);
	__g_list_free__g_object_unref0_0 (vols);
	_g_object_unref0 (mon);
	_g_free0 (backend);
	_g_object_unref0 (vbox);
	return obj;
}


static void deja_dup_config_location_class_init (DejaDupConfigLocationClass * klass) {
	deja_dup_config_location_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupConfigLocationPrivate));
	DEJA_DUP_CONFIG_WIDGET_CLASS (klass)->set_from_config = deja_dup_config_location_real_set_from_config;
	DEJA_DUP_CONFIG_WIDGET_CLASS (klass)->set_from_config_finish = deja_dup_config_location_real_set_from_config_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_config_location_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_config_location_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_config_location_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_config_location_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_CONFIG_LOCATION_EXTRAS, g_param_spec_object ("extras", "extras", "extras", GTK_TYPE_EVENT_BOX, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_CONFIG_LOCATION_LABEL_SIZES, g_param_spec_object ("label-sizes", "label-sizes", "label-sizes", GTK_TYPE_SIZE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void deja_dup_config_location_instance_init (DejaDupConfigLocation * self) {
	self->priv = DEJA_DUP_CONFIG_LOCATION_GET_PRIVATE (self);
	self->priv->index_u1 = -2;
	self->priv->index_vol_saved = -2;
	self->priv->extras_max_width = 0;
	self->priv->extras_max_height = 0;
	self->priv->internal_set = FALSE;
}


static void deja_dup_config_location_finalize (GObject* obj) {
	DejaDupConfigLocation * self;
	self = DEJA_DUP_CONFIG_LOCATION (obj);
	_g_object_unref0 (self->priv->_extras);
	_g_object_unref0 (self->priv->_label_sizes);
	_g_object_unref0 (self->priv->button);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->sort_model);
	G_OBJECT_CLASS (deja_dup_config_location_parent_class)->finalize (obj);
}


GType deja_dup_config_location_get_type (void) {
	static volatile gsize deja_dup_config_location_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_config_location_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupConfigLocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_config_location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupConfigLocation), 0, (GInstanceInitFunc) deja_dup_config_location_instance_init, NULL };
		GType deja_dup_config_location_type_id;
		deja_dup_config_location_type_id = g_type_register_static (DEJA_DUP_TYPE_CONFIG_WIDGET, "DejaDupConfigLocation", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_config_location_type_id__volatile, deja_dup_config_location_type_id);
	}
	return deja_dup_config_location_type_id__volatile;
}


static void _vala_deja_dup_config_location_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupConfigLocation * self;
	self = DEJA_DUP_CONFIG_LOCATION (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_LOCATION_EXTRAS:
		g_value_set_object (value, deja_dup_config_location_get_extras (self));
		break;
		case DEJA_DUP_CONFIG_LOCATION_LABEL_SIZES:
		g_value_set_object (value, deja_dup_config_location_get_label_sizes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_deja_dup_config_location_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupConfigLocation * self;
	self = DEJA_DUP_CONFIG_LOCATION (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_LOCATION_EXTRAS:
		deja_dup_config_location_set_extras (self, g_value_get_object (value));
		break;
		case DEJA_DUP_CONFIG_LOCATION_LABEL_SIZES:
		deja_dup_config_location_set_label_sizes (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



