/* main.c generated by valac 0.12.0, the Vala compiler
 * generated from main.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <common.h>
#include <widgets.h>
#include <gio/gio.h>
#include <whacks.h>


#define TYPE_DEJA_DUP_APP (deja_dup_app_get_type ())
#define DEJA_DUP_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEJA_DUP_APP, DejaDupApp))
#define DEJA_DUP_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEJA_DUP_APP, DejaDupAppClass))
#define IS_DEJA_DUP_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEJA_DUP_APP))
#define IS_DEJA_DUP_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEJA_DUP_APP))
#define DEJA_DUP_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEJA_DUP_APP, DejaDupAppClass))

typedef struct _DejaDupApp DejaDupApp;
typedef struct _DejaDupAppClass DejaDupAppClass;
typedef struct _DejaDupAppPrivate DejaDupAppPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;

#define TYPE_ASSISTANT_RESTORE (assistant_restore_get_type ())
#define ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestore))
#define ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))
#define IS_ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_RESTORE))
#define IS_ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_RESTORE))
#define ASSISTANT_RESTORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))

typedef struct _AssistantRestore AssistantRestore;
typedef struct _AssistantRestoreClass AssistantRestoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_ASSISTANT_BACKUP (assistant_backup_get_type ())
#define ASSISTANT_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_BACKUP, AssistantBackup))
#define ASSISTANT_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_BACKUP, AssistantBackupClass))
#define IS_ASSISTANT_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_BACKUP))
#define IS_ASSISTANT_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_BACKUP))
#define ASSISTANT_BACKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_BACKUP, AssistantBackupClass))

typedef struct _AssistantBackup AssistantBackup;
typedef struct _AssistantBackupClass AssistantBackupClass;

#define TYPE_ASSISTANT_RESTORE_MISSING (assistant_restore_missing_get_type ())
#define ASSISTANT_RESTORE_MISSING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_RESTORE_MISSING, AssistantRestoreMissing))
#define ASSISTANT_RESTORE_MISSING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_RESTORE_MISSING, AssistantRestoreMissingClass))
#define IS_ASSISTANT_RESTORE_MISSING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_RESTORE_MISSING))
#define IS_ASSISTANT_RESTORE_MISSING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_RESTORE_MISSING))
#define ASSISTANT_RESTORE_MISSING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_RESTORE_MISSING, AssistantRestoreMissingClass))

typedef struct _AssistantRestoreMissing AssistantRestoreMissing;
typedef struct _AssistantRestoreMissingClass AssistantRestoreMissingClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

struct _DejaDupApp {
	GObject parent_instance;
	DejaDupAppPrivate * priv;
};

struct _DejaDupAppClass {
	GObjectClass parent_class;
};


extern GtkWindow* toplevel;
GtkWindow* toplevel = NULL;
static gpointer deja_dup_app_parent_class = NULL;
static gboolean deja_dup_app_valid_duplicity;
static gboolean deja_dup_app_valid_duplicity = FALSE;
static gboolean deja_dup_app_show_version;
static gboolean deja_dup_app_show_version = FALSE;
static gboolean deja_dup_app_restore_mode;
static gboolean deja_dup_app_restore_mode = FALSE;
static gboolean deja_dup_app_backup_mode;
static gboolean deja_dup_app_backup_mode = FALSE;
static gboolean deja_dup_app_restoremissing_mode;
static gboolean deja_dup_app_restoremissing_mode = FALSE;
static gchar** deja_dup_app_filenames;
static gint deja_dup_app_filenames_length1;
static gchar** deja_dup_app_filenames = NULL;
static gint deja_dup_app_filenames_length1 = 0;
static gint _deja_dup_app_filenames_size_ = 0;

GType deja_dup_app_get_type (void) G_GNUC_CONST;
enum  {
	DEJA_DUP_APP_DUMMY_PROPERTY
};
static gboolean deja_dup_app_handle_console_options (gint* status);
gint deja_dup_app_main (gchar** args, int args_length1);
AssistantRestore* assistant_restore_new_with_files (GList* files);
AssistantRestore* assistant_restore_construct_with_files (GType object_type, GList* files);
GType assistant_get_type (void) G_GNUC_CONST;
GType assistant_operation_get_type (void) G_GNUC_CONST;
GType assistant_restore_get_type (void) G_GNUC_CONST;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
AssistantBackup* assistant_backup_new (gboolean automatic);
AssistantBackup* assistant_backup_construct (GType object_type, gboolean automatic);
GType assistant_backup_get_type (void) G_GNUC_CONST;
AssistantRestoreMissing* assistant_restore_missing_new (GFile* list_dir);
AssistantRestoreMissing* assistant_restore_missing_construct (GType object_type, GFile* list_dir);
GType assistant_restore_missing_get_type (void) G_GNUC_CONST;
MainWindow* main_window_new (void);
MainWindow* main_window_construct (GType object_type);
GType main_window_get_type (void) G_GNUC_CONST;
DejaDupApp* deja_dup_app_new (void);
DejaDupApp* deja_dup_app_construct (GType object_type);
static void deja_dup_app_finalize (GObject* obj);

static const GOptionEntry DEJA_DUP_APP_options[6] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &deja_dup_app_show_version, "Show version", NULL}, {"restore", (gchar) 0, 0, G_OPTION_ARG_NONE, &deja_dup_app_restore_mode, "Restore given files", NULL}, {"backup", (gchar) 0, 0, G_OPTION_ARG_NONE, &deja_dup_app_backup_mode, "Immediately start a backup", NULL}, {"restore-missing", (gchar) 0, 0, G_OPTION_ARG_NONE, &deja_dup_app_restoremissing_mode, "Restore deleted files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &deja_dup_app_filenames, NULL, NULL}, {NULL}};

static gboolean deja_dup_app_handle_console_options (gint* status) {
	gint _status = 0;
	gboolean result = FALSE;
	_status = 0;
	if (deja_dup_app_show_version) {
		g_print ("%s %s\n", "deja-dup", VERSION);
		result = FALSE;
		if (status) {
			*status = _status;
		}
		return result;
	}
	if (deja_dup_app_restore_mode) {
		if (deja_dup_app_filenames == NULL) {
			const gchar* _tmp0_ = NULL;
			_tmp0_ = _ ("No filenames provided");
			g_printerr ("%s\n", _tmp0_);
			_status = 1;
			result = FALSE;
			if (status) {
				*status = _status;
			}
			return result;
		}
	}
	if (deja_dup_app_restoremissing_mode) {
		if (deja_dup_app_filenames == NULL) {
			const gchar* _tmp1_ = NULL;
			_tmp1_ = _ ("No directory provided");
			g_printerr ("%s\n", _tmp1_);
			_status = 1;
			result = FALSE;
			if (status) {
				*status = _status;
			}
			return result;
		} else {
			if (deja_dup_app_filenames_length1 > 1) {
				const gchar* _tmp2_ = NULL;
				_tmp2_ = _ ("Only one directory can be shown at once");
				g_printerr ("%s\n", _tmp2_);
				_status = 1;
				result = FALSE;
				if (status) {
					*status = _status;
				}
				return result;
			}
		}
	}
	result = TRUE;
	if (status) {
		*status = _status;
	}
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


gint deja_dup_app_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* modes;
	GOptionContext* _tmp4_ = NULL;
	GOptionContext* context;
	const gchar* _tmp5_ = NULL;
	GOptionGroup* _tmp6_ = NULL;
	gint status = 0;
	gint _tmp9_;
	gboolean _tmp10_;
	GtkIconTheme* _tmp11_ = NULL;
	gboolean _tmp12_;
	GError * _inner_error_ = NULL;
	deja_dup_i18n_setup ();
	_tmp0_ = _ ("Déjà Dup");
	g_set_application_name (_tmp0_);
	_tmp1_ = _ ("FILES");
	_tmp2_ = _ ("DIRECTORY");
	_tmp3_ = g_strdup_printf ("\n  %s --backup\n  %s --restore %s\n  %s --restore-missing %s", PACKAGE, PACKAGE, _tmp1_, PACKAGE, _tmp2_);
	modes = _tmp3_;
	_tmp4_ = g_option_context_new (modes);
	context = _tmp4_;
	_tmp5_ = _ ("Déjà Dup is a simple backup tool.  It hides the complexity of backing " \
"up\n" \
"the 'right way' (encrypted, off-site, and regular) and uses duplicity " \
"as\n" \
"the backend.");
	g_option_context_set_summary (context, _tmp5_);
	g_option_context_add_main_entries (context, DEJA_DUP_APP_options, GETTEXT_PACKAGE);
	_tmp6_ = gtk_get_option_group (FALSE);
	g_option_context_add_group (context, _tmp6_);
	g_option_context_parse (context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch9_g_error;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = g_option_context_get_help (context, TRUE, NULL);
		_tmp8_ = _tmp7_;
		g_printerr ("%s\n\n%s", e->message, _tmp8_);
		_g_free0 (_tmp8_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		_g_free0 (modes);
		return result;
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		_g_free0 (modes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp10_ = deja_dup_app_handle_console_options (&_tmp9_);
	status = _tmp9_;
	if (!_tmp10_) {
		result = status;
		_g_option_context_free0 (context);
		_g_free0 (modes);
		return result;
	}
	deja_dup_initialize ();
	gtk_init (&args_length1, &args);
	_tmp11_ = gtk_icon_theme_get_default ();
	gtk_icon_theme_append_search_path (_tmp11_, THEME_DIR);
	gtk_window_set_default_icon_name (PACKAGE);
	_tmp12_ = deja_dup_init_duplicity (NULL);
	deja_dup_app_valid_duplicity = _tmp12_;
	if (!deja_dup_app_valid_duplicity) {
		result = 1;
		_g_option_context_free0 (context);
		_g_free0 (modes);
		return result;
	}
	if (deja_dup_app_restore_mode) {
		GList* file_list;
		gint i;
		AssistantRestore* _tmp15_ = NULL;
		file_list = NULL;
		i = 0;
		while (TRUE) {
			gint _tmp13_;
			GFile* _tmp14_ = NULL;
			if (!(deja_dup_app_filenames[i] != NULL)) {
				break;
			}
			_tmp13_ = i;
			i = _tmp13_ + 1;
			_tmp14_ = g_file_new_for_commandline_arg (deja_dup_app_filenames[_tmp13_]);
			file_list = g_list_append (file_list, _tmp14_);
		}
		_tmp15_ = assistant_restore_new_with_files (file_list);
		_g_object_unref0 (toplevel);
		toplevel = (GtkWindow*) g_object_ref_sink (_tmp15_);
		gtk_widget_show_all ((GtkWidget*) toplevel);
		__g_list_free__g_object_unref0_0 (file_list);
	} else {
		if (deja_dup_app_backup_mode) {
			AssistantBackup* _tmp16_ = NULL;
			_tmp16_ = assistant_backup_new (TRUE);
			_g_object_unref0 (toplevel);
			toplevel = (GtkWindow*) g_object_ref_sink (_tmp16_);
		} else {
			if (deja_dup_app_restoremissing_mode) {
				GFile* _tmp17_ = NULL;
				GFile* list_directory;
				gboolean _tmp18_;
				GFileType _tmp20_;
				AssistantRestoreMissing* _tmp22_ = NULL;
				_tmp17_ = g_file_new_for_commandline_arg (deja_dup_app_filenames[0]);
				list_directory = _tmp17_;
				_tmp18_ = g_file_query_exists (list_directory, NULL);
				if (!_tmp18_) {
					const gchar* _tmp19_ = NULL;
					_tmp19_ = _ ("Directory does not exists");
					g_printerr ("%s\n", _tmp19_);
					result = 1;
					_g_object_unref0 (list_directory);
					_g_option_context_free0 (context);
					_g_free0 (modes);
					return result;
				}
				_tmp20_ = g_file_query_file_type (list_directory, 0, NULL);
				if (_tmp20_ != G_FILE_TYPE_DIRECTORY) {
					const gchar* _tmp21_ = NULL;
					_tmp21_ = _ ("You must provide a directory, not a file");
					g_printerr ("%s\n", _tmp21_);
					result = 1;
					_g_object_unref0 (list_directory);
					_g_option_context_free0 (context);
					_g_free0 (modes);
					return result;
				}
				_tmp22_ = assistant_restore_missing_new (list_directory);
				_g_object_unref0 (toplevel);
				toplevel = (GtkWindow*) g_object_ref_sink (_tmp22_);
				gtk_widget_show_all ((GtkWidget*) toplevel);
				_g_object_unref0 (list_directory);
			} else {
				MainWindow* _tmp23_ = NULL;
				_tmp23_ = main_window_new ();
				_g_object_unref0 (toplevel);
				toplevel = (GtkWindow*) g_object_ref_sink (_tmp23_);
				gtk_widget_show_all ((GtkWidget*) toplevel);
			}
		}
	}
	hacks_quit_on_destroy ((GtkWidget*) toplevel);
	gtk_main ();
	result = 0;
	_g_option_context_free0 (context);
	_g_free0 (modes);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return deja_dup_app_main (argv, argc);
}


DejaDupApp* deja_dup_app_construct (GType object_type) {
	DejaDupApp * self = NULL;
	self = (DejaDupApp*) g_object_new (object_type, NULL);
	return self;
}


DejaDupApp* deja_dup_app_new (void) {
	return deja_dup_app_construct (TYPE_DEJA_DUP_APP);
}


static void deja_dup_app_class_init (DejaDupAppClass * klass) {
	deja_dup_app_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = deja_dup_app_finalize;
}


static void deja_dup_app_instance_init (DejaDupApp * self) {
}


static void deja_dup_app_finalize (GObject* obj) {
	DejaDupApp * self;
	self = DEJA_DUP_APP (obj);
	G_OBJECT_CLASS (deja_dup_app_parent_class)->finalize (obj);
}


GType deja_dup_app_get_type (void) {
	static volatile gsize deja_dup_app_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupApp), 0, (GInstanceInitFunc) deja_dup_app_instance_init, NULL };
		GType deja_dup_app_type_id;
		deja_dup_app_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupApp", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_app_type_id__volatile, deja_dup_app_type_id);
	}
	return deja_dup_app_type_id__volatile;
}



