/* AssistantRestore.c generated by valac 0.12.0, the Vala compiler
 * generated from AssistantRestore.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008,2009 Michael Terry <mike@mterry.name>
    © 2010 Andrew Fister <temposs@gmail.com>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <common.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <widgets.h>
#include <glib/gi18n-lib.h>
#include <whacks.h>
#include <time.h>
#include <float.h>
#include <math.h>


#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;

#define TYPE_ASSISTANT_RESTORE (assistant_restore_get_type ())
#define ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestore))
#define ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))
#define IS_ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_RESTORE))
#define IS_ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_RESTORE))
#define ASSISTANT_RESTORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))

typedef struct _AssistantRestore AssistantRestore;
typedef struct _AssistantRestoreClass AssistantRestoreClass;
typedef struct _AssistantRestorePrivate AssistantRestorePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _deja_dup_operation_state_unref0(var) ((var == NULL) ? NULL : (var = (deja_dup_operation_state_unref (var), NULL)))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define TYPE_MOUNT_OPERATION_ASSISTANT (mount_operation_assistant_get_type ())
#define MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant))
#define MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))
#define IS_MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_OPERATION_ASSISTANT))
#define IS_MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_OPERATION_ASSISTANT))
#define MOUNT_OPERATION_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))

typedef struct _MountOperationAssistant MountOperationAssistant;
typedef struct _MountOperationAssistantClass MountOperationAssistantClass;
typedef struct _AssistantRestoreDoQueryData AssistantRestoreDoQueryData;

struct _Assistant {
	GtkDialog parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
	GList* current;
};

struct _AssistantClass {
	GtkDialogClass parent_class;
	void (*hide_for_now) (Assistant* self);
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	StatusIcon* status_icon;
	gboolean succeeded;
	GtkLabel* summary_label;
	DejaDupOperation* op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	gchar* (*get_progress_file_prefix) (AssistantOperation* self);
	void (*set_op_icon_name) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const gchar* _error_, const gchar* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*apply_finished) (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_cancel) (AssistantOperation* self);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantRestore {
	AssistantOperation parent_instance;
	AssistantRestorePrivate * priv;
	GList* _restore_files;
	DejaDupOperationStatus* query_op;
	DejaDupOperationState* op_state;
};

struct _AssistantRestoreClass {
	AssistantOperationClass parent_class;
	void (*handle_collection_dates) (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates);
	void (*query_finished) (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
};

struct _AssistantRestorePrivate {
	gchar* _restore_location;
	GtkProgressBar* query_progress_bar;
	guint query_timeout_id;
	GtkComboBox* date_combo;
	GtkListStore* date_store;
	GtkHBox* cust_box;
	GtkFileChooserButton* cust_button;
	GtkTable* confirm_table;
	gint confirm_location_row;
	GtkLabel* confirm_location_label;
	GtkLabel* confirm_location;
	gint confirm_date_row;
	GtkLabel* confirm_date_label;
	GtkLabel* confirm_date;
	gint confirm_files_row;
	GtkLabel* confirm_files_label;
	GtkVBox* confirm_files;
	GtkWidget* query_progress_page;
	GtkWidget* date_page;
	GtkWidget* restore_dest_page;
	gboolean got_dates;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;

struct _AssistantRestoreDoQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AssistantRestore* self;
	GdkWindow* _tmp0_;
	glong _tmp1_;
	glong xid;
	DejaDupOperationStatus* _tmp2_;
	DejaDupOperation* _tmp3_;
	DejaDupBackend* _tmp4_;
	MountOperationAssistant* _tmp5_;
	MountOperationAssistant* _tmp6_;
};


static gpointer assistant_restore_parent_class = NULL;

GType assistant_get_type (void) G_GNUC_CONST;
static gpointer assistant_page_info_ref (gpointer instance);
static void assistant_page_info_unref (gpointer instance);
static GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void assistant_value_set_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void assistant_value_take_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer assistant_value_get_page_info (const GValue* value) G_GNUC_UNUSED;
static GType assistant_page_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType assistant_operation_get_type (void) G_GNUC_CONST;
GType status_icon_get_type (void) G_GNUC_CONST;
GType assistant_restore_get_type (void) G_GNUC_CONST;
#define ASSISTANT_RESTORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_RESTORE, AssistantRestorePrivate))
enum  {
	ASSISTANT_RESTORE_DUMMY_PROPERTY,
	ASSISTANT_RESTORE_RESTORE_LOCATION,
	ASSISTANT_RESTORE_RESTORE_FILES
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
AssistantRestore* assistant_restore_new_with_files (GList* files);
AssistantRestore* assistant_restore_construct_with_files (GType object_type, GList* files);
AssistantOperation* assistant_operation_construct (GType object_type);
void assistant_restore_set_restore_files (AssistantRestore* self, GList* value);
static void assistant_restore_real_add_setup_pages (AssistantOperation* base);
static void assistant_restore_add_query_backend_page (AssistantRestore* self);
static void assistant_restore_add_date_page (AssistantRestore* self);
static void assistant_restore_add_restore_dest_page (AssistantRestore* self);
static GtkWidget* assistant_restore_make_backup_location_page (AssistantRestore* self);
static void assistant_restore_real_add_custom_config_pages (AssistantOperation* base);
GType assistant_type_get_type (void) G_GNUC_CONST;
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
static GtkWidget* assistant_restore_make_query_backend_page (AssistantRestore* self);
static GtkWidget* assistant_restore_make_date_page (AssistantRestore* self);
static GtkWidget* assistant_restore_make_restore_dest_page (AssistantRestore* self);
static void _lambda23_ (GtkToggleButton* r, AssistantRestore* self);
void assistant_restore_set_restore_location (AssistantRestore* self, const gchar* value);
static void __lambda23__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda24_ (GtkToggleButton* r, AssistantRestore* self);
static void __lambda24__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda25_ (GtkFileChooser* b, AssistantRestore* self);
static void __lambda25__gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self);
static GtkWidget* assistant_restore_real_make_confirm_page (AssistantOperation* base);
static DejaDupOperation* assistant_restore_real_create_op (AssistantOperation* base);
const gchar* assistant_restore_get_restore_location (AssistantRestore* self);
GList* assistant_restore_get_restore_files (AssistantRestore* self);
static gchar* assistant_restore_real_get_progress_file_prefix (AssistantOperation* base);
static void assistant_restore_real_set_op_icon_name (AssistantOperation* base);
static gboolean assistant_restore_is_same_day (AssistantRestore* self, GTimeVal* one, GTimeVal* two);
void assistant_restore_handle_collection_dates (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates);
static void assistant_restore_real_handle_collection_dates (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates);
static GTimeVal* _g_time_val_dup (GTimeVal* self);
void assistant_operation_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
void assistant_restore_query_finished (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
static void assistant_restore_real_query_finished (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
void assistant_operation_do_close (AssistantOperation* self);
void assistant_go_forward (Assistant* self);
static gboolean assistant_restore_query_pulse (AssistantRestore* self);
static void assistant_restore_do_query_data_free (gpointer _data);
void assistant_restore_do_query (AssistantRestore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void assistant_restore_do_query_finish (AssistantRestore* self, GAsyncResult* _res_);
static gboolean assistant_restore_do_query_co (AssistantRestoreDoQueryData* data);
static void _assistant_restore_handle_collection_dates_deja_dup_operation_status_collection_dates (DejaDupOperationStatus* _sender, GList* dates, gpointer self);
static void _assistant_restore_query_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, gpointer self);
MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist);
MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist);
GType mount_operation_assistant_get_type (void) G_GNUC_CONST;
void assistant_operation_get_passphrase (AssistantOperation* self);
static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static void _lambda26_ (DejaDupOperation* o, const gchar* e, const gchar* d, AssistantRestore* self);
static void __lambda26__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self);
static void assistant_restore_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page);
void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
void assistant_skip (Assistant* self);
GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
static void _lambda27_ (GtkWidget* w, AssistantRestore* self);
static void __lambda27__gtk_callback (GtkWidget* widget, gpointer self);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
static gboolean _assistant_restore_query_pulse_gsource_func (gpointer self);
void assistant_operation_provide_password (AssistantOperation* self);
static void assistant_restore_real_do_close (AssistantOperation* base);
AssistantRestore* assistant_restore_new (void);
AssistantRestore* assistant_restore_construct (GType object_type);
static GObject * assistant_restore_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void assistant_set_apply_text (Assistant* self, const gchar* value);
static void assistant_restore_finalize (GObject* obj);
static void _vala_assistant_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_assistant_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


AssistantRestore* assistant_restore_construct_with_files (GType object_type, GList* files) {
	AssistantRestore * self = NULL;
	self = (AssistantRestore*) assistant_operation_construct (object_type);
	assistant_restore_set_restore_files (self, files);
	return self;
}


AssistantRestore* assistant_restore_new_with_files (GList* files) {
	return assistant_restore_construct_with_files (TYPE_ASSISTANT_RESTORE, files);
}


static void assistant_restore_real_add_setup_pages (AssistantOperation* base) {
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	assistant_restore_add_query_backend_page (self);
	assistant_restore_add_date_page (self);
	assistant_restore_add_restore_dest_page (self);
}


static GtkWidget* assistant_restore_make_backup_location_page (AssistantRestore* self) {
	GtkWidget* result = NULL;
	gint rows;
	GtkWidget* w = NULL;
	GtkWidget* label = NULL;
	GtkSizeGroup* _tmp0_ = NULL;
	GtkSizeGroup* label_sizes;
	GtkTable* _tmp1_ = NULL;
	GtkTable* page;
	DejaDupConfigLocation* _tmp2_ = NULL;
	DejaDupConfigLocation* location;
	const gchar* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkEventBox* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	DejaDupConfigBool* _tmp7_ = NULL;
	GtkRequisition req = {0};
	GtkRequisition hidden = {0};
	GtkRequisition _tmp8_ = {0};
	GtkRequisition _tmp9_ = {0};
	GtkRequisition _tmp10_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	label_sizes = _tmp0_;
	_tmp1_ = (GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE);
	page = g_object_ref_sink (_tmp1_);
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	_tmp2_ = deja_dup_config_location_new (label_sizes);
	location = g_object_ref_sink (_tmp2_);
	_tmp3_ = _ ("_Backup location:");
	_tmp4_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp3_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp4_);
	g_object_set ((GObject*) label, "xalign", 0.0f, "mnemonic-widget", location, NULL);
	gtk_size_group_add_widget (label_sizes, label);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) location, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp5_ = deja_dup_config_location_get_extras (location);
	gtk_table_attach (page, (GtkWidget*) _tmp5_, (guint) 0, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp6_ = _ ("Backup files are _encrypted");
	_tmp7_ = deja_dup_config_bool_new (DEJA_DUP_ENCRYPT_KEY, _tmp6_, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp7_);
	gtk_table_attach (page, w, (guint) 0, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	gtk_widget_show_all ((GtkWidget*) page);
	hacks_get_natural_size ((GtkWidget*) page, &_tmp8_);
	req = _tmp8_;
	deja_dup_config_location_hidden_size (location, &_tmp9_);
	_tmp10_ = _tmp9_;
	hidden = _tmp10_;
	req.width = req.width + hidden.width;
	req.height = req.height + hidden.height;
	gtk_widget_set_size_request ((GtkWidget*) page, req.width, req.height);
	result = (GtkWidget*) page;
	_g_object_unref0 (location);
	_g_object_unref0 (label_sizes);
	_g_object_unref0 (label);
	_g_object_unref0 (w);
	return result;
}


static void assistant_restore_real_add_custom_config_pages (AssistantOperation* base) {
	AssistantRestore * self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	const gchar* _tmp1_ = NULL;
	self = (AssistantRestore*) base;
	_tmp0_ = assistant_restore_make_backup_location_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	_tmp1_ = _ ("Preferences");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	_g_object_unref0 (page);
}


static GtkWidget* assistant_restore_make_query_backend_page (AssistantRestore* self) {
	GtkWidget* result = NULL;
	GtkProgressBar* _tmp0_ = NULL;
	GtkVBox* _tmp1_ = NULL;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkProgressBar*) gtk_progress_bar_new ();
	_g_object_unref0 (self->priv->query_progress_bar);
	self->priv->query_progress_bar = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	page = g_object_ref_sink (_tmp1_);
	g_object_set ((GObject*) page, "child", self->priv->query_progress_bar, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->priv->query_progress_bar, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	return result;
}


static GtkWidget* assistant_restore_make_date_page (AssistantRestore* self) {
	GtkWidget* result = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* date_label;
	GtkHBox* _tmp4_ = NULL;
	GtkHBox* hbox;
	GtkVBox* _tmp5_ = NULL;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (self->priv->date_store);
	self->priv->date_store = _tmp0_;
	_tmp1_ = hacks_combo_box_text_new ();
	_g_object_unref0 (self->priv->date_combo);
	self->priv->date_combo = _tmp1_;
	gtk_combo_box_set_model (self->priv->date_combo, (GtkTreeModel*) self->priv->date_store);
	_tmp2_ = _ ("_Date:");
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	date_label = g_object_ref_sink (_tmp3_);
	g_object_set ((GObject*) date_label, "mnemonic-widget", self->priv->date_combo, "use-underline", TRUE, "xalign", 0.0f, NULL);
	_tmp4_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hbox = g_object_ref_sink (_tmp4_);
	g_object_set ((GObject*) hbox, "child", date_label, "child", self->priv->date_combo, NULL);
	_tmp5_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	page = g_object_ref_sink (_tmp5_);
	g_object_set ((GObject*) page, "child", hbox, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) hbox, (GtkWidget*) date_label, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) hbox, (GtkWidget*) self->priv->date_combo, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) hbox, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (hbox);
	_g_object_unref0 (date_label);
	return result;
}


static void _lambda23_ (GtkToggleButton* r, AssistantRestore* self) {
	gboolean _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = gtk_toggle_button_get_active (r);
	if (_tmp0_) {
		assistant_restore_set_restore_location (self, "/");
	}
}


static void __lambda23__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda23_ (_sender, self);
}


static void _lambda24_ (GtkToggleButton* r, AssistantRestore* self) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	g_return_if_fail (r != NULL);
	_tmp0_ = gtk_toggle_button_get_active (r);
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = gtk_file_chooser_get_filename ((GtkFileChooser*) self->priv->cust_button);
		_tmp2_ = _tmp1_;
		assistant_restore_set_restore_location (self, _tmp2_);
		_g_free0 (_tmp2_);
	}
	_tmp3_ = gtk_toggle_button_get_active (r);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->cust_box, _tmp3_);
}


static void __lambda24__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda24_ (_sender, self);
}


static void _lambda25_ (GtkFileChooser* b, AssistantRestore* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (b != NULL);
	_tmp0_ = gtk_file_chooser_get_filename (b);
	_tmp1_ = _tmp0_;
	assistant_restore_set_restore_location (self, _tmp1_);
	_g_free0 (_tmp1_);
}


static void __lambda25__gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self) {
	_lambda25_ (_sender, self);
}


static GtkWidget* assistant_restore_make_restore_dest_page (AssistantRestore* self) {
	GtkWidget* result = NULL;
	GtkRadioButton* _tmp0_ = NULL;
	GtkRadioButton* orig_radio;
	const gchar* _tmp1_ = NULL;
	GtkRadioButton* _tmp2_ = NULL;
	GtkRadioButton* cust_radio;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkFileChooserButton* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_;
	GtkLabel* cust_label;
	GtkHBox* _tmp11_ = NULL;
	GtkVBox* _tmp12_ = NULL;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	orig_radio = g_object_ref_sink (_tmp0_);
	_tmp1_ = _ ("Restore files to _original locations");
	g_object_set ((GObject*) orig_radio, "label", _tmp1_, "use-underline", TRUE, NULL);
	g_signal_connect_object ((GtkToggleButton*) orig_radio, "toggled", (GCallback) __lambda23__gtk_toggle_button_toggled, self, 0);
	_tmp2_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	cust_radio = g_object_ref_sink (_tmp2_);
	_tmp3_ = _ ("Restore to _specific folder");
	g_object_set ((GObject*) cust_radio, "label", _tmp3_, "use-underline", TRUE, "group", orig_radio, NULL);
	g_signal_connect_object ((GtkToggleButton*) cust_radio, "toggled", (GCallback) __lambda24__gtk_toggle_button_toggled, self, 0);
	_tmp4_ = _ ("Choose destination for restored files");
	_tmp5_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp4_, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	_g_object_unref0 (self->priv->cust_button);
	self->priv->cust_button = g_object_ref_sink (_tmp5_);
	g_signal_connect_object ((GtkFileChooser*) self->priv->cust_button, "selection-changed", (GCallback) __lambda25__gtk_file_chooser_selection_changed, self, 0);
	_tmp6_ = _ ("Restore _folder:");
	_tmp7_ = g_strconcat ("    ", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
	_tmp10_ = g_object_ref_sink (_tmp9_);
	_g_free0 (_tmp8_);
	cust_label = _tmp10_;
	g_object_set ((GObject*) cust_label, "mnemonic-widget", self->priv->cust_button, "use-underline", TRUE, "xalign", 0.0f, NULL);
	_tmp11_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	_g_object_unref0 (self->priv->cust_box);
	self->priv->cust_box = g_object_ref_sink (_tmp11_);
	g_object_set ((GObject*) self->priv->cust_box, "child", cust_label, "child", self->priv->cust_button, "sensitive", FALSE, NULL);
	_tmp12_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	page = g_object_ref_sink (_tmp12_);
	g_object_set ((GObject*) page, "child", orig_radio, "child", cust_radio, "child", self->priv->cust_box, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) orig_radio, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) cust_radio, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->priv->cust_box, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (cust_label);
	_g_object_unref0 (cust_radio);
	_g_object_unref0 (orig_radio);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GtkWidget* assistant_restore_real_make_confirm_page (AssistantOperation* base) {
	AssistantRestore * self;
	GtkWidget* result = NULL;
	gint rows;
	GtkWidget* label = NULL;
	GtkWidget* w = NULL;
	GtkTable* _tmp0_ = NULL;
	GtkTable* _tmp1_;
	GtkTable* page;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	DejaDupConfigLabelLocation* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	DejaDupConfigLabelBool* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkVBox* _tmp15_ = NULL;
	self = (AssistantRestore*) base;
	rows = 0;
	_tmp0_ = (GtkTable*) gtk_table_new ((guint) rows, (guint) 3, FALSE);
	_g_object_unref0 (self->priv->confirm_table);
	self->priv->confirm_table = g_object_ref_sink (_tmp0_);
	_tmp1_ = _g_object_ref0 (self->priv->confirm_table);
	page = _tmp1_;
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	_tmp2_ = _ ("Backup location:");
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp3_);
	g_object_set ((GObject*) label, "xalign", 0.0f, NULL);
	_tmp4_ = deja_dup_config_label_location_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp4_);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp5_ = _ ("Encrypted:");
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp6_);
	g_object_set ((GObject*) label, "xalign", 0.0f, NULL);
	_tmp7_ = deja_dup_config_label_bool_new (DEJA_DUP_ENCRYPT_KEY, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp7_);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp8_ = _ ("Restore date:");
	_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
	_g_object_unref0 (self->priv->confirm_date_label);
	self->priv->confirm_date_label = g_object_ref_sink (_tmp9_);
	g_object_set ((GObject*) self->priv->confirm_date_label, "xalign", 0.0f, NULL);
	_tmp10_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->confirm_date);
	self->priv->confirm_date = g_object_ref_sink (_tmp10_);
	g_object_set ((GObject*) self->priv->confirm_date, "xalign", 0.0f, NULL);
	self->priv->confirm_date_row = rows;
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_date_label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_date, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp11_ = _ ("Restore folder:");
	_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
	_g_object_unref0 (self->priv->confirm_location_label);
	self->priv->confirm_location_label = g_object_ref_sink (_tmp12_);
	g_object_set ((GObject*) self->priv->confirm_location_label, "xalign", 0.0f, NULL);
	_tmp13_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->confirm_location);
	self->priv->confirm_location = g_object_ref_sink (_tmp13_);
	g_object_set ((GObject*) self->priv->confirm_location, "xalign", 0.0f, NULL);
	self->priv->confirm_location_row = rows;
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_location_label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_location, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp14_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->confirm_files_label);
	self->priv->confirm_files_label = g_object_ref_sink (_tmp14_);
	g_object_set ((GObject*) self->priv->confirm_files_label, "xalign", 0.0f, "yalign", 0.0f, NULL);
	_tmp15_ = (GtkVBox*) gtk_vbox_new (TRUE, 6);
	_g_object_unref0 (self->priv->confirm_files);
	self->priv->confirm_files = g_object_ref_sink (_tmp15_);
	self->priv->confirm_files_row = rows;
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_files_label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_files, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	result = (GtkWidget*) page;
	_g_object_unref0 (w);
	_g_object_unref0 (label);
	return result;
}


static void assistant_restore_add_query_backend_page (AssistantRestore* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	const gchar* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_restore_make_query_backend_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_PROGRESS);
	_tmp1_ = _ ("Checking for Backups…");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	_tmp2_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->query_progress_page);
	self->priv->query_progress_page = _tmp2_;
	_g_object_unref0 (page);
}


static void assistant_restore_add_date_page (AssistantRestore* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	const gchar* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_restore_make_date_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	_tmp1_ = _ ("Restore from When?");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	_tmp2_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->date_page);
	self->priv->date_page = _tmp2_;
	_g_object_unref0 (page);
}


static void assistant_restore_add_restore_dest_page (AssistantRestore* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	const gchar* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_restore_make_restore_dest_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	_tmp1_ = _ ("Restore to Where?");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	_tmp2_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->restore_dest_page);
	self->priv->restore_dest_page = _tmp2_;
	_g_object_unref0 (page);
}


static DejaDupOperation* assistant_restore_real_create_op (AssistantOperation* base) {
	AssistantRestore * self;
	DejaDupOperation* result = NULL;
	gchar* date;
	GdkWindow* _tmp2_ = NULL;
	glong _tmp3_;
	glong xid;
	GList* _tmp4_ = NULL;
	DejaDupOperationRestore* _tmp5_ = NULL;
	DejaDupOperationRestore* rest_op;
	self = (AssistantRestore*) base;
	date = NULL;
	if (self->priv->got_dates) {
		GtkTreeIter iter = {0};
		GtkTreeIter _tmp0_ = {0};
		gboolean _tmp1_;
		_tmp1_ = gtk_combo_box_get_active_iter (self->priv->date_combo, &_tmp0_);
		iter = _tmp0_;
		if (_tmp1_) {
			gtk_tree_model_get ((GtkTreeModel*) self->priv->date_store, &iter, 1, &date, -1);
		}
	}
	gtk_widget_realize ((GtkWidget*) self);
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp3_ = hacks_window_get_xid (_tmp2_);
	xid = _tmp3_;
	_tmp4_ = assistant_restore_get_restore_files (self);
	_tmp5_ = deja_dup_operation_restore_new (self->priv->_restore_location, date, _tmp4_, (guint) xid);
	rest_op = _tmp5_;
	if (self->op_state != NULL) {
		deja_dup_operation_set_state ((DejaDupOperation*) rest_op, self->op_state);
	}
	result = (DejaDupOperation*) rest_op;
	_g_free0 (date);
	return result;
}


static gchar* assistant_restore_real_get_progress_file_prefix (AssistantOperation* base) {
	AssistantRestore * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self = (AssistantRestore*) base;
	_tmp0_ = _ ("Restoring:");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void assistant_restore_real_set_op_icon_name (AssistantOperation* base) {
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	gtk_window_set_icon_name ((GtkWindow*) self, "deja-dup-restore");
}


static gboolean assistant_restore_is_same_day (AssistantRestore* self, GTimeVal* one, GTimeVal* two) {
	gboolean result = FALSE;
	GDate day1 = {0};
	GDate day2 = {0};
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&day1, 0, sizeof (GDate));
	memset (&day2, 0, sizeof (GDate));
	g_date_set_time_val (&day1, one);
	g_date_set_time_val (&day2, two);
	_tmp0_ = g_date_compare (&day1, &day2);
	result = _tmp0_ == 0;
	return result;
}


static GTimeVal* _g_time_val_dup (GTimeVal* self) {
	GTimeVal* dup;
	dup = g_new0 (GTimeVal, 1);
	memcpy (dup, self, sizeof (GTimeVal));
	return dup;
}


static gpointer __g_time_val_dup0 (gpointer self) {
	return self ? _g_time_val_dup (self) : NULL;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = 64;
	strftime (buffer, buffer_length1, format, &(*self));
	_tmp1_ = g_strdup ((const gchar*) buffer);
	result = _tmp1_;
	buffer = (g_free (buffer), NULL);
	return result;
}


static void _g_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void assistant_restore_real_handle_collection_dates (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates) {
	GList* timevals;
	GTimeVal tv = {0};
	gint _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	timevals = NULL;
	g_get_current_time (&tv);
	self->priv->got_dates = TRUE;
	gtk_list_store_clear (self->priv->date_store);
	{
		GList* date_collection;
		GList* date_it;
		date_collection = dates;
		for (date_it = date_collection; date_it != NULL; date_it = date_it->next) {
			gchar* _tmp0_;
			gchar* date;
			_tmp0_ = g_strdup ((const gchar*) date_it->data);
			date = _tmp0_;
			{
				gboolean _tmp1_;
				_tmp1_ = g_time_val_from_iso8601 (date, &tv);
				if (_tmp1_) {
					GTimeVal* _tmp2_;
					_tmp2_ = __g_time_val_dup0 (&tv);
					timevals = g_list_append (timevals, _tmp2_);
				}
				_g_free0 (date);
			}
		}
	}
	{
		GList* i;
		i = timevals;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar* _tmp4_;
				gchar* format;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				struct tm _tmp12_ = {0};
				struct tm _tmp13_ = {0};
				struct tm t;
				gchar* _tmp14_ = NULL;
				gchar* user_str;
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp15_ = {0};
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				if (!_tmp3_) {
					i = i->next;
				}
				_tmp3_ = FALSE;
				if (!(i != NULL)) {
					break;
				}
				tv = *((GTimeVal*) i->data);
				_tmp4_ = g_strdup ("%x");
				format = _tmp4_;
				if (i->prev != NULL) {
					gboolean _tmp7_;
					_tmp7_ = assistant_restore_is_same_day (self, (GTimeVal*) i->prev->data, &tv);
					_tmp6_ = _tmp7_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_tmp5_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (i->next != NULL) {
						gboolean _tmp9_;
						_tmp9_ = assistant_restore_is_same_day (self, (GTimeVal*) i->next->data, &tv);
						_tmp8_ = _tmp9_;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp5_ = _tmp8_;
				}
				if (_tmp5_) {
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					_tmp10_ = _ ("%x %X");
					_tmp11_ = g_strdup (_tmp10_);
					_g_free0 (format);
					format = _tmp11_;
				}
				g_time_local ((time_t) tv.tv_sec, &_tmp12_);
				_tmp13_ = _tmp12_;
				t = _tmp13_;
				_tmp14_ = g_time_format (&t, format);
				user_str = _tmp14_;
				gtk_list_store_prepend (self->priv->date_store, &_tmp15_);
				iter = _tmp15_;
				_tmp16_ = g_time_val_to_iso8601 (&tv);
				_tmp17_ = _tmp16_;
				gtk_list_store_set (self->priv->date_store, &iter, 0, user_str, 1, _tmp17_, -1);
				_g_free0 (_tmp17_);
				gtk_combo_box_set_active_iter (self->priv->date_combo, &iter);
				_g_free0 (user_str);
				_g_free0 (format);
			}
		}
	}
	_tmp18_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) self->priv->date_store, NULL);
	if (_tmp18_ == 0) {
		const gchar* _tmp19_ = NULL;
		_tmp19_ = _ ("No backups to restore");
		assistant_operation_show_error ((AssistantOperation*) self, _tmp19_, NULL);
	}
	__g_list_free__g_free0_0 (timevals);
}


void assistant_restore_handle_collection_dates (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates) {
	ASSISTANT_RESTORE_GET_CLASS (self)->handle_collection_dates (self, op, dates);
}


static void assistant_restore_real_query_finished (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled) {
	DejaDupOperationState* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	_tmp0_ = deja_dup_operation_get_state (op);
	_deja_dup_operation_state_unref0 (self->op_state);
	self->op_state = _tmp0_;
	_g_object_unref0 (self->query_op);
	self->query_op = NULL;
	_g_object_unref0 (((AssistantOperation*) self)->op);
	((AssistantOperation*) self)->op = NULL;
	if (cancelled) {
		assistant_operation_do_close ((AssistantOperation*) self);
	} else {
		if (success) {
			assistant_go_forward ((Assistant*) self);
		}
	}
}


void assistant_restore_query_finished (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled) {
	ASSISTANT_RESTORE_GET_CLASS (self)->query_finished (self, op, success, cancelled);
}


static gboolean assistant_restore_query_pulse (AssistantRestore* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_progress_bar_pulse (self->priv->query_progress_bar);
	result = TRUE;
	return result;
}


static void assistant_restore_do_query_data_free (gpointer _data) {
	AssistantRestoreDoQueryData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (AssistantRestoreDoQueryData, data);
}


void assistant_restore_do_query (AssistantRestore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AssistantRestoreDoQueryData* _data_;
	_data_ = g_slice_new0 (AssistantRestoreDoQueryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, assistant_restore_do_query);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, assistant_restore_do_query_data_free);
	_data_->self = _g_object_ref0 (self);
	assistant_restore_do_query_co (_data_);
}


void assistant_restore_do_query_finish (AssistantRestore* self, GAsyncResult* _res_) {
	AssistantRestoreDoQueryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _assistant_restore_handle_collection_dates_deja_dup_operation_status_collection_dates (DejaDupOperationStatus* _sender, GList* dates, gpointer self) {
	assistant_restore_handle_collection_dates (self, _sender, dates);
}


static void _assistant_restore_query_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, gpointer self) {
	assistant_restore_query_finished (self, _sender, success, cancelled);
}


static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	assistant_operation_get_passphrase (self);
}


static void _lambda26_ (DejaDupOperation* o, const gchar* e, const gchar* d, AssistantRestore* self) {
	g_return_if_fail (o != NULL);
	g_return_if_fail (e != NULL);
	assistant_operation_show_error ((AssistantOperation*) self, e, d);
}


static void __lambda26__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self) {
	_lambda26_ (_sender, errstr, detail, self);
}


static gboolean assistant_restore_do_query_co (AssistantRestoreDoQueryData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	gtk_widget_realize ((GtkWidget*) data->self);
	data->_tmp0_ = NULL;
	data->_tmp0_ = gtk_widget_get_window ((GtkWidget*) data->self);
	data->_tmp1_ = hacks_window_get_xid (data->_tmp0_);
	data->xid = data->_tmp1_;
	data->_tmp2_ = NULL;
	data->_tmp2_ = deja_dup_operation_status_new ((guint) data->xid);
	_g_object_unref0 (data->self->query_op);
	data->self->query_op = data->_tmp2_;
	g_signal_connect_object (data->self->query_op, "collection-dates", (GCallback) _assistant_restore_handle_collection_dates_deja_dup_operation_status_collection_dates, data->self, 0);
	g_signal_connect_object ((DejaDupOperation*) data->self->query_op, "done", (GCallback) _assistant_restore_query_finished_deja_dup_operation_done, data->self, 0);
	data->_tmp3_ = _g_object_ref0 ((DejaDupOperation*) data->self->query_op);
	_g_object_unref0 (((AssistantOperation*) data->self)->op);
	((AssistantOperation*) data->self)->op = data->_tmp3_;
	data->_tmp4_ = NULL;
	data->_tmp4_ = deja_dup_operation_get_backend (((AssistantOperation*) data->self)->op);
	data->_tmp5_ = NULL;
	data->_tmp5_ = mount_operation_assistant_new ((AssistantOperation*) data->self);
	data->_tmp6_ = data->_tmp5_;
	deja_dup_backend_set_mount_op (data->_tmp4_, (GMountOperation*) data->_tmp6_);
	_g_object_unref0 (data->_tmp6_);
	g_signal_connect_object (((AssistantOperation*) data->self)->op, "passphrase-required", (GCallback) _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required, (AssistantOperation*) data->self, 0);
	g_signal_connect_object (((AssistantOperation*) data->self)->op, "raise-error", (GCallback) __lambda26__deja_dup_operation_raise_error, data->self, 0);
	deja_dup_operation_start ((DejaDupOperation*) data->self->query_op, NULL, NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _lambda27_ (GtkWidget* w, AssistantRestore* self) {
	g_return_if_fail (w != NULL);
	hacks_widget_destroy (w);
}


static void __lambda27__gtk_callback (GtkWidget* widget, gpointer self) {
	_lambda27_ (widget, self);
}


static gboolean _assistant_restore_query_pulse_gsource_func (gpointer self) {
	gboolean result;
	result = assistant_restore_query_pulse (self);
	return result;
}


static void assistant_restore_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page) {
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	ASSISTANT_OPERATION_CLASS (assistant_restore_parent_class)->do_prepare (ASSISTANT_OPERATION (self), assist, page);
	if (self->priv->query_timeout_id > 0) {
		g_source_remove (self->priv->query_timeout_id);
		self->priv->query_timeout_id = (guint) 0;
	}
	if (page == self->priv->date_page) {
		if (!self->priv->got_dates) {
			assistant_skip ((Assistant*) self);
		}
	} else {
		if (page == self->priv->restore_dest_page) {
			GList* _tmp0_ = NULL;
			_tmp0_ = assistant_restore_get_restore_files (self);
			if (_tmp0_ != NULL) {
				assistant_skip ((Assistant*) self);
			}
		} else {
			GtkWidget* _tmp1_ = NULL;
			_tmp1_ = assistant_operation_get_confirm_page ((AssistantOperation*) self);
			if (page == _tmp1_) {
				GList* _tmp5_ = NULL;
				if (self->priv->got_dates) {
					gchar* _tmp2_ = NULL;
					gchar* _tmp3_;
					guint _tmp4_;
					_tmp2_ = hacks_combo_box_get_text (self->priv->date_combo);
					_tmp3_ = _tmp2_;
					gtk_label_set_label (self->priv->confirm_date, _tmp3_);
					_g_free0 (_tmp3_);
					gtk_widget_show ((GtkWidget*) self->priv->confirm_date_label);
					gtk_widget_show ((GtkWidget*) self->priv->confirm_date);
					_tmp4_ = gtk_table_get_default_row_spacing (self->priv->confirm_table);
					gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_date_row, _tmp4_);
				} else {
					gtk_widget_hide ((GtkWidget*) self->priv->confirm_date_label);
					gtk_widget_hide ((GtkWidget*) self->priv->confirm_date);
					gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_date_row, (guint) 0);
				}
				_tmp5_ = assistant_restore_get_restore_files (self);
				if (_tmp5_ == NULL) {
					guint _tmp11_;
					if (g_strcmp0 (self->priv->_restore_location, "/") == 0) {
						const gchar* _tmp6_ = NULL;
						_tmp6_ = _ ("Original location");
						gtk_label_set_label (self->priv->confirm_location, _tmp6_);
					} else {
						GFile* _tmp7_ = NULL;
						GFile* _tmp8_;
						gchar* _tmp9_ = NULL;
						gchar* _tmp10_;
						_tmp7_ = g_file_new_for_path (self->priv->_restore_location);
						_tmp8_ = _tmp7_;
						_tmp9_ = deja_dup_get_file_desc (_tmp8_);
						_tmp10_ = _tmp9_;
						gtk_label_set_label (self->priv->confirm_location, _tmp10_);
						_g_free0 (_tmp10_);
						_g_object_unref0 (_tmp8_);
					}
					gtk_widget_show ((GtkWidget*) self->priv->confirm_location_label);
					gtk_widget_show ((GtkWidget*) self->priv->confirm_location);
					_tmp11_ = gtk_table_get_default_row_spacing (self->priv->confirm_table);
					gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_location_row, _tmp11_);
					gtk_widget_hide ((GtkWidget*) self->priv->confirm_files_label);
					gtk_widget_hide ((GtkWidget*) self->priv->confirm_files);
					gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_files_row, (guint) 0);
				} else {
					GList* _tmp12_ = NULL;
					guint _tmp13_;
					const gchar* _tmp14_ = NULL;
					GList* _tmp15_ = NULL;
					guint _tmp22_;
					_tmp12_ = assistant_restore_get_restore_files (self);
					_tmp13_ = g_list_length (_tmp12_);
					_tmp14_ = ngettext ("File to restore:", "Files to restore:", (gulong) _tmp13_);
					gtk_label_set_label (self->priv->confirm_files_label, _tmp14_);
					gtk_container_foreach ((GtkContainer*) self->priv->confirm_files, __lambda27__gtk_callback, self);
					_tmp15_ = assistant_restore_get_restore_files (self);
					{
						GList* f_collection;
						GList* f_it;
						f_collection = _tmp15_;
						for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
							GFile* _tmp16_;
							GFile* f;
							_tmp16_ = _g_object_ref0 ((GFile*) f_it->data);
							f = _tmp16_;
							{
								gchar* _tmp17_ = NULL;
								gchar* parse_name;
								gchar* _tmp18_ = NULL;
								gchar* _tmp19_;
								GtkLabel* _tmp20_ = NULL;
								GtkLabel* _tmp21_;
								GtkLabel* file_label;
								_tmp17_ = g_file_get_parse_name (f);
								parse_name = _tmp17_;
								_tmp18_ = g_path_get_basename (parse_name);
								_tmp19_ = _tmp18_;
								_tmp20_ = (GtkLabel*) gtk_label_new (_tmp19_);
								_tmp21_ = g_object_ref_sink (_tmp20_);
								_g_free0 (_tmp19_);
								file_label = _tmp21_;
								gtk_widget_set_tooltip_text ((GtkWidget*) file_label, parse_name);
								g_object_set ((GObject*) file_label, "xalign", 0.0f, NULL);
								gtk_container_add ((GtkContainer*) self->priv->confirm_files, (GtkWidget*) file_label);
								_g_object_unref0 (file_label);
								_g_free0 (parse_name);
								_g_object_unref0 (f);
							}
						}
					}
					gtk_widget_hide ((GtkWidget*) self->priv->confirm_location_label);
					gtk_widget_hide ((GtkWidget*) self->priv->confirm_location);
					gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_location_row, (guint) 0);
					gtk_widget_show ((GtkWidget*) self->priv->confirm_files_label);
					gtk_widget_show_all ((GtkWidget*) self->priv->confirm_files);
					_tmp22_ = gtk_table_get_default_row_spacing (self->priv->confirm_table);
					gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_files_row, _tmp22_);
				}
			} else {
				GtkWidget* _tmp23_ = NULL;
				_tmp23_ = assistant_operation_get_summary_page ((AssistantOperation*) self);
				if (page == _tmp23_) {
					gboolean _tmp24_;
					_tmp24_ = assistant_operation_get_error_occurred ((AssistantOperation*) self);
					if (_tmp24_) {
						const gchar* _tmp25_ = NULL;
						_tmp25_ = _ ("Restore Failed");
						assistant_set_page_title ((Assistant*) self, page, _tmp25_);
					} else {
						const gchar* _tmp26_ = NULL;
						GList* _tmp27_ = NULL;
						_tmp26_ = _ ("Restore Finished");
						assistant_set_page_title ((Assistant*) self, page, _tmp26_);
						_tmp27_ = assistant_restore_get_restore_files (self);
						if (_tmp27_ == NULL) {
							const gchar* _tmp28_ = NULL;
							_tmp28_ = _ ("Your files were successfully restored.");
							gtk_label_set_label (((AssistantOperation*) self)->summary_label, _tmp28_);
						} else {
							GList* _tmp29_ = NULL;
							guint _tmp30_;
							const gchar* _tmp31_ = NULL;
							_tmp29_ = assistant_restore_get_restore_files (self);
							_tmp30_ = g_list_length (_tmp29_);
							_tmp31_ = ngettext ("Your file was successfully restored.", "Your files were successfully restored.", (gulong) _tmp30_);
							gtk_label_set_label (((AssistantOperation*) self)->summary_label, _tmp31_);
						}
					}
				} else {
					GtkWidget* _tmp32_ = NULL;
					_tmp32_ = assistant_operation_get_progress_page ((AssistantOperation*) self);
					if (page == _tmp32_) {
						const gchar* _tmp33_ = NULL;
						_tmp33_ = _ ("Restoring…");
						assistant_set_page_title ((Assistant*) self, page, _tmp33_);
					} else {
						if (page == self->priv->query_progress_page) {
							guint _tmp34_;
							gboolean _tmp35_ = FALSE;
							gtk_progress_bar_set_fraction (self->priv->query_progress_bar, (gdouble) 0);
							_tmp34_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _assistant_restore_query_pulse_gsource_func, g_object_ref (self), g_object_unref);
							self->priv->query_timeout_id = _tmp34_;
							if (self->query_op != NULL) {
								gboolean _tmp36_;
								_tmp36_ = deja_dup_operation_get_needs_password ((DejaDupOperation*) self->query_op);
								_tmp35_ = _tmp36_;
							} else {
								_tmp35_ = FALSE;
							}
							if (_tmp35_) {
								assistant_operation_provide_password ((AssistantOperation*) self);
							} else {
								if (self->query_op == NULL) {
									assistant_restore_do_query (self, NULL, NULL);
								}
							}
						}
					}
				}
			}
		}
	}
}


static void assistant_restore_real_do_close (AssistantOperation* base) {
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	if (self->priv->query_timeout_id > 0) {
		g_source_remove (self->priv->query_timeout_id);
		self->priv->query_timeout_id = (guint) 0;
	}
	ASSISTANT_OPERATION_CLASS (assistant_restore_parent_class)->do_close (ASSISTANT_OPERATION (self));
}


AssistantRestore* assistant_restore_construct (GType object_type) {
	AssistantRestore * self = NULL;
	self = (AssistantRestore*) assistant_operation_construct (object_type);
	return self;
}


AssistantRestore* assistant_restore_new (void) {
	return assistant_restore_construct (TYPE_ASSISTANT_RESTORE);
}


const gchar* assistant_restore_get_restore_location (AssistantRestore* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_restore_location;
	return result;
}


void assistant_restore_set_restore_location (AssistantRestore* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_restore_location);
	self->priv->_restore_location = _tmp0_;
	g_object_notify ((GObject *) self, "restore-location");
}


GList* assistant_restore_get_restore_files (AssistantRestore* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->_restore_files;
	return result;
}


void assistant_restore_set_restore_files (AssistantRestore* self, GList* value) {
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp0_;
			GFile* f;
			_tmp0_ = _g_object_ref0 ((GFile*) f_it->data);
			f = _tmp0_;
			{
				g_object_unref ((GObject*) f);
				_g_object_unref0 (f);
			}
		}
	}
	_tmp1_ = g_list_copy (value);
	__g_list_free__g_object_unref0_0 (self->_restore_files);
	self->_restore_files = _tmp1_;
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp2_;
			GFile* f;
			_tmp2_ = _g_object_ref0 ((GFile*) f_it->data);
			f = _tmp2_;
			{
				g_object_ref ((GObject*) f);
				_g_object_unref0 (f);
			}
		}
	}
	g_object_notify ((GObject *) self, "restore-files");
}


static GObject * assistant_restore_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AssistantRestore * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (assistant_restore_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT_RESTORE (obj);
	_tmp0_ = _ ("Restore");
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	_tmp1_ = _ ("_Restore");
	assistant_set_apply_text ((Assistant*) self, _tmp1_);
	return obj;
}


static void assistant_restore_class_init (AssistantRestoreClass * klass) {
	assistant_restore_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantRestorePrivate));
	ASSISTANT_OPERATION_CLASS (klass)->add_setup_pages = assistant_restore_real_add_setup_pages;
	ASSISTANT_OPERATION_CLASS (klass)->add_custom_config_pages = assistant_restore_real_add_custom_config_pages;
	ASSISTANT_OPERATION_CLASS (klass)->make_confirm_page = assistant_restore_real_make_confirm_page;
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_restore_real_create_op;
	ASSISTANT_OPERATION_CLASS (klass)->get_progress_file_prefix = assistant_restore_real_get_progress_file_prefix;
	ASSISTANT_OPERATION_CLASS (klass)->set_op_icon_name = assistant_restore_real_set_op_icon_name;
	ASSISTANT_RESTORE_CLASS (klass)->handle_collection_dates = assistant_restore_real_handle_collection_dates;
	ASSISTANT_RESTORE_CLASS (klass)->query_finished = assistant_restore_real_query_finished;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_restore_real_do_prepare;
	ASSISTANT_OPERATION_CLASS (klass)->do_close = assistant_restore_real_do_close;
	G_OBJECT_CLASS (klass)->get_property = _vala_assistant_restore_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_assistant_restore_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_restore_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_restore_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_RESTORE_RESTORE_LOCATION, g_param_spec_string ("restore-location", "restore-location", "restore-location", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_RESTORE_RESTORE_FILES, g_param_spec_pointer ("restore-files", "restore-files", "restore-files", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void assistant_restore_instance_init (AssistantRestore * self) {
	gchar* _tmp0_;
	self->priv = ASSISTANT_RESTORE_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("/");
	self->priv->_restore_location = _tmp0_;
}


static void assistant_restore_finalize (GObject* obj) {
	AssistantRestore * self;
	self = ASSISTANT_RESTORE (obj);
	_g_free0 (self->priv->_restore_location);
	__g_list_free__g_object_unref0_0 (self->_restore_files);
	_g_object_unref0 (self->query_op);
	_deja_dup_operation_state_unref0 (self->op_state);
	_g_object_unref0 (self->priv->query_progress_bar);
	_g_object_unref0 (self->priv->date_combo);
	_g_object_unref0 (self->priv->date_store);
	_g_object_unref0 (self->priv->cust_box);
	_g_object_unref0 (self->priv->cust_button);
	_g_object_unref0 (self->priv->confirm_table);
	_g_object_unref0 (self->priv->confirm_location_label);
	_g_object_unref0 (self->priv->confirm_location);
	_g_object_unref0 (self->priv->confirm_date_label);
	_g_object_unref0 (self->priv->confirm_date);
	_g_object_unref0 (self->priv->confirm_files_label);
	_g_object_unref0 (self->priv->confirm_files);
	_g_object_unref0 (self->priv->query_progress_page);
	_g_object_unref0 (self->priv->date_page);
	_g_object_unref0 (self->priv->restore_dest_page);
	G_OBJECT_CLASS (assistant_restore_parent_class)->finalize (obj);
}


GType assistant_restore_get_type (void) {
	static volatile gsize assistant_restore_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_restore_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantRestoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_restore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantRestore), 0, (GInstanceInitFunc) assistant_restore_instance_init, NULL };
		GType assistant_restore_type_id;
		assistant_restore_type_id = g_type_register_static (TYPE_ASSISTANT_OPERATION, "AssistantRestore", &g_define_type_info, 0);
		g_once_init_leave (&assistant_restore_type_id__volatile, assistant_restore_type_id);
	}
	return assistant_restore_type_id__volatile;
}


static void _vala_assistant_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AssistantRestore * self;
	self = ASSISTANT_RESTORE (object);
	switch (property_id) {
		case ASSISTANT_RESTORE_RESTORE_LOCATION:
		g_value_set_string (value, assistant_restore_get_restore_location (self));
		break;
		case ASSISTANT_RESTORE_RESTORE_FILES:
		g_value_set_pointer (value, assistant_restore_get_restore_files (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_assistant_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AssistantRestore * self;
	self = ASSISTANT_RESTORE (object);
	switch (property_id) {
		case ASSISTANT_RESTORE_RESTORE_LOCATION:
		assistant_restore_set_restore_location (self, g_value_get_string (value));
		break;
		case ASSISTANT_RESTORE_RESTORE_FILES:
		assistant_restore_set_restore_files (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



